/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeStackCallInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeLibraryAllocationInfo {
    public static final String UNRESOLVED_LIBRARY_NAME = "Resolving..";
    private static final String UNKNOWN_LIBRARY_NAME = "unknown";
    private final String mLibraryName;
    private final List<NativeAllocationInfo> mHeapAllocations;
    private int mTotalSize;

    private NativeLibraryAllocationInfo(String string) {
        this.mLibraryName = string;
        this.mHeapAllocations = new ArrayList<NativeAllocationInfo>();
    }

    private void addAllocation(NativeAllocationInfo nativeAllocationInfo) {
        this.mHeapAllocations.add(nativeAllocationInfo);
    }

    private void updateTotalSize() {
        this.mTotalSize = 0;
        for (NativeAllocationInfo nativeAllocationInfo : this.mHeapAllocations) {
            this.mTotalSize += nativeAllocationInfo.getAllocationCount() * nativeAllocationInfo.getSize();
        }
    }

    public String getLibraryName() {
        return this.mLibraryName;
    }

    public long getTotalSize() {
        return this.mTotalSize;
    }

    public List<NativeAllocationInfo> getAllocations() {
        return this.mHeapAllocations;
    }

    public static List<NativeLibraryAllocationInfo> constructFrom(List<NativeAllocationInfo> list) {
        Object object;
        if (list == null) {
            return null;
        }
        HashMap<String, NativeLibraryAllocationInfo> hashMap = new HashMap<String, NativeLibraryAllocationInfo>();
        for (NativeAllocationInfo object22 : list) {
            object = UNRESOLVED_LIBRARY_NAME;
            if (object22.isStackCallResolved()) {
                NativeStackCallInfo nativeStackCallInfo = object22.getRelevantStackCallInfo();
                object = nativeStackCallInfo != null ? nativeStackCallInfo.getLibraryName() : UNKNOWN_LIBRARY_NAME;
            }
            NativeLibraryAllocationInfo.addtoLibrary(hashMap, (String)object, object22);
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (NativeLibraryAllocationInfo)iterator.next();
            super.updateTotalSize();
        }
        Collections.sort(arrayList, new Comparator<NativeLibraryAllocationInfo>(){

            @Override
            public int compare(NativeLibraryAllocationInfo nativeLibraryAllocationInfo, NativeLibraryAllocationInfo nativeLibraryAllocationInfo2) {
                return (int)(nativeLibraryAllocationInfo2.getTotalSize() - nativeLibraryAllocationInfo.getTotalSize());
            }
        });
        return arrayList;
    }

    private static void addtoLibrary(Map<String, NativeLibraryAllocationInfo> map, String string, NativeAllocationInfo nativeAllocationInfo) {
        NativeLibraryAllocationInfo nativeLibraryAllocationInfo = map.get(string);
        if (nativeLibraryAllocationInfo == null) {
            nativeLibraryAllocationInfo = new NativeLibraryAllocationInfo(string);
            map.put(string, nativeLibraryAllocationInfo);
        }
        nativeLibraryAllocationInfo.addAllocation(nativeAllocationInfo);
    }
}

