/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.log.event.EventDisplay;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayLog
extends EventDisplay {
    private static final String PREFS_COL_DATE = "EventLogPanel.log.Col1";
    private static final String PREFS_COL_PID = "EventLogPanel.log.Col2";
    private static final String PREFS_COL_EVENTTAG = "EventLogPanel.log.Col3";
    private static final String PREFS_COL_VALUENAME = "EventLogPanel.log.Col4";
    private static final String PREFS_COL_VALUE = "EventLogPanel.log.Col5";
    private static final String PREFS_COL_TYPE = "EventLogPanel.log.Col6";

    public DisplayLog(String string) {
        super(string);
    }

    @Override
    void resetUI() {
        this.mLogTable.removeAll();
    }

    @Override
    void newEvent(EventContainer eventContainer, EventLogParser eventLogParser) {
        this.addToLog(eventContainer, eventLogParser);
    }

    @Override
    Control createComposite(Composite composite, EventLogParser eventLogParser, EventDisplay.ILogColumnListener iLogColumnListener) {
        return this.createLogUI(composite, iLogColumnListener);
    }

    private void addToLog(EventContainer eventContainer, EventLogParser eventLogParser) {
        ScrollBar scrollBar = this.mLogTable.getVerticalBar();
        boolean bl = scrollBar.getMaximum() == scrollBar.getSelection() + scrollBar.getThumb();
        Calendar calendar = Calendar.getInstance();
        long l = (long)eventContainer.sec * 1000L;
        calendar.setTimeInMillis(l);
        String string = String.format("%1$tF %1$tT", calendar);
        String string2 = (String)eventLogParser.getTagMap().get(eventContainer.mTag);
        String string3 = Integer.toString(eventContainer.pid);
        EventValueDescription[] eventValueDescriptionArray = (EventValueDescription[])eventLogParser.getEventInfoMap().get(eventContainer.mTag);
        if (eventValueDescriptionArray != null) {
            int n;
            for (n = 0; n < eventValueDescriptionArray.length; ++n) {
                EventValueDescription eventValueDescription = eventValueDescriptionArray[n];
                try {
                    String string4 = eventContainer.getValueAsString(n);
                    this.logValue(string, string3, string2, eventValueDescription.getName(), string4, eventValueDescription.getEventValueType(), eventValueDescription.getValueType());
                    continue;
                }
                catch (InvalidTypeException invalidTypeException) {
                    this.logValue(string, string3, string2, eventValueDescription.getName(), invalidTypeException.getMessage(), eventValueDescription.getEventValueType(), eventValueDescription.getValueType());
                }
            }
            if (bl && (n = this.mLogTable.getItemCount()) > 0) {
                this.mLogTable.showItem(this.mLogTable.getItem(n - 1));
            }
        }
    }

    protected void addToLog(EventContainer eventContainer, EventLogParser eventLogParser, ArrayList<EventDisplay.ValueDisplayDescriptor> arrayList, ArrayList<EventDisplay.OccurrenceDisplayDescriptor> arrayList2) {
        int n;
        ScrollBar scrollBar = this.mLogTable.getVerticalBar();
        boolean bl = scrollBar.getMaximum() == scrollBar.getSelection() + scrollBar.getThumb();
        Calendar calendar = Calendar.getInstance();
        long l = (long)eventContainer.sec * 1000L;
        calendar.setTimeInMillis(l);
        String string = String.format("%1$tF %1$tT", calendar);
        String string2 = (String)eventLogParser.getTagMap().get(eventContainer.mTag);
        String string3 = Integer.toString(eventContainer.pid);
        if (arrayList.size() > 0) {
            for (EventDisplay.ValueDisplayDescriptor valueDisplayDescriptor : arrayList) {
                this.logDescriptor(eventContainer, valueDisplayDescriptor, string, string3, string2, eventLogParser);
            }
        }
        if (bl && (n = this.mLogTable.getItemCount()) > 0) {
            this.mLogTable.showItem(this.mLogTable.getItem(n - 1));
        }
    }

    private void logValue(String string, String string2, String string3, String string4, String string5, EventContainer.EventValueType eventValueType, EventValueDescription.ValueType valueType) {
        TableItem tableItem = new TableItem(this.mLogTable, 0);
        tableItem.setText(0, string);
        tableItem.setText(1, string2);
        tableItem.setText(2, string3);
        tableItem.setText(3, string4);
        tableItem.setText(4, string5);
        String string6 = valueType != EventValueDescription.ValueType.NOT_APPLICABLE ? String.format("%1$s, %2$s", eventValueType.toString(), valueType.toString()) : eventValueType.toString();
        tableItem.setText(5, string6);
    }

    private void logDescriptor(EventContainer eventContainer, EventDisplay.ValueDisplayDescriptor valueDisplayDescriptor, String string, String string2, String string3, EventLogParser eventLogParser) {
        String string4;
        try {
            string4 = eventContainer.getValueAsString(valueDisplayDescriptor.valueIndex);
        }
        catch (InvalidTypeException invalidTypeException) {
            string4 = invalidTypeException.getMessage();
        }
        EventValueDescription[] eventValueDescriptionArray = (EventValueDescription[])eventLogParser.getEventInfoMap().get(eventContainer.mTag);
        EventValueDescription eventValueDescription = eventValueDescriptionArray[valueDisplayDescriptor.valueIndex];
        this.logValue(string, string2, string3, valueDisplayDescriptor.valueName, string4, eventValueDescription.getEventValueType(), eventValueDescription.getValueType());
    }

    private Control createLogUI(Composite composite, final EventDisplay.ILogColumnListener iLogColumnListener) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite2.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                DisplayLog.this.mLogTable = null;
            }
        });
        Label label = new Label(composite2, 0x1000000);
        label.setText(this.mName);
        label.setLayoutData((Object)new GridData(768));
        this.mLogTable = new Table(composite2, 68098);
        this.mLogTable.setLayoutData((Object)new GridData(1808));
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        TableColumn tableColumn = TableHelper.createTableColumn(this.mLogTable, "Time", 16384, "0000-00-00 00:00:00", PREFS_COL_DATE, iPreferenceStore);
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Object object = controlEvent.getSource();
                if (object instanceof TableColumn) {
                    iLogColumnListener.columnResized(0, (TableColumn)object);
                }
            }
        });
        tableColumn = TableHelper.createTableColumn(this.mLogTable, "pid", 16384, "0000", PREFS_COL_PID, iPreferenceStore);
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Object object = controlEvent.getSource();
                if (object instanceof TableColumn) {
                    iLogColumnListener.columnResized(1, (TableColumn)object);
                }
            }
        });
        tableColumn = TableHelper.createTableColumn(this.mLogTable, "Event", 16384, "abcdejghijklmno", PREFS_COL_EVENTTAG, iPreferenceStore);
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Object object = controlEvent.getSource();
                if (object instanceof TableColumn) {
                    iLogColumnListener.columnResized(2, (TableColumn)object);
                }
            }
        });
        tableColumn = TableHelper.createTableColumn(this.mLogTable, "Name", 16384, "Process Name", PREFS_COL_VALUENAME, iPreferenceStore);
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Object object = controlEvent.getSource();
                if (object instanceof TableColumn) {
                    iLogColumnListener.columnResized(3, (TableColumn)object);
                }
            }
        });
        tableColumn = TableHelper.createTableColumn(this.mLogTable, "Value", 16384, "0000000", PREFS_COL_VALUE, iPreferenceStore);
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Object object = controlEvent.getSource();
                if (object instanceof TableColumn) {
                    iLogColumnListener.columnResized(4, (TableColumn)object);
                }
            }
        });
        tableColumn = TableHelper.createTableColumn(this.mLogTable, "Type", 16384, "long, seconds", PREFS_COL_TYPE, iPreferenceStore);
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Object object = controlEvent.getSource();
                if (object instanceof TableColumn) {
                    iLogColumnListener.columnResized(5, (TableColumn)object);
                }
            }
        });
        this.mLogTable.setHeaderVisible(true);
        this.mLogTable.setLinesVisible(true);
        return composite2;
    }

    @Override
    void resizeColumn(int n, TableColumn tableColumn) {
        TableColumn tableColumn2;
        if (this.mLogTable != null && (tableColumn2 = this.mLogTable.getColumn(n)) != tableColumn) {
            tableColumn2.setWidth(tableColumn.getWidth());
        }
    }

    @Override
    int getDisplayType() {
        return 0;
    }
}

