/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.Log;
import com.android.ddmuilib.logcat.LogCatFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogCatFilterSettingsSerializer {
    private static final char SINGLE_QUOTE = '\'';
    private static final char ESCAPE_CHAR = '\\';
    private static final String ATTR_DELIM = ", ";
    private static final String KW_DELIM = ": ";
    private static final String KW_NAME = "name";
    private static final String KW_TAG = "tag";
    private static final String KW_TEXT = "text";
    private static final String KW_PID = "pid";
    private static final String KW_APP = "app";
    private static final String KW_LOGLEVEL = "level";

    public String encodeToPreferenceString(List<LogCatFilter> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (LogCatFilter logCatFilter : list) {
            if (logCatFilter.isTransient()) continue;
            stringBuffer.append(KW_NAME);
            stringBuffer.append(KW_DELIM);
            stringBuffer.append(this.quoteString(logCatFilter.getName()));
            stringBuffer.append(ATTR_DELIM);
            stringBuffer.append(KW_TAG);
            stringBuffer.append(KW_DELIM);
            stringBuffer.append(this.quoteString(logCatFilter.getTag()));
            stringBuffer.append(ATTR_DELIM);
            stringBuffer.append(KW_TEXT);
            stringBuffer.append(KW_DELIM);
            stringBuffer.append(this.quoteString(logCatFilter.getText()));
            stringBuffer.append(ATTR_DELIM);
            stringBuffer.append(KW_PID);
            stringBuffer.append(KW_DELIM);
            stringBuffer.append(this.quoteString(logCatFilter.getPid()));
            stringBuffer.append(ATTR_DELIM);
            stringBuffer.append(KW_APP);
            stringBuffer.append(KW_DELIM);
            stringBuffer.append(this.quoteString(logCatFilter.getAppName()));
            stringBuffer.append(ATTR_DELIM);
            stringBuffer.append(KW_LOGLEVEL);
            stringBuffer.append(KW_DELIM);
            stringBuffer.append(this.quoteString(logCatFilter.getLogLevel().getStringValue()));
            stringBuffer.append(ATTR_DELIM);
        }
        return stringBuffer.toString();
    }

    public List<LogCatFilter> decodeFromPreferenceString(String string) {
        ArrayList<LogCatFilter> arrayList = new ArrayList<LogCatFilter>();
        List<String> list = this.getKeyValues(string);
        if (list.size() == 0) {
            return arrayList;
        }
        int n = 0;
        while (n < list.size()) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            Log.LogLevel logLevel = Log.LogLevel.VERBOSE;
            assert (list.get(n).equals(KW_NAME));
            string2 = list.get(n + 1);
            n += 2;
            while (n < list.size() && !list.get(n).equals(KW_NAME)) {
                String string7 = list.get(n);
                String string8 = list.get(n + 1);
                n += 2;
                if (string7.equals(KW_TAG)) {
                    string3 = string8;
                    continue;
                }
                if (string7.equals(KW_TEXT)) {
                    string6 = string8;
                    continue;
                }
                if (string7.equals(KW_PID)) {
                    string4 = string8;
                    continue;
                }
                if (string7.equals(KW_APP)) {
                    string5 = string8;
                    continue;
                }
                if (!string7.equals(KW_LOGLEVEL)) continue;
                logLevel = Log.LogLevel.getByString((String)string8);
            }
            arrayList.add(new LogCatFilter(string2, string3, string6, string4, string5, logLevel));
        }
        return arrayList;
    }

    private List<String> getKeyValues(String string) {
        String string2;
        String string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length() && (string2 = this.getKeyword(string.substring(i))) != null; i += string3.length() + ATTR_DELIM.length()) {
            string3 = this.getNextString(string.substring(i += string2.length() + KW_DELIM.length()));
            string3 = this.unquoteString(string3);
            arrayList.add(string2);
            arrayList.add(string3);
        }
        return arrayList;
    }

    private String quoteString(String string) {
        return '\'' + string.replace(Character.toString('\''), "\\'") + '\'';
    }

    private String unquoteString(String string) {
        string = string.substring(1, string.length() - 1);
        return string.replace("\\'", Character.toString('\''));
    }

    private String getKeyword(String string) {
        int n = string.indexOf(KW_DELIM);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    private String getNextString(String string) {
        assert (string.charAt(0) == '\'');
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(string.charAt(i));
            if (i > 0 && string.charAt(i) == '\'' && string.charAt(i - 1) != '\\') break;
        }
        return stringBuffer.toString();
    }
}

