/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmuilib.logcat.ILogCatBufferChangeListener;
import com.android.ddmuilib.logcat.LogCatMessage;
import com.android.ddmuilib.logcat.LogCatMessageList;
import com.android.ddmuilib.logcat.LogCatMessageParser;
import com.android.ddmuilib.logcat.LogCatPidToNameMapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogCatReceiver {
    private static final String LOGCAT_COMMAND = "logcat -v long";
    private static final int DEVICE_POLL_INTERVAL_MSEC = 1000;
    private static LogCatMessage DEVICE_DISCONNECTED_MESSAGE = new LogCatMessage(Log.LogLevel.ERROR, "", "", "", "", "", "Device disconnected");
    private LogCatMessageList mLogMessages;
    private IDevice mCurrentDevice;
    private LogCatOutputReceiver mCurrentLogCatOutputReceiver;
    private Set<ILogCatBufferChangeListener> mLogCatMessageListeners;
    private LogCatMessageParser mLogCatMessageParser;
    private LogCatPidToNameMapper mPidToNameMapper;
    private IPreferenceStore mPrefStore;

    public LogCatReceiver(IDevice iDevice, IPreferenceStore iPreferenceStore) {
        this.mCurrentDevice = iDevice;
        this.mPrefStore = iPreferenceStore;
        this.mLogCatMessageListeners = new HashSet<ILogCatBufferChangeListener>();
        this.mLogCatMessageParser = new LogCatMessageParser();
        this.mPidToNameMapper = new LogCatPidToNameMapper(this.mCurrentDevice);
        this.mLogMessages = new LogCatMessageList(this.getFifoSize());
        this.startReceiverThread();
    }

    public void stop() {
        if (this.mCurrentLogCatOutputReceiver != null) {
            this.mCurrentLogCatOutputReceiver.mIsCancelled = true;
            this.mCurrentLogCatOutputReceiver = null;
            this.processLogMessages(Collections.singletonList(DEVICE_DISCONNECTED_MESSAGE));
        }
        this.mCurrentDevice = null;
    }

    private int getFifoSize() {
        int n = this.mPrefStore.getInt("logcat.messagelist.max.size");
        return n == 0 ? 5000 : n;
    }

    private void startReceiverThread() {
        this.mCurrentLogCatOutputReceiver = new LogCatOutputReceiver();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (LogCatReceiver.this.mCurrentDevice != null && !LogCatReceiver.this.mCurrentDevice.isOnline()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                try {
                    if (LogCatReceiver.this.mCurrentDevice != null) {
                        LogCatReceiver.this.mCurrentDevice.executeShellCommand(LogCatReceiver.LOGCAT_COMMAND, (IShellOutputReceiver)LogCatReceiver.this.mCurrentLogCatOutputReceiver, 0);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"Unexpected error while launching logcat. Try reselecting the device.", (Throwable)exception);
                }
            }
        });
        thread.setName("LogCat output receiver for " + this.mCurrentDevice.getSerialNumber());
        thread.start();
    }

    private void processLogLines(String[] stringArray) {
        List<LogCatMessage> list = this.mLogCatMessageParser.processLogLines(stringArray, this.mPidToNameMapper);
        this.processLogMessages(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLogMessages(List<LogCatMessage> list) {
        if (list.size() > 0) {
            List<LogCatMessage> list2;
            LogCatMessageList logCatMessageList = this.mLogMessages;
            synchronized (logCatMessageList) {
                list2 = this.mLogMessages.ensureSpace(list.size());
                this.mLogMessages.appendMessages(list);
            }
            this.sendLogChangedEvent(list, list2);
        }
    }

    public LogCatMessageList getMessages() {
        return this.mLogMessages;
    }

    public void clearMessages() {
        this.mLogMessages.clear();
    }

    public void addMessageReceivedEventListener(ILogCatBufferChangeListener iLogCatBufferChangeListener) {
        this.mLogCatMessageListeners.add(iLogCatBufferChangeListener);
    }

    public void removeMessageReceivedEventListener(ILogCatBufferChangeListener iLogCatBufferChangeListener) {
        this.mLogCatMessageListeners.remove(iLogCatBufferChangeListener);
    }

    private void sendLogChangedEvent(List<LogCatMessage> list, List<LogCatMessage> list2) {
        for (ILogCatBufferChangeListener iLogCatBufferChangeListener : this.mLogCatMessageListeners) {
            iLogCatBufferChangeListener.bufferChanged(list, list2);
        }
    }

    public void resizeFifo(int n) {
        this.mLogMessages.resize(n);
    }

    private class LogCatOutputReceiver
    extends MultiLineReceiver {
        private boolean mIsCancelled;

        public LogCatOutputReceiver() {
            this.setTrimLine(false);
        }

        public boolean isCancelled() {
            return this.mIsCancelled;
        }

        public void processNewLines(String[] stringArray) {
            if (!this.mIsCancelled) {
                LogCatReceiver.this.processLogLines(stringArray);
            }
        }
    }
}

