/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.logcat.LogCatReceiver;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;

public class LogCatReceiverFactory {
    public static final LogCatReceiverFactory INSTANCE = new LogCatReceiverFactory();
    private Map<String, LogCatReceiver> mReceiverCache = new HashMap<String, LogCatReceiver>();

    private LogCatReceiverFactory() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceDisconnected(final IDevice iDevice) {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        LogCatReceiverFactory.this.removeReceiverFor(iDevice);
                    }
                }, "Remove logcat receiver for " + iDevice.getSerialNumber());
                thread.start();
            }

            public void deviceConnected(IDevice iDevice) {
            }

            public void deviceChanged(IDevice iDevice, int n) {
            }
        });
    }

    private synchronized void removeReceiverFor(IDevice iDevice) {
        LogCatReceiver logCatReceiver = this.mReceiverCache.get(iDevice.getSerialNumber());
        if (logCatReceiver != null) {
            logCatReceiver.stop();
            this.mReceiverCache.remove(iDevice.getSerialNumber());
        }
    }

    public synchronized LogCatReceiver newReceiver(IDevice iDevice, IPreferenceStore iPreferenceStore) {
        LogCatReceiver logCatReceiver = this.mReceiverCache.get(iDevice.getSerialNumber());
        if (logCatReceiver != null) {
            return logCatReceiver;
        }
        logCatReceiver = new LogCatReceiver(iDevice, iPreferenceStore);
        this.mReceiverCache.put(iDevice.getSerialNumber(), logCatReceiver);
        return logCatReceiver;
    }
}

