/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.GradientPanel;
import com.android.draw9patch.ui.ImageEditorPanel;
import com.android.draw9patch.ui.OpenFilePanel;
import com.android.draw9patch.ui.PngFileFilter;
import com.android.draw9patch.ui.action.ExitAction;
import com.android.draw9patch.ui.action.OpenAction;
import com.android.draw9patch.ui.action.SaveAction;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame {
    private ActionMap actionsMap;
    private JMenuItem saveMenuItem;
    private ImageEditorPanel imageEditor;
    private static final String TITLE_FORMAT = "Draw 9-patch: %s";

    public MainFrame(String string) throws HeadlessException {
        super("Draw 9-patch");
        this.buildActions();
        this.buildMenuBar();
        this.buildContent();
        if (string == null) {
            this.showOpenFilePanel();
        } else {
            try {
                File file = new File(string);
                BufferedImage bufferedImage = GraphicsUtilities.loadCompatibleImage(file.toURI().toURL());
                this.showImageEditor(bufferedImage, file.getAbsolutePath());
                this.setTitle(String.format(TITLE_FORMAT, string));
            }
            catch (Exception exception) {
                this.showOpenFilePanel();
            }
        }
        this.setSize(1024, 600);
    }

    private void buildActions() {
        this.actionsMap = new ActionMap();
        this.actionsMap.put("open", new OpenAction(this));
        this.actionsMap.put("save", new SaveAction(this));
        this.actionsMap.put("exit", new ExitAction(this));
    }

    private void buildMenuBar() {
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem.setAction(this.actionsMap.get("open"));
        jMenu.add(jMenuItem);
        this.saveMenuItem.setAction(this.actionsMap.get("save"));
        this.saveMenuItem.setEnabled(false);
        jMenu.add(this.saveMenuItem);
        jMenuItem2.setAction(this.actionsMap.get("exit"));
        jMenu.add(jMenuItem2);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    private void buildContent() {
        this.setContentPane(new GradientPanel());
    }

    private void showOpenFilePanel() {
        this.add(new OpenFilePanel(this));
    }

    public SwingWorker<?, ?> open(File file) {
        if (file == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new PngFileFilter());
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                return new OpenTask(jFileChooser.getSelectedFile());
            }
            return null;
        }
        return new OpenTask(file);
    }

    void showImageEditor(BufferedImage bufferedImage, String string) {
        this.getContentPane().removeAll();
        this.imageEditor = new ImageEditorPanel(this, bufferedImage, string);
        this.add(this.imageEditor);
        this.saveMenuItem.setEnabled(true);
        this.validate();
        this.repaint();
    }

    public SwingWorker<?, ?> save() {
        if (this.imageEditor == null) {
            return null;
        }
        File file = this.imageEditor.chooseSaveFile();
        return file != null ? new SaveTask(file) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OpenTask
    extends SwingWorker<BufferedImage, Void> {
        private final File file;

        OpenTask(File file) {
            this.file = file;
        }

        protected BufferedImage doInBackground() throws Exception {
            return GraphicsUtilities.loadCompatibleImage(this.file.toURI().toURL());
        }

        protected void done() {
            try {
                MainFrame.this.showImageEditor((BufferedImage)this.get(), this.file.getAbsolutePath());
                MainFrame.this.setTitle(String.format(MainFrame.TITLE_FORMAT, this.file.getAbsolutePath()));
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SaveTask
    extends SwingWorker<Boolean, Void> {
        private final File file;

        SaveTask(File file) {
            this.file = file;
        }

        protected Boolean doInBackground() throws Exception {
            try {
                ImageIO.write(MainFrame.this.imageEditor.getImage(), "PNG", this.file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
    }
}

