/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.emma.AppLoggers;
import com.vladium.emma.EMMAProperties;
import com.vladium.logging.Logger;
import com.vladium.util.IProperties;
import java.util.Properties;

public abstract class Processor {
    protected String m_appName;
    protected IProperties m_propertyOverrides;
    protected Logger m_log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        this.validateState();
        Object object = EMMAProperties.getAppProperties();
        IProperties iProperties = IProperties.Factory.combine(this.m_propertyOverrides, (IProperties)object);
        object = Logger.getLogger();
        Logger logger = AppLoggers.create(this.m_appName, iProperties, (Logger)object);
        if (logger.atTRACE1()) {
            logger.trace1("run", "complete tool properties:");
            iProperties.list(logger.getWriter());
        }
        try {
            Logger.push(logger);
            this.m_log = logger;
            this._run(iProperties);
        }
        finally {
            if (this.m_log != null) {
                Logger.pop(this.m_log);
                this.m_log = null;
            }
        }
    }

    public final synchronized void setAppName(String string) {
        this.m_appName = string;
    }

    public final synchronized void setPropertyOverrides(Properties properties) {
        this.m_propertyOverrides = EMMAProperties.wrap(properties);
    }

    public final synchronized void setPropertyOverrides(IProperties iProperties) {
        this.m_propertyOverrides = iProperties;
    }

    protected Processor() {
    }

    protected abstract void _run(IProperties var1);

    protected void validateState() {
    }
}

