/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.lcov;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.ItemComparator;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Descriptors;
import com.vladium.util.Files;
import com.vladium.util.IProperties;
import com.vladium.util.IntObjectMap;
import com.vladium.util.asserts.$assert;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public final class ReportGenerator
extends AbstractReportGenerator
implements IAppErrorCodes {
    private LinkedList m_queue;
    private BufferedWriter m_out;
    private static final String TYPE = "lcov";
    private static final int IO_BUF_SIZE = 32768;

    public String getType() {
        return TYPE;
    }

    public void process(IMetaData iMetaData, ICoverageData iCoverageData, SourcePathCache sourcePathCache, IProperties iProperties) throws EMMARuntimeException {
        this.initialize(iMetaData, iCoverageData, sourcePathCache, iProperties);
        long l = 0L;
        boolean bl = this.m_log.atTRACE1();
        if (bl) {
            l = System.currentTimeMillis();
        }
        this.m_queue = new LinkedList();
        this.m_queue.add(this.m_view.getRoot());
        while (!this.m_queue.isEmpty()) {
            IItem iItem = (IItem)this.m_queue.removeFirst();
            iItem.accept(this, null);
        }
        this.close();
        if (bl) {
            long l2 = System.currentTimeMillis();
            this.m_log.trace1("process", "[" + this.getType() + "] report generated in " + (l2 - l) + " ms");
        }
    }

    public void cleanup() {
        this.m_queue = null;
        this.close();
        super.cleanup();
    }

    public Object visit(AllItem allItem, Object object) {
        File file = this.m_settings.getOutFile();
        if (file == null) {
            file = new File("coverage.lcov");
            this.m_settings.setOutFile(file);
        }
        File file2 = Files.newFile(this.m_settings.getOutDir(), file);
        this.m_log.info("writing [" + this.getType() + "] report to [" + file2.getAbsolutePath() + "] ...");
        this.openOutFile(file2, this.m_settings.getOutEncoding(), true);
        ItemComparator itemComparator = this.m_typeSortComparators[PackageItem.getTypeMetadata().getTypeID()];
        Iterator iterator = allItem.getChildren(itemComparator);
        while (iterator.hasNext()) {
            IItem iItem = (IItem)iterator.next();
            this.m_queue.addLast(iItem);
        }
        return object;
    }

    public Object visit(PackageItem packageItem, Object object) {
        if (this.m_verbose) {
            this.m_log.verbose("  report: processing package [" + packageItem.getName() + "] ...");
        }
        int n = this.m_srcView ? SrcFileItem.getTypeMetadata().getTypeID() : ClassItem.getTypeMetadata().getTypeID();
        ItemComparator itemComparator = this.m_typeSortComparators[n];
        Iterator iterator = packageItem.getChildren(itemComparator);
        while (iterator.hasNext()) {
            IItem iItem = (IItem)iterator.next();
            this.m_queue.addLast(iItem);
        }
        return object;
    }

    public Object visit(SrcFileItem srcFileItem, Object object) {
        this.row("SF:".concat(srcFileItem.getFullVMName()));
        this.emitFileCoverage(srcFileItem);
        this.row("end_of_record");
        return object;
    }

    private void emitFileCoverage(SrcFileItem srcFileItem) {
        String string = srcFileItem.getFullVMName();
        String string2 = ((PackageItem)srcFileItem.getParent()).getVMName();
        if (!this.m_hasLineNumberInfo) {
            this.m_log.info("source file '" + Descriptors.combineVMName(string2, string) + "' has no line number information");
        }
        boolean bl = false;
        try {
            Object object;
            ItemComparator itemComparator = this.m_typeSortComparators[ClassItem.getTypeMetadata().getTypeID()];
            int n = 0;
            Object object2 = srcFileItem.getChildren(itemComparator);
            while (object2.hasNext()) {
                ClassItem classItem = (ClassItem)object2.next();
                String string3 = classItem.getName();
                object = classItem.getClassDescriptor();
                boolean[][] blArray = classItem.getCoverage();
                ItemComparator itemComparator2 = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
                Iterator iterator = classItem.getChildren(itemComparator2);
                while (iterator.hasNext()) {
                    MethodItem methodItem = (MethodItem)iterator.next();
                    String string4 = methodItem.getName();
                    int n2 = methodItem.getID();
                    boolean bl2 = false;
                    if (blArray != null) {
                        bl2 = blArray[n2][0];
                    }
                    this.row("FN:" + methodItem.getFirstLine() + "," + string3 + "::" + string4);
                    this.row("FNDA:" + (bl2 ? 1 : 0) + "," + string3 + "::" + string4);
                }
                ++n;
            }
            int n3 = this.m_settings.getUnitsType();
            IntObjectMap intObjectMap = null;
            object2 = null;
            intObjectMap = srcFileItem.getLineCoverage();
            $assert.ASSERT(intObjectMap != null, "null: lineCoverageMap");
            object2 = intObjectMap.keys();
            Arrays.sort((int[])object2);
            block9: for (int i = 0; i < ((Object)object2).length; ++i) {
                Object object3 = object2[i];
                object = (SrcFileItem.LineCoverageData)intObjectMap.get((int)object3);
                switch (((SrcFileItem.LineCoverageData)object).m_coverageStatus) {
                    case 0: {
                        this.row("DA:" + (int)object3 + ",0");
                        continue block9;
                    }
                    case 1: {
                        this.row("DA:" + (int)object3 + ",1");
                        continue block9;
                    }
                    case 2: {
                        this.row("DA:" + (int)object3 + ",1");
                        continue block9;
                    }
                    default: {
                        $assert.ASSERT(false, "invalid line coverage status: " + ((SrcFileItem.LineCoverageData)object).m_coverageStatus);
                    }
                }
            }
            bl = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            bl = false;
        }
        if (!bl) {
            this.m_log.info("[source file '" + Descriptors.combineVMName(string2, string) + "' not found in sourcepath]");
        }
    }

    public Object visit(ClassItem classItem, Object object) {
        return object;
    }

    private void row(StringBuffer stringBuffer) {
        try {
            this.m_out.write(stringBuffer.toString());
            this.m_out.newLine();
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
    }

    private void row(String string) {
        try {
            this.m_out.write(string);
            this.m_out.newLine();
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
    }

    private void close() {
        if (this.m_out != null) {
            try {
                this.m_out.flush();
                this.m_out.close();
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
            }
            finally {
                this.m_out = null;
            }
        }
    }

    private void openOutFile(File file, String string, boolean bl) {
        try {
            File file2;
            if (bl && (file2 = file.getParentFile()) != null) {
                file2.mkdirs();
            }
            file.delete();
            if (file.exists()) {
                throw new EMMARuntimeException("Failed to delete " + file);
            }
            this.m_out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string), 32768);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EMMARuntimeException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException(iOException);
        }
    }
}

