/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.rt.RTCoverageDataPersister;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;

final class RTExitHook
implements Runnable {
    private final File m_outFile;
    private final boolean m_merge;
    private Class m_RT;
    private ICoverageData m_cdata;
    private static final String CLOSURE_RESOURCE = "RTExitHook.closure";

    public synchronized void run() {
        if (this.m_cdata != null) {
            RTCoverageDataPersister.dumpCoverageData(this.m_cdata, true, this.m_outFile, this.m_merge);
            this.m_RT = null;
            this.m_cdata = null;
        }
    }

    public static void createClassLoaderClosure() {
        InputStream inputStream;
        Properties properties;
        block15: {
            properties = null;
            inputStream = null;
            try {
                inputStream = RTExitHook.class.getResourceAsStream(CLOSURE_RESOURCE);
                if (inputStream != null) {
                    properties = new Properties();
                    properties.load(inputStream);
                    break block15;
                }
                throw new Error("packaging failure: closure resource not found");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                throw new Error("packaging failure: " + exception.toString());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        inputStream = null;
        String string = properties.getProperty("closure");
        if (string == null) {
            throw new Error("packaging failure: no closure mapping");
        }
        ClassLoader classLoader = RTExitHook.class.getClassLoader();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                Class.forName(string2, true, classLoader);
            }
            catch (Exception exception) {
                throw new Error("packaging failure: class [" + string2 + "] not found {" + exception.toString() + "}");
            }
        }
    }

    RTExitHook(Class clazz, ICoverageData iCoverageData, File file, boolean bl) {
        this.m_RT = clazz;
        this.m_cdata = iCoverageData;
        this.m_outFile = file;
        this.m_merge = bl;
    }
}

