/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.Field_info;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IFieldCollection;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.IntVector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class FieldCollection
implements IFieldCollection {
    private List m_fields;

    public Field_info get(int n) {
        return (Field_info)this.m_fields.get(n);
    }

    public int[] get(ClassDef classDef, String string) {
        if (classDef == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        int n = this.m_fields.size();
        IntVector intVector = new IntVector(n);
        for (int i = 0; i < n; ++i) {
            Field_info field_info = (Field_info)this.m_fields.get(i);
            if (!field_info.getName(classDef).equals(string)) continue;
            intVector.add(i);
        }
        return intVector.values();
    }

    public int size() {
        return this.m_fields.size();
    }

    public Object clone() {
        try {
            FieldCollection fieldCollection = (FieldCollection)super.clone();
            int n = this.m_fields.size();
            fieldCollection.m_fields = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                fieldCollection.m_fields.add(((Field_info)this.m_fields.get(i)).clone());
            }
            return fieldCollection;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        int n = this.m_fields.size();
        uDataOutputStream.writeU2(n);
        for (int i = 0; i < n; ++i) {
            this.get(i).writeInClassFormat(uDataOutputStream);
        }
    }

    public void accept(IClassDefVisitor iClassDefVisitor, Object object) {
        iClassDefVisitor.visit(this, object);
    }

    public int add(Field_info field_info) {
        int n = this.m_fields.size();
        this.m_fields.add(field_info);
        return n;
    }

    public Field_info set(int n, Field_info field_info) {
        return this.m_fields.set(n, field_info);
    }

    FieldCollection(int n) {
        this.m_fields = n < 0 ? new ArrayList() : new ArrayList(n);
    }
}

