/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import java.io.InputStream;

public final class ByteArrayIStream
extends InputStream {
    private final byte[] m_buf;
    private final int m_max;
    private int m_pos;
    private static final int NATIVE_COPY_THRESHOLD = 9;

    public ByteArrayIStream(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public ByteArrayIStream(byte[] byArray, int n) {
        this.m_buf = byArray;
        this.m_max = n;
    }

    public final int read() {
        if (this.m_pos >= this.m_max) {
            return -1;
        }
        return 0xFF & this.m_buf[this.m_pos++];
    }

    public final int read(byte[] byArray, int n, int n2) {
        int n3 = this.m_pos;
        int n4 = this.m_max;
        if (n3 >= n4) {
            return -1;
        }
        if (n3 + n2 > n4) {
            n2 = n4 - n3;
        }
        if (n2 <= 0) {
            return 0;
        }
        byte[] byArray2 = this.m_buf;
        if (n2 < 9) {
            for (int i = 0; i < n2; ++i) {
                byArray[n + i] = byArray2[n3 + i];
            }
        } else {
            System.arraycopy(byArray2, n3, byArray, n, n2);
        }
        this.m_pos += n2;
        return n2;
    }

    public final int available() {
        return this.m_max - this.m_pos;
    }

    public final long skip(long l) {
        if ((long)this.m_pos + l > (long)this.m_max) {
            l = this.m_max - this.m_pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.m_pos = (int)((long)this.m_pos + l);
        return l;
    }

    public final void reset() {
        this.m_pos = 0;
    }

    public final void close() {
        this.reset();
    }
}

