/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.ClusterChainDirectory;
import de.waldheinz.fs.fat.DirectoryFullException;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.FatDirectoryEntry;
import de.waldheinz.fs.fat.ShortName;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDirectory {
    public static final int MAX_LABEL_LENGTH = 11;
    private final List<FatDirectoryEntry> entries = new ArrayList<FatDirectoryEntry>();
    private final boolean readOnly;
    private final boolean isRoot;
    private boolean dirty;
    private int capacity;
    private String volumeLabel;

    protected AbstractDirectory(int n, boolean bl, boolean bl2) {
        this.capacity = n;
        this.readOnly = bl;
        this.isRoot = bl2;
    }

    protected abstract void read(ByteBuffer var1) throws IOException;

    protected abstract void write(ByteBuffer var1) throws IOException;

    protected abstract long getStorageCluster();

    protected abstract void changeSize(int var1) throws DirectoryFullException, IOException;

    public void setEntries(List<FatDirectoryEntry> list) {
        if (list.size() > this.capacity) {
            throw new IllegalArgumentException("too many entries");
        }
        this.entries.clear();
        this.entries.addAll(list);
    }

    protected final void sizeChanged(long l) throws IOException {
        long l2 = l / 32L;
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("directory too large");
        }
        this.capacity = (int)l2;
    }

    public final FatDirectoryEntry getEntry(int n) {
        return this.entries.get(n);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getEntryCount() {
        return this.entries.size();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public int getSize() {
        return this.entries.size() + (this.volumeLabel != null ? 1 : 0);
    }

    protected final void setDirty() {
        this.dirty = true;
    }

    private void checkRoot() throws UnsupportedOperationException {
        if (!this.isRoot()) {
            throw new UnsupportedOperationException("only supported on root directories");
        }
    }

    private void resetDirty() {
        this.dirty = false;
    }

    public void flush() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getCapacity() * 32);
        for (int i = 0; i < this.entries.size(); ++i) {
            FatDirectoryEntry fatDirectoryEntry = this.entries.get(i);
            if (fatDirectoryEntry == null) continue;
            fatDirectoryEntry.write(byteBuffer);
        }
        if (this.volumeLabel != null) {
            FatDirectoryEntry fatDirectoryEntry = FatDirectoryEntry.createVolumeLabel(this.volumeLabel);
            fatDirectoryEntry.write(byteBuffer);
        }
        if (byteBuffer.hasRemaining()) {
            FatDirectoryEntry.writeNullEntry(byteBuffer);
        }
        byteBuffer.flip();
        this.write(byteBuffer);
        this.resetDirty();
    }

    protected final void read() throws IOException {
        FatDirectoryEntry fatDirectoryEntry;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getCapacity() * 32);
        this.read(byteBuffer);
        byteBuffer.flip();
        for (int i = 0; i < this.getCapacity() && (fatDirectoryEntry = FatDirectoryEntry.read(byteBuffer, this.isReadOnly())) != null; ++i) {
            if (fatDirectoryEntry.isVolumeLabel()) {
                if (!this.isRoot) {
                    throw new IOException("volume label in non-root directory");
                }
                this.volumeLabel = fatDirectoryEntry.getVolumeLabel();
                continue;
            }
            this.entries.add(fatDirectoryEntry);
        }
    }

    public void addEntry(FatDirectoryEntry fatDirectoryEntry) throws IOException {
        assert (fatDirectoryEntry != null);
        if (this.getSize() == this.getCapacity()) {
            this.changeSize(this.getCapacity() + 1);
        }
        this.entries.add(fatDirectoryEntry);
    }

    public void addEntries(FatDirectoryEntry[] fatDirectoryEntryArray) throws IOException {
        if (this.getSize() + fatDirectoryEntryArray.length > this.getCapacity()) {
            this.changeSize(this.getSize() + fatDirectoryEntryArray.length);
        }
        this.entries.addAll(Arrays.asList(fatDirectoryEntryArray));
    }

    public void removeEntry(FatDirectoryEntry fatDirectoryEntry) throws IOException {
        assert (fatDirectoryEntry != null);
        this.entries.remove(fatDirectoryEntry);
        this.changeSize(this.getSize());
    }

    public String getLabel() throws UnsupportedOperationException {
        this.checkRoot();
        return this.volumeLabel;
    }

    public FatDirectoryEntry createSub(Fat fat) throws IOException {
        ClusterChain clusterChain = new ClusterChain(fat, false);
        clusterChain.setChainLength(1);
        FatDirectoryEntry fatDirectoryEntry = FatDirectoryEntry.create(true);
        fatDirectoryEntry.setStartCluster(clusterChain.getStartCluster());
        ClusterChainDirectory clusterChainDirectory = new ClusterChainDirectory(clusterChain, false);
        FatDirectoryEntry fatDirectoryEntry2 = FatDirectoryEntry.create(true);
        fatDirectoryEntry2.setShortName(ShortName.DOT);
        fatDirectoryEntry2.setStartCluster(clusterChainDirectory.getStorageCluster());
        AbstractDirectory.copyDateTimeFields(fatDirectoryEntry, fatDirectoryEntry2);
        clusterChainDirectory.addEntry(fatDirectoryEntry2);
        FatDirectoryEntry fatDirectoryEntry3 = FatDirectoryEntry.create(true);
        fatDirectoryEntry3.setShortName(ShortName.DOT_DOT);
        fatDirectoryEntry3.setStartCluster(this.getStorageCluster());
        AbstractDirectory.copyDateTimeFields(fatDirectoryEntry, fatDirectoryEntry3);
        clusterChainDirectory.addEntry(fatDirectoryEntry3);
        clusterChainDirectory.flush();
        return fatDirectoryEntry;
    }

    private static void copyDateTimeFields(FatDirectoryEntry fatDirectoryEntry, FatDirectoryEntry fatDirectoryEntry2) {
        fatDirectoryEntry2.setCreated(fatDirectoryEntry.getCreated());
        fatDirectoryEntry2.setLastAccessed(fatDirectoryEntry.getLastAccessed());
        fatDirectoryEntry2.setLastModified(fatDirectoryEntry.getLastModified());
    }

    public void setLabel(String string) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        this.checkRoot();
        if (string.length() > 11) {
            throw new IllegalArgumentException("label too long");
        }
        if (this.volumeLabel != null) {
            if (string == null) {
                this.changeSize(this.getSize() - 1);
                this.volumeLabel = null;
            } else {
                ShortName.checkValidChars(string.toCharArray());
                this.volumeLabel = string;
            }
        } else if (string != null) {
            this.changeSize(this.getSize() + 1);
            ShortName.checkValidChars(string.toCharArray());
            this.volumeLabel = string;
        }
        this.dirty = true;
    }
}

