/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.AbstractDirectory;
import de.waldheinz.fs.fat.DirectoryFullException;
import de.waldheinz.fs.fat.Fat16BootSector;
import de.waldheinz.fs.fat.FatUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

final class Fat16RootDirectory
extends AbstractDirectory {
    private final BlockDevice device;
    private final long deviceOffset;

    private Fat16RootDirectory(Fat16BootSector fat16BootSector, boolean bl) {
        super(fat16BootSector.getRootDirEntryCount(), bl, true);
        if (fat16BootSector.getRootDirEntryCount() <= 0) {
            throw new IllegalArgumentException("root directory size is " + fat16BootSector.getRootDirEntryCount());
        }
        this.deviceOffset = FatUtils.getRootDirOffset(fat16BootSector);
        this.device = fat16BootSector.getDevice();
    }

    public static Fat16RootDirectory read(Fat16BootSector fat16BootSector, boolean bl) throws IOException {
        Fat16RootDirectory fat16RootDirectory = new Fat16RootDirectory(fat16BootSector, bl);
        fat16RootDirectory.read();
        return fat16RootDirectory;
    }

    public static Fat16RootDirectory create(Fat16BootSector fat16BootSector) throws IOException {
        Fat16RootDirectory fat16RootDirectory = new Fat16RootDirectory(fat16BootSector, false);
        fat16RootDirectory.flush();
        return fat16RootDirectory;
    }

    protected void read(ByteBuffer byteBuffer) throws IOException {
        this.device.read(this.deviceOffset, byteBuffer);
    }

    protected void write(ByteBuffer byteBuffer) throws IOException {
        this.device.write(this.deviceOffset, byteBuffer);
    }

    protected long getStorageCluster() {
        return 0L;
    }

    protected void changeSize(int n) throws DirectoryFullException {
        if (this.getCapacity() < n) {
            throw new DirectoryFullException(this.getCapacity(), n);
        }
    }
}

