/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.BootSector;
import de.waldheinz.fs.fat.FatType;
import java.io.IOException;

final class Fat32BootSector
extends BootSector {
    public static final int ROOT_DIR_FIRST_CLUSTER_OFFSET = 44;
    public static final int SECTORS_PER_FAT_OFFSET = 36;
    public static final int FILE_SYSTEM_TYPE_OFFSET = 82;
    public static final int VERSION_OFFSET = 42;
    public static final int VERSION = 0;
    public static final int FS_INFO_SECTOR_OFFSET = 48;
    public static final int BOOT_SECTOR_COPY_OFFSET = 50;
    public static final int EXTENDED_BOOT_SIGNATURE_OFFSET = 66;

    public Fat32BootSector(BlockDevice blockDevice) throws IOException {
        super(blockDevice);
    }

    public void init() throws IOException {
        super.init();
        this.set16(42, 0);
        this.setBootSectorCopySector(6);
    }

    public long getRootDirFirstCluster() {
        return this.get32(44);
    }

    public void setRootDirFirstCluster(long l) {
        if (this.getRootDirFirstCluster() == l) {
            return;
        }
        this.set32(44, l);
    }

    public void setBootSectorCopySector(int n) {
        if (this.getBootSectorCopySector() == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("boot sector copy sector must be >= 0");
        }
        this.set16(50, n);
    }

    public int getBootSectorCopySector() {
        return this.get16(50);
    }

    public void setVolumeLabel(String string) {
        for (int i = 0; i < 11; ++i) {
            int n = string == null ? 0 : (string.length() > i ? (int)string.charAt(i) : 32);
            this.set8(71 + i, n);
        }
    }

    public int getFsInfoSectorNr() {
        return this.get16(48);
    }

    public void setFsInfoSectorNr(int n) {
        if (this.getFsInfoSectorNr() == n) {
            return;
        }
        this.set16(48, n);
    }

    public void setSectorsPerFat(long l) {
        if (this.getSectorsPerFat() == l) {
            return;
        }
        this.set32(36, l);
    }

    public long getSectorsPerFat() {
        return this.get32(36);
    }

    public FatType getFatType() {
        return FatType.FAT32;
    }

    public void setSectorCount(long l) {
        super.setNrTotalSectors(l);
    }

    public long getSectorCount() {
        return super.getNrTotalSectors();
    }

    public int getRootDirEntryCount() {
        return 0;
    }

    public void setFileSystemId(int n) {
        super.set32(67, n);
    }

    public int getFileSystemId() {
        return (int)super.get32(67);
    }

    public void writeCopy(BlockDevice blockDevice) throws IOException {
        if (this.getBootSectorCopySector() > 0) {
            long l = this.getBootSectorCopySector() * 512;
            this.buffer.rewind();
            this.buffer.limit(this.buffer.capacity());
            blockDevice.write(l, this.buffer);
        }
    }

    public int getFileSystemTypeLabelOffset() {
        return 82;
    }

    public int getExtendedBootSignatureOffset() {
        return 66;
    }
}

