/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.AbstractFsObject;
import de.waldheinz.fs.FsFile;
import de.waldheinz.fs.ReadOnlyException;
import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.FatDirectoryEntry;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class FatFile
extends AbstractFsObject
implements FsFile {
    private final FatDirectoryEntry entry;
    private final ClusterChain chain;

    private FatFile(FatDirectoryEntry fatDirectoryEntry, ClusterChain clusterChain) {
        super(fatDirectoryEntry.isReadOnly());
        this.entry = fatDirectoryEntry;
        this.chain = clusterChain;
    }

    static FatFile get(Fat fat, FatDirectoryEntry fatDirectoryEntry) throws IOException {
        if (fatDirectoryEntry.isDirectory()) {
            throw new IllegalArgumentException(fatDirectoryEntry + " is a directory");
        }
        ClusterChain clusterChain = new ClusterChain(fat, fatDirectoryEntry.getStartCluster(), fatDirectoryEntry.isReadonlyFlag());
        if (fatDirectoryEntry.getLength() > clusterChain.getLengthOnDisk()) {
            throw new IOException("entry is larger than associated cluster chain");
        }
        return new FatFile(fatDirectoryEntry, clusterChain);
    }

    public long getLength() {
        this.checkValid();
        return this.entry.getLength();
    }

    public void setLength(long l) throws ReadOnlyException, IOException {
        this.checkWritable();
        if (this.getLength() == l) {
            return;
        }
        this.updateTimeStamps(true);
        this.chain.setSize(l);
        this.entry.setStartCluster(this.chain.getStartCluster());
        this.entry.setLength(l);
    }

    public void read(long l, ByteBuffer byteBuffer) throws IOException {
        this.checkValid();
        int n = byteBuffer.remaining();
        if (n == 0) {
            return;
        }
        if (l + (long)n > this.getLength()) {
            throw new EOFException();
        }
        if (!this.isReadOnly()) {
            this.updateTimeStamps(false);
        }
        this.chain.readData(l, byteBuffer);
    }

    public void write(long l, ByteBuffer byteBuffer) throws ReadOnlyException, IOException {
        this.checkWritable();
        this.updateTimeStamps(true);
        long l2 = l + (long)byteBuffer.remaining();
        if (l2 > this.getLength()) {
            this.setLength(l2);
        }
        this.chain.writeData(l, byteBuffer);
    }

    private void updateTimeStamps(boolean bl) {
        long l = System.currentTimeMillis();
        this.entry.setLastAccessed(l);
        if (bl) {
            this.entry.setLastModified(l);
        }
    }

    public void flush() throws ReadOnlyException {
        this.checkWritable();
    }

    ClusterChain getChain() {
        this.checkValid();
        return this.chain;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [length=" + this.getLength() + ", first cluster=" + this.chain.getStartCluster() + "]";
    }
}

