/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.AbstractFsObject;
import de.waldheinz.fs.FsDirectoryEntry;
import de.waldheinz.fs.ReadOnlyException;
import de.waldheinz.fs.fat.FatDirectoryEntry;
import de.waldheinz.fs.fat.FatFile;
import de.waldheinz.fs.fat.FatLfnDirectory;
import de.waldheinz.fs.fat.LittleEndian;
import de.waldheinz.fs.fat.ShortName;
import java.io.IOException;

public final class FatLfnDirectoryEntry
extends AbstractFsObject
implements FsDirectoryEntry {
    final FatDirectoryEntry realEntry;
    private FatLfnDirectory parent;
    private String fileName;

    FatLfnDirectoryEntry(String string, ShortName shortName, FatLfnDirectory fatLfnDirectory, boolean bl) {
        super(false);
        this.parent = fatLfnDirectory;
        this.fileName = string;
        long l = System.currentTimeMillis();
        this.realEntry = FatDirectoryEntry.create(bl);
        this.realEntry.setShortName(shortName);
        this.realEntry.setCreated(l);
        this.realEntry.setLastAccessed(l);
    }

    FatLfnDirectoryEntry(FatLfnDirectory fatLfnDirectory, FatDirectoryEntry fatDirectoryEntry, String string) {
        super(fatLfnDirectory.isReadOnly());
        this.parent = fatLfnDirectory;
        this.realEntry = fatDirectoryEntry;
        this.fileName = string;
    }

    static FatLfnDirectoryEntry extract(FatLfnDirectory fatLfnDirectory, int n, int n2) {
        String string;
        FatDirectoryEntry fatDirectoryEntry = fatLfnDirectory.dir.getEntry(n + n2 - 1);
        if (n2 == 1) {
            string = fatDirectoryEntry.getShortName().asSimpleString();
        } else {
            StringBuilder stringBuilder = new StringBuilder(13 * (n2 - 1));
            for (int i = n2 - 2; i >= 0; --i) {
                FatDirectoryEntry fatDirectoryEntry2 = fatLfnDirectory.dir.getEntry(i + n);
                stringBuilder.append(fatDirectoryEntry2.getLfnPart());
            }
            string = stringBuilder.toString().trim();
        }
        return new FatLfnDirectoryEntry(fatLfnDirectory, fatDirectoryEntry, string);
    }

    public boolean isHiddenFlag() {
        return this.realEntry.isHiddenFlag();
    }

    public void setHiddenFlag(boolean bl) throws ReadOnlyException {
        this.checkWritable();
        this.realEntry.setHiddenFlag(bl);
    }

    public boolean isSystemFlag() {
        return this.realEntry.isSystemFlag();
    }

    public void setSystemFlag(boolean bl) throws ReadOnlyException {
        this.checkWritable();
        this.realEntry.setSystemFlag(bl);
    }

    public boolean isReadOnlyFlag() {
        return this.realEntry.isReadonlyFlag();
    }

    public void setReadOnlyFlag(boolean bl) throws ReadOnlyException {
        this.checkWritable();
        this.realEntry.setReadonlyFlag(bl);
    }

    public boolean isArchiveFlag() {
        return this.realEntry.isArchiveFlag();
    }

    public void setArchiveFlag(boolean bl) throws ReadOnlyException {
        this.checkWritable();
        this.realEntry.setArchiveFlag(bl);
    }

    private int totalEntrySize() {
        int n = this.fileName.length() / 13 + 1;
        if (this.fileName.length() % 13 != 0) {
            ++n;
        }
        return n;
    }

    FatDirectoryEntry[] compactForm() {
        if (this.realEntry.getShortName().equals(ShortName.DOT) || this.realEntry.getShortName().equals(ShortName.DOT_DOT) || this.realEntry.hasShortNameOnly) {
            return new FatDirectoryEntry[]{this.realEntry};
        }
        int n = this.totalEntrySize();
        FatDirectoryEntry[] fatDirectoryEntryArray = new FatDirectoryEntry[n];
        byte by = this.realEntry.getShortName().checkSum();
        int n2 = 0;
        for (int i = n - 2; i > 0; --i) {
            fatDirectoryEntryArray[i] = FatLfnDirectoryEntry.createPart(this.fileName.substring(n2 * 13, n2 * 13 + 13), n2 + 1, by, false);
            ++n2;
        }
        fatDirectoryEntryArray[0] = FatLfnDirectoryEntry.createPart(this.fileName.substring(n2 * 13), n2 + 1, by, true);
        fatDirectoryEntryArray[n - 1] = this.realEntry;
        return fatDirectoryEntryArray;
    }

    public String getName() {
        this.checkValid();
        return this.fileName;
    }

    public void setName(String string) throws IOException {
        this.checkWritable();
        if (!this.parent.isFreeName(string)) {
            throw new IOException("the name \"" + string + "\" is already in use");
        }
        this.parent.unlinkEntry(this);
        this.fileName = string;
        this.parent.linkEntry(this);
    }

    public void moveTo(FatLfnDirectory fatLfnDirectory, String string) throws IOException, ReadOnlyException {
        this.checkWritable();
        if (!fatLfnDirectory.isFreeName(string)) {
            throw new IOException("the name \"" + string + "\" is already in use");
        }
        this.parent.unlinkEntry(this);
        this.parent = fatLfnDirectory;
        this.fileName = string;
        this.parent.linkEntry(this);
    }

    public void setLastModified(long l) {
        this.checkWritable();
        this.realEntry.setLastModified(l);
    }

    public FatFile getFile() throws IOException {
        return this.parent.getFile(this.realEntry);
    }

    public FatLfnDirectory getDirectory() throws IOException {
        return this.parent.getDirectory(this.realEntry);
    }

    public String toString() {
        return "LFN = " + this.fileName + " / SFN = " + this.realEntry.getShortName();
    }

    private static FatDirectoryEntry createPart(String string, int n, byte by, boolean bl) {
        char[] cArray = new char[13];
        string.getChars(0, string.length(), cArray, 0);
        for (int i = string.length(); i < 13; ++i) {
            cArray[i] = i == string.length() ? 0 : 65535;
        }
        byte[] byArray = new byte[32];
        if (bl) {
            LittleEndian.setInt8(byArray, 0, n + 64);
        } else {
            LittleEndian.setInt8(byArray, 0, n);
        }
        LittleEndian.setInt16(byArray, 1, cArray[0]);
        LittleEndian.setInt16(byArray, 3, cArray[1]);
        LittleEndian.setInt16(byArray, 5, cArray[2]);
        LittleEndian.setInt16(byArray, 7, cArray[3]);
        LittleEndian.setInt16(byArray, 9, cArray[4]);
        LittleEndian.setInt8(byArray, 11, 15);
        LittleEndian.setInt8(byArray, 12, 0);
        LittleEndian.setInt8(byArray, 13, by);
        LittleEndian.setInt16(byArray, 14, cArray[5]);
        LittleEndian.setInt16(byArray, 16, cArray[6]);
        LittleEndian.setInt16(byArray, 18, cArray[7]);
        LittleEndian.setInt16(byArray, 20, cArray[8]);
        LittleEndian.setInt16(byArray, 22, cArray[9]);
        LittleEndian.setInt16(byArray, 24, cArray[10]);
        LittleEndian.setInt16(byArray, 26, 0);
        LittleEndian.setInt16(byArray, 28, cArray[11]);
        LittleEndian.setInt16(byArray, 30, cArray[12]);
        return new FatDirectoryEntry(byArray, false);
    }

    public long getLastModified() throws IOException {
        return this.realEntry.getLastModified();
    }

    public long getCreated() throws IOException {
        return this.realEntry.getCreated();
    }

    public long getLastAccessed() throws IOException {
        return this.realEntry.getLastAccessed();
    }

    public boolean isFile() {
        return this.realEntry.isFile();
    }

    public boolean isDirectory() {
        return this.realEntry.isDirectory();
    }

    public boolean isDirty() {
        return this.realEntry.isDirty();
    }
}

