/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FatType {
    FAT12(4080, 4095L, 1.5f, "FAT12   "){

        long readEntry(byte[] byArray, int n) {
            int n2 = (int)((double)n * 1.5);
            int n3 = byArray[n2] & 0xFF;
            int n4 = byArray[n2 + 1] & 0xFF;
            int n5 = n4 << 8 | n3;
            if (n % 2 == 0) {
                return n5 & 0xFFF;
            }
            return n5 >> 4;
        }

        void writeEntry(byte[] byArray, int n, long l) {
            int n2 = (int)((double)n * 1.5);
            if (n % 2 == 0) {
                byArray[n2] = (byte)(l & 0xFFL);
                byArray[n2 + 1] = (byte)(l >> 8 & 0xFL);
            } else {
                int n3 = n2;
                byArray[n3] = (byte)(byArray[n3] | (byte)((l & 0xFL) << 4));
                byArray[n2 + 1] = (byte)(l >> 4 & 0xFFL);
            }
        }
    }
    ,
    FAT16(65520, 65535L, 2.0f, "FAT16   "){

        long readEntry(byte[] byArray, int n) {
            int n2 = n << 1;
            int n3 = byArray[n2] & 0xFF;
            int n4 = byArray[n2 + 1] & 0xFF;
            return n4 << 8 | n3;
        }

        void writeEntry(byte[] byArray, int n, long l) {
            int n2 = n << 1;
            byArray[n2] = (byte)(l & 0xFFL);
            byArray[n2 + 1] = (byte)(l >> 8 & 0xFFL);
        }
    }
    ,
    FAT32(0xFFFFFF0, 0xFFFFFFFFL, 4.0f, "FAT32   "){

        long readEntry(byte[] byArray, int n) {
            int n2 = n * 4;
            long l = byArray[n2] & 0xFF;
            long l2 = byArray[n2 + 1] & 0xFF;
            long l3 = byArray[n2 + 2] & 0xFF;
            long l4 = byArray[n2 + 3] & 0xFF;
            return l4 << 24 | l3 << 16 | l2 << 8 | l;
        }

        void writeEntry(byte[] byArray, int n, long l) {
            int n2 = n << 2;
            byArray[n2] = (byte)(l & 0xFFL);
            byArray[n2 + 1] = (byte)(l >> 8 & 0xFFL);
            byArray[n2 + 2] = (byte)(l >> 16 & 0xFFL);
            byArray[n2 + 3] = (byte)(l >> 24 & 0xFFL);
        }
    };

    private final long minReservedEntry;
    private final long maxReservedEntry;
    private final long eofCluster;
    private final long eofMarker;
    private final long bitMask;
    private final int maxClusters;
    private final String label;
    private final float entrySize;

    private FatType(int n2, long l, float f, String string2) {
        this.minReservedEntry = 0xFFFFFF0L & l;
        this.maxReservedEntry = 0xFFFFFF6L & l;
        this.eofCluster = 0xFFFFFF8L & l;
        this.eofMarker = 0xFFFFFFFL & l;
        this.entrySize = f;
        this.label = string2;
        this.maxClusters = n2;
        this.bitMask = l;
    }

    abstract long readEntry(byte[] var1, int var2);

    abstract void writeEntry(byte[] var1, int var2, long var3);

    long maxClusters() {
        return this.maxClusters;
    }

    String getLabel() {
        return this.label;
    }

    boolean isReservedCluster(long l) {
        return l >= this.minReservedEntry && l <= this.maxReservedEntry;
    }

    boolean isEofCluster(long l) {
        return l >= this.eofCluster;
    }

    long getEofMarker() {
        return this.eofMarker;
    }

    float getEntrySize() {
        return this.entrySize;
    }

    long getBitMask() {
        return this.bitMask;
    }
}

