/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.BootSector;

public class FatUtils {
    public static long getFatOffset(BootSector bootSector, int n) {
        long l = bootSector.getBytesPerSector();
        long l2 = bootSector.getSectorsPerFat();
        long l3 = bootSector.getNrReservedSectors();
        long l4 = l3 * l;
        long l5 = l2 * l;
        return l4 += (long)n * l5;
    }

    public static long getRootDirOffset(BootSector bootSector) {
        long l = bootSector.getBytesPerSector();
        long l2 = bootSector.getSectorsPerFat();
        int n = bootSector.getNrFats();
        long l3 = FatUtils.getFatOffset(bootSector, 0);
        return l3 += (long)n * l2 * l;
    }

    public static long getFilesOffset(BootSector bootSector) {
        long l = FatUtils.getRootDirOffset(bootSector);
        return l += (long)(bootSector.getRootDirEntryCount() * 32);
    }

    private FatUtils() {
    }
}

