/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class Sector {
    private final BlockDevice device;
    private final long offset;
    protected final ByteBuffer buffer;
    private boolean dirty;

    protected Sector(BlockDevice blockDevice, long l, int n) {
        this.offset = l;
        this.device = blockDevice;
        this.buffer = ByteBuffer.allocate(n);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.dirty = true;
    }

    protected void read() throws IOException {
        this.buffer.rewind();
        this.buffer.limit(this.buffer.capacity());
        this.device.read(this.offset, this.buffer);
        this.dirty = false;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    protected final void markDirty() {
        this.dirty = true;
    }

    public BlockDevice getDevice() {
        return this.device;
    }

    public final void write() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
        this.device.write(this.offset, this.buffer);
        this.dirty = false;
    }

    protected int get16(int n) {
        return this.buffer.getShort(n) & 0xFFFF;
    }

    protected long get32(int n) {
        return this.buffer.getInt(n) & 0xFFFFFFFF;
    }

    protected int get8(int n) {
        return this.buffer.get(n) & 0xFF;
    }

    protected void set16(int n, int n2) {
        this.buffer.putShort(n, (short)(n2 & 0xFFFF));
        this.dirty = true;
    }

    protected void set32(int n, long l) {
        this.buffer.putInt(n, (int)(l & 0xFFFFFFFFFFFFFFFFL));
        this.dirty = true;
    }

    protected void set8(int n, int n2) {
        if ((n2 & 0xFF) != n2) {
            throw new IllegalArgumentException(n2 + " too big to be stored in a single octet");
        }
        this.buffer.put(n, (byte)(n2 & 0xFF));
        this.dirty = true;
    }

    protected long getOffset() {
        return this.offset;
    }
}

