/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.LittleEndian;
import java.util.Arrays;

final class ShortName {
    private static final byte[] ILLEGAL_CHARS = new byte[]{34, 42, 43, 44, 46, 47, 58, 59, 60, 61, 62, 63, 91, 92, 93, 124};
    public static final ShortName DOT = new ShortName(".", "");
    public static final ShortName DOT_DOT = new ShortName("..", "");
    private final char[] name;
    private boolean mShortNameOnly;

    private ShortName(String string) {
        String string2;
        String string3;
        if (string.length() > 12) {
            throw new IllegalArgumentException("name too long");
        }
        int n = string.indexOf(46);
        if (n < 0) {
            string3 = string.toUpperCase();
            string2 = "";
        } else {
            string3 = string.substring(0, n).toUpperCase();
            string2 = string.substring(n + 1).toUpperCase();
        }
        this.name = ShortName.toCharArray(string3, string2);
        ShortName.checkValidChars(this.name);
    }

    ShortName(String string, String string2) {
        this.name = ShortName.toCharArray(string, string2);
    }

    ShortName(char[] cArray) {
        this.name = cArray;
    }

    public ShortName(char[] cArray, char[] cArray2) {
        char[] cArray3 = new char[11];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, 8, cArray2.length);
        this.name = cArray3;
    }

    private static char[] toCharArray(String string, String string2) {
        ShortName.checkValidName(string);
        ShortName.checkValidExt(string2);
        char[] cArray = new char[11];
        Arrays.fill(cArray, ' ');
        System.arraycopy(string.toCharArray(), 0, cArray, 0, string.length());
        System.arraycopy(string2.toCharArray(), 0, cArray, 8, string2.length());
        return cArray;
    }

    public byte checkSum() {
        int n;
        byte[] byArray = new byte[11];
        for (n = 0; n < 11; ++n) {
            byArray[n] = (byte)this.name[n];
        }
        n = byArray[0];
        for (int i = 1; i < 11; ++i) {
            n = byArray[i] + (((n & 1) << 7) + ((n & 0xFE) >> 1));
        }
        return (byte)(n & 0xFF);
    }

    public static ShortName get(String string) throws IllegalArgumentException {
        if (string.equals(".")) {
            return DOT;
        }
        if (string.equals("..")) {
            return DOT_DOT;
        }
        return new ShortName(string);
    }

    public static boolean canConvert(String string) {
        try {
            ShortName.get(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static ShortName parse(byte[] byArray) {
        char[] cArray = new char[8];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)LittleEndian.getUInt8(byArray, i);
        }
        char[] cArray2 = new char[3];
        for (int i = 0; i < cArray2.length; ++i) {
            cArray2[i] = (char)LittleEndian.getUInt8(byArray, 8 + i);
        }
        return new ShortName(cArray, cArray2);
    }

    public void write(byte[] byArray) {
        for (int i = 0; i < 11; ++i) {
            byArray[i] = (byte)this.name[i];
        }
    }

    public String asSimpleString() {
        return new String(this.name).trim();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.name.length; ++i) {
            stringBuilder.append(Integer.toHexString(this.name[i]));
            stringBuilder.append(' ');
        }
        return this.getClass().getSimpleName() + " [" + this.asSimpleString() + " -- " + stringBuilder.toString() + "]";
    }

    private static void checkValidName(String string) {
        ShortName.checkString(string, "name", 1, 8);
    }

    private static void checkValidExt(String string) {
        ShortName.checkString(string, "extension", 0, 3);
    }

    private static void checkString(String string, String string2, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException(string2 + " is null");
        }
        if (string.length() < n) {
            throw new IllegalArgumentException(string2 + " must have at least " + n + " characters: " + string);
        }
        if (string.length() > n2) {
            throw new IllegalArgumentException(string2 + " has more than " + n2 + " characters: " + string);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortName)) {
            return false;
        }
        ShortName shortName = (ShortName)object;
        return Arrays.equals(this.name, shortName.name);
    }

    public int hashCode() {
        return Arrays.hashCode(this.name);
    }

    public void setHasShortNameOnly(boolean bl) {
        this.mShortNameOnly = bl;
    }

    public boolean hasShortNameOnly() {
        return this.mShortNameOnly;
    }

    public static void checkValidChars(char[] cArray) throws IllegalArgumentException {
        if (cArray[0] == ' ') {
            throw new IllegalArgumentException("0x20 can not be the first character");
        }
        for (int i = 0; i < cArray.length; ++i) {
            if ((cArray[i] & 0xFF) != cArray[i]) {
                throw new IllegalArgumentException("multi-byte character at " + i);
            }
            byte by = (byte)(cArray[i] & 0xFF);
            if (by < 32 && by != 5) {
                throw new IllegalArgumentException("character < 0x20 at" + i);
            }
            for (int j = 0; j < ILLEGAL_CHARS.length; ++j) {
                if (by != ILLEGAL_CHARS[j]) continue;
                throw new IllegalArgumentException("illegal character " + ILLEGAL_CHARS[j] + " at " + i);
            }
        }
    }
}

