/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.util;

import com.android.hierarchyviewerlib.actions.ImageAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ActionButton
implements IPropertyChangeListener,
SelectionListener {
    private Button mButton;
    private Action mAction;

    public ActionButton(Composite composite, ImageAction imageAction) {
        this.mAction = (Action)imageAction;
        this.mButton = this.mAction.getStyle() == 2 ? new Button(composite, 32) : new Button(composite, 8);
        this.mButton.setText(imageAction.getText());
        this.mButton.setImage(imageAction.getImage());
        this.mAction.addPropertyChangeListener((IPropertyChangeListener)this);
        this.mButton.addSelectionListener((SelectionListener)this);
        this.mButton.setToolTipText(imageAction.getToolTipText());
        this.mButton.setEnabled(this.mAction.isEnabled());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().toUpperCase().equals("ENABLED")) {
            this.mButton.setEnabled(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
        } else if (propertyChangeEvent.getProperty().toUpperCase().equals("CHECKED")) {
            this.mButton.setSelection(this.mAction.isChecked());
        }
    }

    public void setLayoutData(Object object) {
        this.mButton.setLayoutData(object);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.mAction.getStyle() == 2) {
            this.mAction.setChecked(this.mButton.getSelection());
        }
        this.mAction.run();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.mButton.addSelectionListener(selectionListener);
    }

    public void setVisible(boolean bl) {
        this.mButton.setVisible(bl);
    }
}

