/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.device;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewerlib.device.DeviceConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class WindowUpdater {
    private static HashMap<IDevice, ArrayList<IWindowChangeListener>> sWindowChangeListeners = new HashMap();
    private static HashMap<IDevice, Thread> sListeningThreads = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        HashMap<IDevice, Thread> hashMap = sListeningThreads;
        synchronized (hashMap) {
            for (IDevice iDevice : sListeningThreads.keySet()) {
                sListeningThreads.get(iDevice).interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startListenForWindowChanges(IWindowChangeListener iWindowChangeListener, IDevice iDevice) {
        Cloneable cloneable;
        Object object = sWindowChangeListeners;
        synchronized (object) {
            if (sWindowChangeListeners.containsKey(iDevice)) {
                sWindowChangeListeners.get(iDevice).add(iWindowChangeListener);
                return;
            }
            cloneable = new ArrayList<IWindowChangeListener>();
            cloneable.add(iWindowChangeListener);
            sWindowChangeListeners.put(iDevice, (ArrayList<IWindowChangeListener>)cloneable);
        }
        object = new Thread(new WindowChangeMonitor(iDevice));
        cloneable = sListeningThreads;
        synchronized (cloneable) {
            sListeningThreads.put(iDevice, (Thread)object);
        }
        ((Thread)object).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopListenForWindowChanges(IWindowChangeListener iWindowChangeListener, IDevice iDevice) {
        Cloneable cloneable;
        Object object = sWindowChangeListeners;
        synchronized (object) {
            cloneable = sWindowChangeListeners.get(iDevice);
            cloneable.remove(iWindowChangeListener);
            if (cloneable.size() != 0) {
                return;
            }
            sWindowChangeListeners.remove(iDevice);
        }
        cloneable = sListeningThreads;
        synchronized (cloneable) {
            object = sListeningThreads.get(iDevice);
            sListeningThreads.remove(iDevice);
        }
        ((Thread)object).interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IWindowChangeListener[] getWindowChangeListenersAsArray(IDevice iDevice) {
        IWindowChangeListener[] iWindowChangeListenerArray;
        HashMap<IDevice, ArrayList<IWindowChangeListener>> hashMap = sWindowChangeListeners;
        synchronized (hashMap) {
            ArrayList<IWindowChangeListener> arrayList = sWindowChangeListeners.get(iDevice);
            if (arrayList == null) {
                return null;
            }
            iWindowChangeListenerArray = arrayList.toArray(new IWindowChangeListener[arrayList.size()]);
        }
        return iWindowChangeListenerArray;
    }

    public static void notifyWindowsChanged(IDevice iDevice) {
        IWindowChangeListener[] iWindowChangeListenerArray = WindowUpdater.getWindowChangeListenersAsArray(iDevice);
        if (iWindowChangeListenerArray != null) {
            for (int i = 0; i < iWindowChangeListenerArray.length; ++i) {
                iWindowChangeListenerArray[i].windowsChanged(iDevice);
            }
        }
    }

    public static void notifyFocusChanged(IDevice iDevice) {
        IWindowChangeListener[] iWindowChangeListenerArray = WindowUpdater.getWindowChangeListenersAsArray(iDevice);
        if (iWindowChangeListenerArray != null) {
            for (int i = 0; i < iWindowChangeListenerArray.length; ++i) {
                iWindowChangeListenerArray[i].focusChanged(iDevice);
            }
        }
    }

    private static class WindowChangeMonitor
    implements Runnable {
        private IDevice device;

        public WindowChangeMonitor(IDevice iDevice) {
            this.device = iDevice;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                DeviceConnection deviceConnection = null;
                try {
                    String string;
                    deviceConnection = new DeviceConnection(this.device);
                    deviceConnection.sendCommand("AUTOLIST");
                    while (!Thread.currentThread().isInterrupted() && (string = deviceConnection.getInputStream().readLine()) != null) {
                        if (string.equalsIgnoreCase("LIST UPDATE")) {
                            WindowUpdater.notifyWindowsChanged(this.device);
                            continue;
                        }
                        if (!string.equalsIgnoreCase("FOCUS UPDATE")) continue;
                        WindowUpdater.notifyFocusChanged(this.device);
                    }
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    if (deviceConnection == null) continue;
                    deviceConnection.close();
                }
            }
        }
    }

    public static interface IWindowChangeListener {
        public void windowsChanged(IDevice var1);

        public void focusChanged(IDevice var1);
    }
}

