/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.device.ViewNode;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CaptureDisplay {
    private static Shell sShell;
    private static Canvas sCanvas;
    private static Image sImage;
    private static ViewNode sViewNode;
    private static Composite sButtonBar;
    private static Button sOnWhite;
    private static Button sOnBlack;
    private static Button sShowExtras;
    private static PaintListener sPaintListener;
    private static ShellAdapter sShellListener;
    private static SelectionListener sWhiteSelectionListener;
    private static SelectionListener sBlackSelectionListener;
    private static SelectionListener sExtrasSelectionListener;

    public static void show(Shell shell, ViewNode viewNode, Image image) {
        if (sShell == null) {
            CaptureDisplay.createShell();
        }
        if (sShell.isVisible() && sViewNode != null) {
            sViewNode.dereferenceImage();
        }
        sImage = image;
        sViewNode = viewNode;
        viewNode.referenceImage();
        sShell.setText(viewNode.name);
        boolean bl = sShell.isVisible();
        if (!bl) {
            sShell.setSize(0, 0);
        }
        Rectangle rectangle = sShell.computeTrim(0, 0, Math.max(CaptureDisplay.sButtonBar.getBounds().width, image.getBounds().width), CaptureDisplay.sButtonBar.getBounds().height + image.getBounds().height + 5);
        sShell.setSize(rectangle.width, rectangle.height);
        if (!bl) {
            sShell.setLocation(shell.getBounds().x + (shell.getBounds().width - rectangle.width) / 2, shell.getBounds().y + (shell.getBounds().height - rectangle.height) / 2);
        }
        sShell.open();
        if (bl) {
            sCanvas.redraw();
        }
    }

    private static void createShell() {
        sShell = new Shell(Display.getDefault(), 96);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        sShell.setLayout((Layout)gridLayout);
        sButtonBar = new Composite((Composite)sShell, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.pack = true;
        rowLayout.center = true;
        sButtonBar.setLayout((Layout)rowLayout);
        Composite composite = new Composite(sButtonBar, 0);
        composite.setLayout((Layout)new FillLayout());
        sOnWhite = new Button(composite, 2);
        sOnWhite.setText("On White");
        sOnBlack = new Button(composite, 2);
        sOnBlack.setText("On Black");
        sOnBlack.setSelection(true);
        sOnWhite.addSelectionListener(sWhiteSelectionListener);
        sOnBlack.addSelectionListener(sBlackSelectionListener);
        sShowExtras = new Button(sButtonBar, 32);
        sShowExtras.setText("Show Extras");
        sShowExtras.addSelectionListener(sExtrasSelectionListener);
        sCanvas = new Canvas((Composite)sShell, 0);
        sCanvas.setLayoutData((Object)new GridData(1808));
        sCanvas.addPaintListener(sPaintListener);
        sShell.addShellListener((ShellListener)sShellListener);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        Image image = imageLoader.loadImage("display.png", Display.getDefault());
        sShell.setImage(image);
    }

    static {
        sPaintListener = new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (sOnWhite.getSelection()) {
                    paintEvent.gc.setBackground(Display.getDefault().getSystemColor(1));
                } else {
                    paintEvent.gc.setBackground(Display.getDefault().getSystemColor(2));
                }
                paintEvent.gc.fillRectangle(0, 0, sCanvas.getBounds().width, sCanvas.getBounds().height);
                if (sImage != null) {
                    int n = sImage.getBounds().width;
                    int n2 = sImage.getBounds().height;
                    int n3 = (sCanvas.getBounds().width - n) / 2;
                    int n4 = (sCanvas.getBounds().height - n2) / 2;
                    paintEvent.gc.drawImage(sImage, n3, n4);
                    if (sShowExtras.getSelection()) {
                        if ((sViewNode.paddingLeft | sViewNode.paddingRight | sViewNode.paddingTop | sViewNode.paddingBottom) != 0) {
                            paintEvent.gc.setForeground(Display.getDefault().getSystemColor(9));
                            paintEvent.gc.drawRectangle(n3 + sViewNode.paddingLeft, n4 + sViewNode.paddingTop, n - sViewNode.paddingLeft - sViewNode.paddingRight - 1, n2 - sViewNode.paddingTop - sViewNode.paddingBottom - 1);
                        }
                        if (sViewNode.hasMargins) {
                            paintEvent.gc.setForeground(Display.getDefault().getSystemColor(5));
                            paintEvent.gc.drawRectangle(n3 - sViewNode.marginLeft, n4 - sViewNode.marginTop, n + sViewNode.marginLeft + sViewNode.marginRight - 1, n2 + sViewNode.marginTop + sViewNode.marginBottom - 1);
                        }
                        if (sViewNode.baseline != -1) {
                            paintEvent.gc.setForeground(Display.getDefault().getSystemColor(3));
                            paintEvent.gc.drawLine(n3, n4 + sViewNode.baseline, n3 + n - 1, sViewNode.baseline);
                        }
                    }
                }
            }
        };
        sShellListener = new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                shellEvent.doit = false;
                sShell.setVisible(false);
                if (sViewNode != null) {
                    sViewNode.dereferenceImage();
                }
            }
        };
        sWhiteSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                sOnWhite.setSelection(true);
                sOnBlack.setSelection(false);
                sCanvas.redraw();
            }
        };
        sBlackSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                sOnBlack.setSelection(true);
                sOnWhite.setSelection(false);
                sCanvas.redraw();
            }
        };
        sExtrasSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                sCanvas.redraw();
            }
        };
    }
}

