/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.device.ViewNode;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PixelPerfect
extends ScrolledComposite
implements PixelPerfectModel.IImageChangeListener {
    private Canvas mCanvas;
    private PixelPerfectModel mModel;
    private Image mImage;
    private Color mCrosshairColor;
    private Color mMarginColor;
    private Color mBorderColor;
    private Color mPaddingColor;
    private int mWidth;
    private int mHeight;
    private Point mCrosshairLocation;
    private ViewNode mSelectedNode;
    private Image mOverlayImage;
    private double mOverlayTransparency;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            PixelPerfect.this.mModel.removeImageChangeListener(PixelPerfect.this);
            PixelPerfect.this.mCrosshairColor.dispose();
            PixelPerfect.this.mBorderColor.dispose();
            PixelPerfect.this.mPaddingColor.dispose();
        }
    };
    private MouseListener mMouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            PixelPerfect.this.handleMouseEvent(mouseEvent);
        }

        public void mouseUp(MouseEvent mouseEvent) {
            PixelPerfect.this.handleMouseEvent(mouseEvent);
        }
    };
    private MouseMoveListener mMouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent mouseEvent) {
            if (mouseEvent.stateMask != 0) {
                PixelPerfect.this.handleMouseEvent(mouseEvent);
            }
        }
    };
    private KeyListener mKeyListener = new KeyListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl = false;
            PixelPerfect pixelPerfect = PixelPerfect.this;
            synchronized (pixelPerfect) {
                if (PixelPerfect.this.mImage != null) {
                    switch (keyEvent.keyCode) {
                        case 0x1000001: {
                            if (((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y == 0) break;
                            --((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y;
                            bl = true;
                            break;
                        }
                        case 0x1000002: {
                            if (((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y == PixelPerfect.this.mHeight - 1) break;
                            ++((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y;
                            bl = true;
                            break;
                        }
                        case 0x1000003: {
                            if (((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x == 0) break;
                            --((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x;
                            bl = true;
                            break;
                        }
                        case 0x1000004: {
                            if (((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x == PixelPerfect.this.mWidth - 1) break;
                            ++((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x;
                            bl = true;
                        }
                    }
                }
            }
            if (bl) {
                PixelPerfect.this.mModel.setCrosshairLocation(((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x, ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    };
    private PaintListener mPaintListener = new PaintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintControl(PaintEvent paintEvent) {
            PixelPerfect pixelPerfect = PixelPerfect.this;
            synchronized (pixelPerfect) {
                paintEvent.gc.setBackground(Display.getDefault().getSystemColor(2));
                paintEvent.gc.fillRectangle(0, 0, ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().x, ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().y);
                if (PixelPerfect.this.mImage != null) {
                    int n;
                    int n2 = ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().x / 2 - PixelPerfect.this.mWidth / 2;
                    int n3 = ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().y / 2 - PixelPerfect.this.mHeight / 2;
                    paintEvent.gc.drawImage(PixelPerfect.this.mImage, n2, n3);
                    if (PixelPerfect.this.mOverlayImage != null) {
                        paintEvent.gc.setAlpha((int)(PixelPerfect.this.mOverlayTransparency * 255.0));
                        n = ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().y / 2 + PixelPerfect.this.mHeight / 2 - ((PixelPerfect)PixelPerfect.this).mOverlayImage.getBounds().height;
                        paintEvent.gc.drawImage(PixelPerfect.this.mOverlayImage, n2, n);
                        paintEvent.gc.setAlpha(255);
                    }
                    if (PixelPerfect.this.mSelectedNode != null) {
                        n = 0;
                        int n4 = 0;
                        int n5 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.left;
                        int n6 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.top;
                        int n7 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.width;
                        int n8 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.height;
                        int n9 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.marginLeft;
                        int n10 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.marginTop;
                        int n11 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.marginRight;
                        int n12 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.marginBottom;
                        int n13 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.paddingLeft;
                        int n14 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.paddingTop;
                        int n15 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.paddingRight;
                        int n16 = ((PixelPerfect)PixelPerfect.this).mSelectedNode.paddingBottom;
                        ViewNode viewNode = PixelPerfect.this.mSelectedNode;
                        while (viewNode.parent != null) {
                            n += viewNode.parent.left - viewNode.parent.scrollX;
                            n4 += viewNode.parent.top - viewNode.parent.scrollY;
                            viewNode = viewNode.parent;
                        }
                        if (viewNode.width > viewNode.height) {
                            paintEvent.gc.setForeground(PixelPerfect.this.mPaddingColor);
                            paintEvent.gc.drawRectangle(n2 + PixelPerfect.this.mWidth - n6 - n4 - n8 + n16, n3 + n + n5 + n13, n8 - n16 - n14, n7 - n15 - n13);
                            paintEvent.gc.setForeground(PixelPerfect.this.mMarginColor);
                            paintEvent.gc.drawRectangle(n2 + PixelPerfect.this.mWidth - n6 - n4 - n8 - n12, n3 + n + n5 - n9, n8 + n12 + n10, n7 + n11 + n9);
                            paintEvent.gc.setForeground(PixelPerfect.this.mBorderColor);
                            paintEvent.gc.drawRectangle(n2 + PixelPerfect.this.mWidth - n6 - n4 - n8, n3 + n + n5, n8, n7);
                        } else {
                            paintEvent.gc.setForeground(PixelPerfect.this.mPaddingColor);
                            paintEvent.gc.drawRectangle(n2 + n + n5 + n13, n3 + n4 + n6 + n14, n7 - n15 - n13, n8 - n16 - n14);
                            paintEvent.gc.setForeground(PixelPerfect.this.mMarginColor);
                            paintEvent.gc.drawRectangle(n2 + n + n5 - n9, n3 + n4 + n6 - n10, n7 + n11 + n9, n8 + n12 + n10);
                            paintEvent.gc.setForeground(PixelPerfect.this.mBorderColor);
                            paintEvent.gc.drawRectangle(n2 + n + n5, n3 + n4 + n6, n7, n8);
                        }
                    }
                    if (PixelPerfect.this.mCrosshairLocation != null) {
                        paintEvent.gc.setForeground(PixelPerfect.this.mCrosshairColor);
                        paintEvent.gc.drawLine(n2, n3 + ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y, n2 + PixelPerfect.this.mWidth - 1, n3 + ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y);
                        paintEvent.gc.drawLine(n2 + ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x, n3, n2 + ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x, n3 + PixelPerfect.this.mHeight - 1);
                    }
                }
            }
        }
    };

    public PixelPerfect(Composite composite) {
        super(composite, 768);
        this.mCanvas = new Canvas((Composite)this, 0);
        this.setContent((Control)this.mCanvas);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.mModel = PixelPerfectModel.getModel();
        this.mModel.addImageChangeListener(this);
        this.mCanvas.addPaintListener(this.mPaintListener);
        this.mCanvas.addMouseListener(this.mMouseListener);
        this.mCanvas.addMouseMoveListener(this.mMouseMoveListener);
        this.mCanvas.addKeyListener(this.mKeyListener);
        this.addDisposeListener(this.mDisposeListener);
        this.mCrosshairColor = new Color((Device)Display.getDefault(), new RGB(0, 255, 255));
        this.mBorderColor = new Color((Device)Display.getDefault(), new RGB(255, 0, 0));
        this.mMarginColor = new Color((Device)Display.getDefault(), new RGB(0, 255, 0));
        this.mPaddingColor = new Color((Device)Display.getDefault(), new RGB(0, 0, 255));
        this.imageLoaded();
    }

    public boolean setFocus() {
        return this.mCanvas.setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMouseEvent(MouseEvent mouseEvent) {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            if (this.mImage == null) {
                return;
            }
            int n = this.mCanvas.getSize().x / 2 - this.mWidth / 2;
            int n2 = this.mCanvas.getSize().y / 2 - this.mHeight / 2;
            mouseEvent.x -= n;
            mouseEvent.y -= n2;
            mouseEvent.x = Math.max(mouseEvent.x, 0);
            mouseEvent.x = Math.min(mouseEvent.x, this.mWidth - 1);
            mouseEvent.y = Math.max(mouseEvent.y, 0);
            mouseEvent.y = Math.min(mouseEvent.y, this.mHeight - 1);
        }
        this.mModel.setCrosshairLocation(mouseEvent.x, mouseEvent.y);
    }

    private void doRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PixelPerfect.this.mCanvas.redraw();
            }
        });
    }

    private void loadImage() {
        this.mImage = this.mModel.getImage();
        if (this.mImage != null) {
            this.mWidth = this.mImage.getBounds().width;
            this.mHeight = this.mImage.getBounds().height;
        } else {
            this.mWidth = 0;
            this.mHeight = 0;
        }
        this.setMinSize(this.mWidth, this.mHeight);
    }

    public void imageLoaded() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                7 var1_1 = this;
                synchronized (var1_1) {
                    PixelPerfect.this.loadImage();
                    PixelPerfect.this.mCrosshairLocation = PixelPerfect.this.mModel.getCrosshairLocation();
                    PixelPerfect.this.mSelectedNode = PixelPerfect.this.mModel.getSelected();
                    PixelPerfect.this.mOverlayImage = PixelPerfect.this.mModel.getOverlayImage();
                    PixelPerfect.this.mOverlayTransparency = PixelPerfect.this.mModel.getOverlayTransparency();
                }
            }
        });
        this.doRedraw();
    }

    public void imageChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    PixelPerfect.this.loadImage();
                }
            }
        });
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crosshairMoved() {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            this.mCrosshairLocation = this.mModel.getCrosshairLocation();
        }
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged() {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            this.mSelectedNode = this.mModel.getSelected();
        }
        this.doRedraw();
    }

    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                9 var1_1 = this;
                synchronized (var1_1) {
                    PixelPerfect.this.mSelectedNode = PixelPerfect.this.mModel.getSelected();
                }
            }
        });
        this.doRedraw();
    }

    public void zoomChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overlayChanged() {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            this.mOverlayImage = this.mModel.getOverlayImage();
            this.mOverlayTransparency = this.mModel.getOverlayTransparency();
        }
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overlayTransparencyChanged() {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            this.mOverlayTransparency = this.mModel.getOverlayTransparency();
        }
        this.doRedraw();
    }
}

