/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TreeViewOverview
extends Canvas
implements TreeViewModel.ITreeChangeListener {
    private TreeViewModel mModel;
    private DrawableViewNode mTree;
    private DrawableViewNode.Rectangle mViewport;
    private Transform mTransform;
    private Transform mInverse;
    private DrawableViewNode.Rectangle mBounds = new DrawableViewNode.Rectangle();
    private double mScale;
    private boolean mDragging = false;
    private DrawableViewNode mSelectedNode;
    private static Image sNotSelectedImage;
    private static Image sSelectedImage;
    private static Image sFilteredImage;
    private static Image sFilteredSelectedImage;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            TreeViewOverview.this.mModel.removeTreeChangeListener(TreeViewOverview.this);
            TreeViewOverview.this.mTransform.dispose();
            TreeViewOverview.this.mInverse.dispose();
        }
    };
    private MouseListener mMouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDown(MouseEvent mouseEvent) {
            boolean bl = false;
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                if (TreeViewOverview.this.mTree != null && TreeViewOverview.this.mViewport != null) {
                    TreeViewOverview.this.mDragging = true;
                    bl = true;
                    TreeViewOverview.this.handleMouseEvent(TreeViewOverview.this.transformPoint(mouseEvent.x, mouseEvent.y));
                }
            }
            if (bl) {
                TreeViewOverview.this.mModel.removeTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.mModel.setViewport(TreeViewOverview.this.mViewport);
                TreeViewOverview.this.mModel.addTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.doRedraw();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseUp(MouseEvent mouseEvent) {
            boolean bl = false;
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                if (TreeViewOverview.this.mTree != null && TreeViewOverview.this.mViewport != null) {
                    TreeViewOverview.this.mDragging = false;
                    bl = true;
                    TreeViewOverview.this.handleMouseEvent(TreeViewOverview.this.transformPoint(mouseEvent.x, mouseEvent.y));
                    TreeViewOverview.this.setBounds();
                    TreeViewOverview.this.setTransform();
                }
            }
            if (bl) {
                TreeViewOverview.this.mModel.removeTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.mModel.setViewport(TreeViewOverview.this.mViewport);
                TreeViewOverview.this.mModel.addTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.doRedraw();
            }
        }
    };
    private MouseMoveListener mMouseMoveListener = new MouseMoveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMove(MouseEvent mouseEvent) {
            boolean bl = false;
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                if (TreeViewOverview.this.mDragging) {
                    bl = true;
                    TreeViewOverview.this.handleMouseEvent(TreeViewOverview.this.transformPoint(mouseEvent.x, mouseEvent.y));
                }
            }
            if (bl) {
                TreeViewOverview.this.mModel.removeTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.mModel.setViewport(TreeViewOverview.this.mViewport);
                TreeViewOverview.this.mModel.addTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.doRedraw();
            }
        }
    };
    private Listener mResizeListener = new Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event event) {
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                TreeViewOverview.this.setTransform();
            }
            TreeViewOverview.this.doRedraw();
        }
    };
    private PaintListener mPaintListener = new PaintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintControl(PaintEvent paintEvent) {
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                if (TreeViewOverview.this.mTree != null) {
                    paintEvent.gc.setBackground(Display.getDefault().getSystemColor(2));
                    paintEvent.gc.setForeground(Display.getDefault().getSystemColor(1));
                    paintEvent.gc.fillRectangle(0, 0, TreeViewOverview.this.getBounds().width, TreeViewOverview.this.getBounds().height);
                    paintEvent.gc.setTransform(TreeViewOverview.this.mTransform);
                    paintEvent.gc.setLineWidth((int)Math.ceil(0.7 / TreeViewOverview.this.mScale));
                    Path path = new Path((Device)Display.getDefault());
                    TreeViewOverview.this.paintRecursive(paintEvent.gc, TreeViewOverview.this.mTree, path);
                    paintEvent.gc.drawPath(path);
                    path.dispose();
                    if (TreeViewOverview.this.mViewport != null) {
                        paintEvent.gc.setAlpha(50);
                        paintEvent.gc.setBackground(Display.getDefault().getSystemColor(1));
                        paintEvent.gc.fillRectangle((int)((TreeViewOverview)TreeViewOverview.this).mViewport.x, (int)((TreeViewOverview)TreeViewOverview.this).mViewport.y, (int)Math.ceil(((TreeViewOverview)TreeViewOverview.this).mViewport.width), (int)Math.ceil(((TreeViewOverview)TreeViewOverview.this).mViewport.height));
                        paintEvent.gc.setAlpha(255);
                        paintEvent.gc.setForeground(Display.getDefault().getSystemColor(16));
                        paintEvent.gc.setLineWidth((int)Math.ceil(2.0 / TreeViewOverview.this.mScale));
                        paintEvent.gc.drawRectangle((int)((TreeViewOverview)TreeViewOverview.this).mViewport.x, (int)((TreeViewOverview)TreeViewOverview.this).mViewport.y, (int)Math.ceil(((TreeViewOverview)TreeViewOverview.this).mViewport.width), (int)Math.ceil(((TreeViewOverview)TreeViewOverview.this).mViewport.height));
                    }
                }
            }
        }
    };

    public TreeViewOverview(Composite composite) {
        super(composite, 0);
        this.mModel = TreeViewModel.getModel();
        this.mModel.addTreeChangeListener(this);
        this.loadResources();
        this.addPaintListener(this.mPaintListener);
        this.addMouseListener(this.mMouseListener);
        this.addMouseMoveListener(this.mMouseMoveListener);
        this.addListener(11, this.mResizeListener);
        this.addDisposeListener(this.mDisposeListener);
        this.mTransform = new Transform((Device)Display.getDefault());
        this.mInverse = new Transform((Device)Display.getDefault());
        this.loadAllData();
    }

    private void loadResources() {
        ImageLoader imageLoader = ImageLoader.getLoader(this.getClass());
        sNotSelectedImage = imageLoader.loadImage("not-selected.png", Display.getDefault());
        sSelectedImage = imageLoader.loadImage("selected-small.png", Display.getDefault());
        sFilteredImage = imageLoader.loadImage("filtered.png", Display.getDefault());
        sFilteredSelectedImage = imageLoader.loadImage("selected-filtered-small.png", Display.getDefault());
    }

    private void handleMouseEvent(DrawableViewNode.Point point) {
        this.mViewport.x = point.x - this.mViewport.width / 2.0;
        this.mViewport.y = point.y - this.mViewport.height / 2.0;
        if (this.mViewport.x < this.mBounds.x) {
            this.mViewport.x = this.mBounds.x;
        }
        if (this.mViewport.y < this.mBounds.y) {
            this.mViewport.y = this.mBounds.y;
        }
        if (this.mViewport.x + this.mViewport.width > this.mBounds.x + this.mBounds.width) {
            this.mViewport.x = this.mBounds.x + this.mBounds.width - this.mViewport.width;
        }
        if (this.mViewport.y + this.mViewport.height > this.mBounds.y + this.mBounds.height) {
            this.mViewport.y = this.mBounds.y + this.mBounds.height - this.mViewport.height;
        }
    }

    private DrawableViewNode.Point transformPoint(double d, double d2) {
        float[] fArray = new float[]{(float)d, (float)d2};
        this.mInverse.transform(fArray);
        return new DrawableViewNode.Point(fArray[0], fArray[1]);
    }

    private void paintRecursive(GC gC, DrawableViewNode drawableViewNode, Path path) {
        if (this.mSelectedNode == drawableViewNode && drawableViewNode.viewNode.filtered) {
            gC.drawImage(sFilteredSelectedImage, drawableViewNode.left, (int)Math.round(drawableViewNode.top));
        } else if (this.mSelectedNode == drawableViewNode) {
            gC.drawImage(sSelectedImage, drawableViewNode.left, (int)Math.round(drawableViewNode.top));
        } else if (drawableViewNode.viewNode.filtered) {
            gC.drawImage(sFilteredImage, drawableViewNode.left, (int)Math.round(drawableViewNode.top));
        } else {
            gC.drawImage(sNotSelectedImage, drawableViewNode.left, (int)Math.round(drawableViewNode.top));
        }
        int n = drawableViewNode.children.size();
        if (n == 0) {
            return;
        }
        float f = 80.0f / (float)n;
        for (int i = 0; i < n; ++i) {
            DrawableViewNode drawableViewNode2 = drawableViewNode.children.get(i);
            this.paintRecursive(gC, drawableViewNode2, path);
            float f2 = drawableViewNode.left + 180;
            float f3 = (float)drawableViewNode.top + 10.0f + f * (float)i + f / 2.0f;
            float f4 = drawableViewNode2.left;
            float f5 = (float)drawableViewNode2.top + 50.0f;
            float f6 = f2 + 17.5f;
            float f7 = f3;
            float f8 = f4 - 17.5f;
            float f9 = f5;
            path.moveTo(f2, f3);
            path.cubicTo(f6, f7, f8, f9, f4, f5);
        }
    }

    private void doRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TreeViewOverview.this.redraw();
            }
        });
    }

    public void loadAllData() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                7 var1_1 = this;
                synchronized (var1_1) {
                    TreeViewOverview.this.mTree = TreeViewOverview.this.mModel.getTree();
                    TreeViewOverview.this.mSelectedNode = TreeViewOverview.this.mModel.getSelection();
                    TreeViewOverview.this.mViewport = TreeViewOverview.this.mModel.getViewport();
                    TreeViewOverview.this.setBounds();
                    TreeViewOverview.this.setTransform();
                }
            }
        });
    }

    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    TreeViewOverview.this.mTree = TreeViewOverview.this.mModel.getTree();
                    TreeViewOverview.this.mSelectedNode = TreeViewOverview.this.mModel.getSelection();
                    TreeViewOverview.this.mViewport = TreeViewOverview.this.mModel.getViewport();
                    TreeViewOverview.this.setBounds();
                    TreeViewOverview.this.setTransform();
                }
            }
        });
        this.doRedraw();
    }

    private void setBounds() {
        if (this.mViewport != null && this.mTree != null) {
            this.mBounds.x = Math.min(this.mViewport.x, this.mTree.bounds.x);
            this.mBounds.y = Math.min(this.mViewport.y, this.mTree.bounds.y);
            this.mBounds.width = Math.max(this.mViewport.x + this.mViewport.width, this.mTree.bounds.x + this.mTree.bounds.width) - this.mBounds.x;
            this.mBounds.height = Math.max(this.mViewport.y + this.mViewport.height, this.mTree.bounds.y + this.mTree.bounds.height) - this.mBounds.y;
        } else if (this.mTree != null) {
            this.mBounds.x = this.mTree.bounds.x;
            this.mBounds.y = this.mTree.bounds.y;
            this.mBounds.width = this.mTree.bounds.x + this.mTree.bounds.width - this.mBounds.x;
            this.mBounds.height = this.mTree.bounds.y + this.mTree.bounds.height - this.mBounds.y;
        }
    }

    private void setTransform() {
        if (this.mTree != null) {
            this.mTransform.identity();
            this.mInverse.identity();
            DrawableViewNode.Point point = new DrawableViewNode.Point();
            point.x = this.getBounds().width;
            point.y = this.getBounds().height;
            this.mScale = this.mBounds.width == 0.0 || this.mBounds.height == 0.0 || point.x == 0.0 || point.y == 0.0 ? 1.0 : Math.min(point.x / this.mBounds.width, point.y / this.mBounds.height);
            this.mTransform.scale((float)this.mScale, (float)this.mScale);
            this.mInverse.scale((float)this.mScale, (float)this.mScale);
            this.mTransform.translate((float)(-this.mBounds.x), (float)(-this.mBounds.y));
            this.mInverse.translate((float)(-this.mBounds.x), (float)(-this.mBounds.y));
            if (point.x / this.mBounds.width < point.y / this.mBounds.height) {
                this.mTransform.translate(0.0f, (float)(point.y / this.mScale - this.mBounds.height) / 2.0f);
                this.mInverse.translate(0.0f, (float)(point.y / this.mScale - this.mBounds.height) / 2.0f);
            } else {
                this.mTransform.translate((float)(point.x / this.mScale - this.mBounds.width) / 2.0f, 0.0f);
                this.mInverse.translate((float)(point.x / this.mScale - this.mBounds.width) / 2.0f, 0.0f);
            }
            this.mInverse.invert();
        }
    }

    public void viewportChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                9 var1_1 = this;
                synchronized (var1_1) {
                    TreeViewOverview.this.mViewport = TreeViewOverview.this.mModel.getViewport();
                    TreeViewOverview.this.setBounds();
                    TreeViewOverview.this.setTransform();
                }
            }
        });
        this.doRedraw();
    }

    public void zoomChanged() {
        this.viewportChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged() {
        TreeViewOverview treeViewOverview = this;
        synchronized (treeViewOverview) {
            this.mSelectedNode = this.mModel.getSelection();
        }
        this.doRedraw();
    }
}

