/*
 * Decompiled with CFR 0.152.
 */
package com.android.jobb;

import Twofish.Twofish_Algorithm;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.InvalidKeyException;
import java.util.Arrays;

public class EncryptedBlockFile
extends RandomAccessFile {
    public static final int BYTES_PER_SECTOR = 512;
    private final Object mKey;
    private final EncryptedBlockFileChannel mEBFC = new EncryptedBlockFileChannel(this.getChannel());

    public EncryptedBlockFileChannel getEncryptedFileChannel() {
        return this.mEBFC;
    }

    public void setLength(long l) throws IOException {
        int n = (int)l / 512;
        if (l % 512L != 0L) {
            throw new IOException("Invalid file size!");
        }
        super.setLength(l);
        byte[] byArray = new byte[512];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        for (int i = 0; i < n; ++i) {
            byteBuffer.rewind();
            this.mEBFC.write(byteBuffer);
        }
    }

    public EncryptedBlockFile(byte[] byArray, File file, String string) throws FileNotFoundException, InvalidKeyException {
        super(file, string);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.mKey = Twofish_Algorithm.makeKey(byArray);
    }

    private final class EncryptedBlockFileChannel
    extends FileChannel {
        final FileChannel mFC;

        protected EncryptedBlockFileChannel(FileChannel fileChannel) {
            this.mFC = fileChannel;
        }

        public void force(boolean bl) throws IOException {
            this.mFC.force(bl);
        }

        public FileLock lock(long l, long l2, boolean bl) throws IOException {
            throw new RuntimeException("Lock not implemented");
        }

        public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
            throw new RuntimeException("MappedByteBuffer not implemented");
        }

        public long position() throws IOException {
            return this.mFC.position();
        }

        public FileChannel position(long l) throws IOException {
            this.mFC.position(l);
            return this;
        }

        public int read(ByteBuffer byteBuffer) throws IOException {
            long l = this.position();
            int n = this.read(byteBuffer, l);
            if (n >= 0) {
                this.position(l += (long)n);
            }
            return n;
        }

        public int read(ByteBuffer byteBuffer, long l) throws IOException {
            boolean bl;
            boolean bl2;
            boolean bl3;
            int n;
            int n2 = n = byteBuffer.remaining();
            int n3 = n / 512;
            if (l + (long)n > EncryptedBlockFile.this.length()) {
                throw new IOException("reading past end of device");
            }
            int n4 = (int)l / 512;
            int n5 = (int)(l % 512L);
            if (0 != n5) {
                n3 = (n += n5) / 512;
                bl3 = true;
                bl2 = true;
                System.out.println("Alignment off reading from sector: " + n4);
            } else {
                bl3 = false;
                bl2 = false;
                n5 = 0;
            }
            int n6 = n % 512;
            if (0 != n6) {
                bl = true;
                bl2 = true;
                n3 = n / 512 + 1;
                System.out.println("Partial read from sector: " + n4);
            } else {
                bl = false;
            }
            ByteBuffer byteBuffer2 = bl2 ? ByteBuffer.allocate(512) : null;
            int n7 = n4 + n3;
            if (bl3) {
                this.readDecryptedSector(n4++, byteBuffer2);
                byteBuffer2.position(n5);
                if (n4 == n7 && bl) {
                    byteBuffer2.limit(n6);
                }
                byteBuffer.put(byteBuffer2);
            }
            for (int i = n4; i < n7; ++i) {
                if (n4 + 1 == n7 && bl) {
                    this.readDecryptedSector(i, byteBuffer2);
                    byteBuffer2.rewind();
                    byteBuffer2.limit(n6);
                    byteBuffer.put(byteBuffer2);
                    continue;
                }
                this.readDecryptedSector(i, byteBuffer);
            }
            return n2;
        }

        public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            throw new RuntimeException("Scattering Channel Read not implemented");
        }

        public long size() throws IOException {
            return this.mFC.size();
        }

        public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
            throw new RuntimeException("File Channel transfer not implemented");
        }

        public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
            throw new RuntimeException("File Channel transfer to not implemented");
        }

        public FileChannel truncate(long l) throws IOException {
            this.mFC.truncate(l);
            return this;
        }

        public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
            return this.mFC.tryLock(l, l2, bl);
        }

        public int write(ByteBuffer byteBuffer) throws IOException {
            long l = this.position();
            int n = this.write(byteBuffer, l);
            if (n >= 0) {
                this.position(l += (long)n);
            }
            return n;
        }

        public int write(ByteBuffer byteBuffer, long l) throws IOException {
            int n;
            long l2;
            int n2;
            int n3 = n2 = byteBuffer.remaining();
            int n4 = (int)l / 512;
            int n5 = n2 / 512;
            boolean bl = false;
            if (0L != l % 512L) {
                long l3 = l % 512L;
                l2 = l - l3;
                n2 = (int)((long)n2 + l3);
                n5 = n2 / 512;
                bl = true;
                System.out.println("Alignment off writing to sector: " + n4);
            } else {
                l2 = l;
            }
            if (0 != n2 % 512) {
                n5 = n2 / 512 + 1;
                bl = true;
                System.out.println("Partial Sector [" + n2 % 512 + "] writing to sector: " + n4);
            }
            if (bl) {
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n5 * 512);
                this.read(byteBuffer2, l2);
                n = (int)(l - l2);
                byteBuffer2.position(n);
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
                byteBuffer.rewind();
            }
            int n6 = n4 + n5;
            for (n = n4; n < n6; ++n) {
                this.writeEncryptedSector(n, byteBuffer);
            }
            return n3;
        }

        public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            throw new RuntimeException("Scattering Channel Write not implemented");
        }

        protected void implCloseChannel() throws IOException {
        }

        private void cryptIVPlainGen(int n, byte[] byArray) {
            Arrays.fill(byArray, (byte)0);
            byArray[0] = (byte)(n & 0xFF);
            byArray[1] = (byte)(n >> 8 & 0xFF);
            byArray[2] = (byte)(n >> 16 & 0xFF);
            byArray[3] = (byte)(n >>> 24);
        }

        private void readDecryptedSector(int n, ByteBuffer byteBuffer) throws IOException {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(512);
            int n2 = 512;
            int n3 = 512 * n;
            int n4 = Twofish_Algorithm.blockSize();
            byte[] byArray = new byte[n4];
            int n5 = n2 / n4;
            while (n2 > 0) {
                int n6 = this.mFC.read(byteBuffer2, n3);
                if (n6 < 0) {
                    throw new IOException();
                }
                n2 -= n6;
                n3 += n6;
            }
            byteBuffer2.rewind();
            this.cryptIVPlainGen(n, byArray);
            byte[] byArray2 = new byte[n4];
            for (int i = 0; i < n5; ++i) {
                byteBuffer2.get(byArray2);
                byte[] byArray3 = Twofish_Algorithm.blockDecrypt(byArray2, 0, EncryptedBlockFile.this.mKey);
                for (int j = 0; j < n4; ++j) {
                    int n7 = j;
                    byArray3[n7] = (byte)(byArray3[n7] ^ byArray[j]);
                }
                System.arraycopy(byArray2, 0, byArray, 0, n4);
                byteBuffer.put(byArray3);
            }
        }

        private void writeEncryptedSector(int n, ByteBuffer byteBuffer) throws IOException {
            byte[] byArray = new byte[512];
            int n2 = 512;
            int n3 = 512 * n;
            int n4 = Twofish_Algorithm.blockSize();
            byte[] byArray2 = new byte[n4];
            int n5 = n2 / n4;
            byteBuffer.get(byArray);
            this.cryptIVPlainGen(n, byArray2);
            int n6 = 0;
            byte[] byArray3 = new byte[n4];
            for (int i = 0; i < n5; ++i) {
                System.arraycopy(byArray, n6, byArray3, 0, n4);
                for (int j = 0; j < n4; ++j) {
                    int n7 = j;
                    byArray3[n7] = (byte)(byArray3[n7] ^ byArray2[j]);
                }
                byte[] byArray4 = Twofish_Algorithm.blockEncrypt(byArray3, 0, EncryptedBlockFile.this.mKey);
                byArray2 = byArray4;
                int n8 = n4;
                ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray4);
                while (n8 > 0) {
                    int n9 = this.mFC.write(byteBuffer2, n3);
                    if (n9 < 0) {
                        throw new IOException();
                    }
                    n8 -= n9;
                    n3 += n9;
                }
                n6 += n4;
            }
        }
    }
}

