/*
 * Decompiled with CFR 0.152.
 */
package com.android.jobb;

import com.android.jobb.EncryptedBlockFile;
import com.android.jobb.ObbFile;
import com.android.jobb.PBKDF;
import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.FsDirectory;
import de.waldheinz.fs.FsDirectoryEntry;
import de.waldheinz.fs.FsFile;
import de.waldheinz.fs.fat.BootSector;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.FatFile;
import de.waldheinz.fs.fat.FatFileSystem;
import de.waldheinz.fs.fat.FatLfnDirectory;
import de.waldheinz.fs.fat.FatLfnDirectoryEntry;
import de.waldheinz.fs.fat.FatType;
import de.waldheinz.fs.fat.FatUtils;
import de.waldheinz.fs.fat.SuperFloppyFormatter;
import de.waldheinz.fs.util.FileDisk;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Stack;

public class Main {
    private static final int BLOCK_SIZE = 512;
    static String sDirectory;
    static File sDirectoryFile;
    static boolean sHasOutputDirectory;
    static String sKey;
    static String sOutputFile;
    static boolean sVerboseMode;
    static String sPackageName;
    static int sPackageVersion;
    static byte[] sSalt;
    static boolean sOverlay;
    static int sFlags;
    static String sInputFile;
    static byte[] sFishKey;
    static ByteBuffer sTempBuf;

    public static void printArgs() {
        System.out.println("Jobb -- Create OBB files for use on Android");
        System.out.println();
        System.out.println(" -d <directory> Use <directory> as input/output for OBB files");
        System.out.println(" -k <key>       Use <key> as password to encrypt/decrypt OBB file");
        System.out.println(" -o <filename>  Write OBB file out to <filename>");
        System.out.println(" -v             Verbose mode");
        System.out.println(" -h             Help; this usage screen");
        System.out.println(" -pn <package>  Package name for OBB file");
        System.out.println(" -pv <version>  Package version for OBB file");
        System.out.println(" -ov            Set overlay flag");
        System.out.println(" -dump <file>   Parse and dump OBB file");
        System.out.println(" -about         Notices about this tool");
        System.out.println();
        System.out.println("Example: Dump the contents of the encrypted OBB file to the directory");
        System.out.println("         jobb -dump myfile.obb -d ./mydirectory -k mypassword");
        System.out.println();
        System.out.println("Example: Create an encrypted OBB file by recursing the directory path");
        System.out.println("         jobb -pn package.name -pv 1 -d ./mydirectory -k mypassword");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpDirectory(FsDirectory fsDirectory, int n, File file) throws IOException {
        for (FsDirectoryEntry fsDirectoryEntry : fsDirectory) {
            int n2;
            if (fsDirectoryEntry.isDirectory()) {
                for (n2 = 0; n2 < n; ++n2) {
                    System.out.print(' ');
                }
                if (fsDirectoryEntry.getName().equals(".") || fsDirectoryEntry.getName().equals("..")) continue;
                for (n2 = 0; n2 < n; ++n2) {
                    System.out.print("  ");
                }
                System.out.println("[" + fsDirectoryEntry + "]");
                Main.dumpDirectory(fsDirectoryEntry.getDirectory(), n + 1, new File(file, fsDirectoryEntry.getName()));
                continue;
            }
            for (n2 = 0; n2 < n; ++n2) {
                System.out.print("  ");
            }
            System.out.println(fsDirectoryEntry);
            if (!sHasOutputDirectory) continue;
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException("Unable to create directory: " + file);
            }
            File file2 = new File(file, fsDirectoryEntry.getName());
            if (file2.exists()) {
                throw new IOException("File exists: " + file2);
            }
            FsFile fsFile = fsDirectoryEntry.getFile();
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                FileChannel fileChannel = fileOutputStream.getChannel();
                int n3 = sTempBuf.capacity();
                long l = fsFile.getLength();
                for (long i = 0L; i < l; ++i) {
                    int n4 = (int)(l - i > (long)n3 ? (long)n3 : l - i);
                    sTempBuf.rewind();
                    sTempBuf.limit(n4);
                    fsFile.read(i, sTempBuf);
                    sTempBuf.rewind();
                    while (sTempBuf.remaining() > 0) {
                        fileChannel.write(sTempBuf);
                    }
                    i += (long)n4;
                }
            }
            finally {
                if (null == fileOutputStream) continue;
                fileOutputStream.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                object3 = stringArray[n];
                if (((String)object3).equals("-d")) {
                    sDirectory = stringArray[++n];
                    sDirectoryFile = new File(sDirectory);
                    sHasOutputDirectory = true;
                    continue;
                }
                if (((String)object3).equals("-k")) {
                    bl2 = true;
                    sKey = stringArray[++n];
                    continue;
                }
                if (((String)object3).equals("-o")) {
                    sOutputFile = stringArray[++n];
                    continue;
                }
                if (((String)object3).equals("-h")) {
                    bl = true;
                    continue;
                }
                if (((String)object3).equals("-v")) {
                    sVerboseMode = true;
                    continue;
                }
                if (((String)object3).equals("-pn")) {
                    sPackageName = stringArray[++n];
                    continue;
                }
                if (((String)object3).equals("-pv")) {
                    sPackageVersion = Integer.parseInt(stringArray[++n]);
                    continue;
                }
                if (((String)object3).equals("-ov")) {
                    sFlags |= 1;
                    continue;
                }
                if (((String)object3).equals("-dump")) {
                    sInputFile = stringArray[++n];
                    continue;
                }
                if (((String)object3).equals("-salt")) {
                    if ((sSalt = ((BigInteger)(object2 = new BigInteger((String)(object = stringArray[++n]), 16))).toByteArray()).length == 8) continue;
                    bl = true;
                    continue;
                }
                if (!((String)object3).equals("-about")) continue;
                System.out.println("-------------------------------------------------------------------------------");
                System.out.println("Portions of this code:");
                System.out.println("-------------------------------------------------------------------------------");
                System.out.println("Copyright (c) 2000 The Legion Of The Bouncy Castle");
                System.out.println("(http://www.bouncycastle.org)");
                System.out.println();
                System.out.println("Permission is hereby granted, free of charge, to any person obtaining");
                System.out.println("a copy of this software and associated documentation files (the \"Software\"");
                System.out.println("to deal in the Software without restriction, including without limitation");
                System.out.println("the rights to use, copy, modify, merge, publish, distribute, sublicense");
                System.out.println("and/or sell copies of the Software, and to permit persons to whom the Software");
                System.out.println("is furnished to do so, subject to the following conditions:");
                System.out.println();
                System.out.println("The above copyright notice and this permission notice shall be included in all");
                System.out.println("copies or substantial portions of the Software.");
                System.out.println("-------------------------------------------------------------------------------");
                System.out.println("Twofish is uncopyrighted and license-free, and was created and analyzed by:");
                System.out.println("Bruce Schneier - John Kelsey - Doug Whiting");
                System.out.println("David Wagner - Chris Hall - Niels Ferguson");
                System.out.println("-------------------------------------------------------------------------------");
                System.out.println("Cryptix General License");
                System.out.println();
                System.out.println("Copyright (c) 1995-2005 The Cryptix Foundation Limited.");
                System.out.println("All rights reserved.");
                System.out.println("");
                System.out.println("Redistribution and use in source and binary forms, with or without");
                System.out.println("modification, are permitted provided that the following conditions are");
                System.out.println("met:");
                System.out.println();
                System.out.println(" 1. Redistributions of source code must retain the copyright notice,");
                System.out.println("    this list of conditions and the following disclaimer.");
                System.out.println(" 2. Redistributions in binary form must reproduce the above copyright");
                System.out.println("    notice, this list of conditions and the following disclaimer in");
                System.out.println("    the documentation and/or other materials provided with the");
                System.out.println("    distribution.");
                System.out.println("-------------------------------------------------------------------------------");
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        if (null != sInputFile) {
            ObbFile obbFile = new ObbFile();
            obbFile.readFrom(sInputFile);
            System.out.print("Package Name: ");
            System.out.println(obbFile.mPackageName);
            System.out.print("Package Version: ");
            System.out.println(obbFile.mPackageVersion);
            if (0L != (obbFile.mFlags & 2L)) {
                System.out.print("SALT: ");
                object3 = new BigInteger(obbFile.mSalt);
                System.out.println(((BigInteger)object3).toString(16));
                System.out.println();
                if (null == sKey) {
                    System.out.println("Encrypted file. Please add password.");
                    return;
                }
                try {
                    sFishKey = PBKDF.getKey(sKey, obbFile.mSalt);
                    object3 = new BigInteger(sFishKey);
                    System.out.println(((BigInteger)object3).toString(16));
                }
                catch (InvalidKeyException invalidKeyException) {
                    invalidKeyException.printStackTrace();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    noSuchAlgorithmException.printStackTrace();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                bl2 = true;
            } else {
                bl2 = false;
            }
            object3 = new File(sInputFile);
            try {
                if (bl2) {
                    object2 = new EncryptedBlockFile(sFishKey, (File)object3, "r");
                    object = new FileDisk((RandomAccessFile)object2, (FileChannel)((EncryptedBlockFile)object2).getEncryptedFileChannel(), true);
                } else {
                    object = new FileDisk((File)object3, true);
                }
                object2 = FatFileSystem.read((BlockDevice)object, (boolean)true);
                BootSector bootSector = object2.getBootSector();
                FatLfnDirectory fatLfnDirectory = object2.getRoot();
                if (sVerboseMode) {
                    System.out.print("Filesystem Type: ");
                    FatType fatType = bootSector.getFatType();
                    if (fatType == FatType.FAT32) {
                        System.out.println("FAT32");
                    } else if (fatType == FatType.FAT16) {
                        System.out.println("FAT16");
                    } else if (fatType == FatType.FAT12) {
                        System.out.println("FAT12");
                    } else {
                        System.out.println("Unknown");
                    }
                    System.out.print("           OEM Name: ");
                    System.out.println(bootSector.getOemName());
                    System.out.print("   Bytes Per Sector: ");
                    System.out.println(bootSector.getBytesPerSector());
                    System.out.print("Sectors per cluster: ");
                    System.out.println(bootSector.getSectorsPerCluster());
                    System.out.print("   Reserved Sectors: ");
                    System.out.println(bootSector.getNrReservedSectors());
                    System.out.print("               Fats: ");
                    System.out.println(bootSector.getNrFats());
                    System.out.print("   Root Dir Entries: ");
                    System.out.println(bootSector.getRootDirEntryCount());
                    System.out.print("  Medium Descriptor: ");
                    System.out.println(bootSector.getMediumDescriptor());
                    System.out.print("            Sectors: ");
                    System.out.println(bootSector.getSectorCount());
                    System.out.print("    Sectors Per Fat: ");
                    System.out.println(bootSector.getSectorsPerFat());
                    System.out.print("              Heads: ");
                    System.out.println(bootSector.getNrHeads());
                    System.out.print("     Hidden Sectors: ");
                    System.out.println(bootSector.getNrHiddenSectors());
                    System.out.print("         Fat Offset: ");
                    System.out.println(FatUtils.getFatOffset((BootSector)bootSector, (int)0));
                    System.out.println("          RootDir: " + fatLfnDirectory);
                }
                Main.dumpDirectory((FsDirectory)fatLfnDirectory, 0, sDirectoryFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InvalidKeyException invalidKeyException) {
                invalidKeyException.printStackTrace();
            }
            return;
        }
        if (bl) {
            n = 1;
        } else if (null == sDirectory) {
            n = 1;
            System.out.println("A directory to be recursed through [-d directory] is required when creating an OBB filesystem.");
        } else if (null == sOutputFile) {
            n = 1;
            System.out.println("An output filename [-o outputfile] is required when creating an OBB filesystem.");
        } else if (null == sPackageName) {
            n = 1;
            System.out.println("A package name [-pn package] is required when creating an OBB filesystem.");
        } else if (-1 == sPackageVersion) {
            n = 1;
            System.out.println("A package version [-pv package] is required when creating an OBB filesystem.");
        } else {
            n = 0;
        }
        if (n != 0) {
            Main.printArgs();
        } else {
            File file;
            if (null != sKey) {
                if (null == sSalt) {
                    sSalt = PBKDF.getRandomSalt();
                }
                try {
                    sFishKey = PBKDF.getKey(sKey, sSalt);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                sFlags |= 2;
                if (sVerboseMode) {
                    int n2;
                    System.out.println("Crypto: ");
                    System.out.print("SALT: ");
                    for (Object object4 : (Object)sSalt) {
                        n2 = object4 & 0xFF;
                        System.out.print(Integer.toHexString(n2));
                        System.out.print(" ");
                    }
                    System.out.print("\t");
                    System.out.print("KEY: ");
                    for (Object object4 : (Object)sFishKey) {
                        n2 = object4 & 0xFF;
                        System.out.print(Integer.toHexString(n2));
                        System.out.print(" ");
                    }
                    System.out.println();
                }
            }
            if (sVerboseMode) {
                System.out.println("Scanning directory: " + sDirectory);
            }
            object3 = new File(sDirectory);
            long l = Main.getTotalFileSize((File)object3, 0);
            l = Main.getTotalFileSize((File)object3, 512 * SuperFloppyFormatter.clusterSizeFromSize((long)l, (int)512));
            if (sVerboseMode) {
                System.out.println("Total Files: " + l);
            }
            long l2 = l / 512L;
            long l3 = SuperFloppyFormatter.clusterSizeFromSize((long)l, (int)512);
            long l4 = 2L * l2 / l3 * 4L;
            l4 += l3 * 512L - l4 % (l3 * 512L);
            l4 += 2L * l3;
            if (sVerboseMode) {
                System.out.println("FAT Overhead: " + l4);
            }
            long l5 = l3 * 512L;
            long l6 = (l2 * 512L + l4 + l5 - 1L) / l5 * l5;
            if (sVerboseMode) {
                System.out.println("Filesystem Size: " + l6);
            }
            if ((file = new File(sOutputFile)).exists()) {
                file.delete();
            }
            try {
                FileDisk fileDisk;
                EncryptedBlockFile encryptedBlockFile;
                if (bl2) {
                    try {
                        encryptedBlockFile = new EncryptedBlockFile(sFishKey, file, "rw");
                        encryptedBlockFile.setLength(l6);
                        fileDisk = new FileDisk((RandomAccessFile)encryptedBlockFile, (FileChannel)encryptedBlockFile.getEncryptedFileChannel(), false);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        invalidKeyException.printStackTrace();
                        return;
                    }
                } else {
                    fileDisk = FileDisk.create((File)file, (long)l6);
                }
                encryptedBlockFile = SuperFloppyFormatter.get((BlockDevice)fileDisk).format();
                final String string = ((File)object3).getAbsolutePath();
                Main.processAllFiles((File)object3, new FileProcessor((FatFileSystem)encryptedBlockFile){
                    Stack<FatLfnDirectory> mCurDir = new Stack();
                    final /* synthetic */ FatFileSystem val$fs;
                    {
                        this.val$fs = fatFileSystem;
                    }

                    public void processDirectory(File file) {
                        String string3 = file.getAbsolutePath().substring(string.length());
                        if (sVerboseMode) {
                            System.out.println("Processing Directory: " + string3 + " at cluster " + this.val$fs.getFat().getLastFreeCluster());
                        }
                        FatLfnDirectory fatLfnDirectory = this.val$fs.getRoot();
                        if (string3.length() > 0) {
                            File file2 = new File(string3);
                            Stack<String> stack = new Stack<String>();
                            do {
                                stack.push(file2.getName());
                            } while (null != (file2 = file2.getParentFile()));
                            while (!stack.empty()) {
                                String string2 = (String)stack.pop();
                                if (0 == string2.length()) continue;
                                FatLfnDirectoryEntry fatLfnDirectoryEntry = fatLfnDirectory.getEntry(string2);
                                if (null != fatLfnDirectoryEntry) {
                                    if (!fatLfnDirectoryEntry.isDirectory()) {
                                        throw new RuntimeException("File path not FAT compatible - naming conflict!");
                                    }
                                } else {
                                    try {
                                        if (sVerboseMode) {
                                            System.out.println("Adding Directory: " + string2);
                                        }
                                        fatLfnDirectoryEntry = fatLfnDirectory.addDirectory(string2);
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                        throw new RuntimeException("Error adding directory!");
                                    }
                                }
                                try {
                                    fatLfnDirectory = fatLfnDirectoryEntry.getDirectory();
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    throw new RuntimeException("Error getting directory");
                                }
                            }
                        }
                        this.mCurDir.push(fatLfnDirectory);
                    }

                    public void processFile(File file) {
                        FatLfnDirectoryEntry fatLfnDirectoryEntry;
                        FatLfnDirectory fatLfnDirectory = this.mCurDir.peek();
                        try {
                            if (sVerboseMode) {
                                System.out.println("Adding file: " + file.getAbsolutePath().substring(string.length()) + " with length " + file.length() + " at cluster " + this.val$fs.getFat().getLastFreeCluster());
                            }
                            fatLfnDirectoryEntry = fatLfnDirectory.addFile(file.getName());
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            throw new RuntimeException("Error adding file with name: " + file.getName());
                        }
                        Channel channel = null;
                        try {
                            FatFile fatFile = fatLfnDirectoryEntry.getFile();
                            channel = new FileInputStream(file).getChannel();
                            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(524288);
                            int n = 0;
                            long l = 0L;
                            while (true) {
                                byteBuffer.clear();
                                n = channel.read(byteBuffer);
                                if (n < 0) break;
                                byteBuffer.rewind();
                                byteBuffer.limit(n);
                                fatFile.write(l, byteBuffer);
                                l += (long)n;
                            }
                            fatFile.flush();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            throw new RuntimeException("Error getting/writing file with name: " + file.getName());
                        }
                        finally {
                            if (null != channel) {
                                try {
                                    channel.close();
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                        }
                    }

                    public void endDirectory(File file) {
                        this.mCurDir.pop();
                    }
                });
                encryptedBlockFile.flush();
                encryptedBlockFile.close();
                Fat fat = encryptedBlockFile.getFat();
                ObbFile obbFile = new ObbFile();
                obbFile.setPackageName(sPackageName);
                obbFile.setPackageVersion(sPackageVersion);
                obbFile.setFlags(sFlags);
                if (null != sSalt) {
                    obbFile.setSalt(sSalt);
                }
                obbFile.writeTo(file);
                if (sVerboseMode) {
                    System.out.println("Success!");
                    System.out.println("" + encryptedBlockFile.getTotalSpace() + " bytes total");
                    System.out.println("" + encryptedBlockFile.getFreeSpace() + " bytes free");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static long getTotalFileSize(File file, final int n) {
        final long[] lArray = new long[3];
        final boolean bl = n > 0;
        Main.processAllFiles(file, new FileProcessor(){
            Stack<int[]> mDirLen = new Stack();

            public void processFile(File file) {
                if (sVerboseMode) {
                    System.out.println("Adding size for file: " + file.getAbsolutePath());
                }
                long l = file.length();
                if (bl && l > 0L) {
                    int[] nArray = this.mDirLen.peek();
                    long l2 = ((long)(n - 1) + l) / (long)n * (long)n;
                    long l3 = l2 - l;
                    lArray[0] = lArray[0] + (l += l3);
                    lArray[1] = lArray[1] + l3;
                    nArray[0] = nArray[0] + (file.getName().length() / 13 + 3);
                } else {
                    lArray[0] = lArray[0] + l;
                }
            }

            public void processDirectory(File file) {
                if (bl) {
                    int[] nArray;
                    nArray = new int[]{nArray[0] + (file.getName().length() / 13 + 4)};
                    this.mDirLen.push(nArray);
                }
            }

            public void endDirectory(File file) {
                int[] nArray;
                long l;
                if (bl && (l = (long)((nArray = this.mDirLen.pop())[0] * 32)) != 0L) {
                    long l2 = ((long)(n - 1) + l) / (long)n * (long)n;
                    long l3 = l2 - l;
                    lArray[0] = lArray[0] + (l + l3);
                    lArray[1] = lArray[1] + l3;
                    lArray[2] = lArray[2] + l;
                }
            }
        });
        System.out.println("Slop: " + lArray[1] + "   Directory Overhead: " + lArray[2]);
        return lArray[0];
    }

    public static void processAllFiles(File file, FileProcessor fileProcessor) {
        if (file.isDirectory()) {
            fileProcessor.processDirectory(file);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                Main.processAllFiles(new File(file, stringArray[i]), fileProcessor);
            }
            fileProcessor.endDirectory(file);
        } else {
            fileProcessor.processFile(file);
        }
    }

    static {
        sPackageVersion = -1;
        sTempBuf = ByteBuffer.allocate(0x100000);
    }

    private static interface FileProcessor {
        public void processFile(File var1);

        public void processDirectory(File var1);

        public void endDirectory(File var1);
    }
}

