/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver;

import com.google.clearsilver.jsilver.DataLoader;
import com.google.clearsilver.jsilver.JSilverOptions;
import com.google.clearsilver.jsilver.TemplateRenderer;
import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.compiler.TemplateCompiler;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataFactory;
import com.google.clearsilver.jsilver.data.HDFDataFactory;
import com.google.clearsilver.jsilver.exceptions.JSilverBadSyntaxException;
import com.google.clearsilver.jsilver.exceptions.JSilverException;
import com.google.clearsilver.jsilver.functions.Function;
import com.google.clearsilver.jsilver.functions.FunctionRegistry;
import com.google.clearsilver.jsilver.functions.TextFilter;
import com.google.clearsilver.jsilver.functions.bundles.ClearSilverCompatibleFunctions;
import com.google.clearsilver.jsilver.interpreter.InterpretedTemplateLoader;
import com.google.clearsilver.jsilver.interpreter.LoadingTemplateFactory;
import com.google.clearsilver.jsilver.interpreter.OptimizerProvider;
import com.google.clearsilver.jsilver.interpreter.OptimizingTemplateFactory;
import com.google.clearsilver.jsilver.interpreter.TemplateFactory;
import com.google.clearsilver.jsilver.output.InstanceOutputBufferProvider;
import com.google.clearsilver.jsilver.output.OutputBufferProvider;
import com.google.clearsilver.jsilver.output.ThreadLocalOutputBufferProvider;
import com.google.clearsilver.jsilver.precompiler.PrecompiledTemplateLoader;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.syntax.DataCommandConsolidator;
import com.google.clearsilver.jsilver.syntax.StructuralWhitespaceStripper;
import com.google.clearsilver.jsilver.syntax.SyntaxTreeOptimizer;
import com.google.clearsilver.jsilver.syntax.node.Switch;
import com.google.clearsilver.jsilver.template.DelegatingTemplateLoader;
import com.google.clearsilver.jsilver.template.HtmlWhiteSpaceStripper;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import java.io.IOException;
import java.util.LinkedList;

public final class JSilver
implements TemplateRenderer,
DataLoader {
    private final JSilverOptions options;
    private final TemplateLoader templateLoader;
    private final FunctionRegistry globalFunctions = new ClearSilverCompatibleFunctions();
    private final ResourceLoader defaultResourceLoader;
    private final DataFactory dataFactory;
    private final OutputBufferProvider outputBufferProvider;
    public static final String VAR_ESCAPE_MODE_KEY = "Config.VarEscapeMode";
    public static final String AUTO_ESCAPE_KEY = "Config.AutoEscape";

    public JSilver(ResourceLoader resourceLoader, JSilverOptions jSilverOptions) {
        Object object;
        Object object2;
        jSilverOptions = jSilverOptions.clone();
        this.defaultResourceLoader = resourceLoader;
        this.dataFactory = new HDFDataFactory(jSilverOptions.getIgnoreAttributes(), jSilverOptions.getStringInternStrategy());
        this.options = jSilverOptions;
        int n = jSilverOptions.getInitialBufferSize();
        this.outputBufferProvider = jSilverOptions.getUseOutputBufferPool() ? new ThreadLocalOutputBufferProvider(n) : new InstanceOutputBufferProvider(n);
        TemplateFactory templateFactory = new LoadingTemplateFactory();
        templateFactory = this.setupOptimizerFactory(templateFactory);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        AutoEscapeOptions autoEscapeOptions = new AutoEscapeOptions();
        autoEscapeOptions.setPropagateEscapeStatus(jSilverOptions.getPropagateEscapeStatus());
        autoEscapeOptions.setLogEscapedVariables(jSilverOptions.getLogEscapedVariables());
        if (jSilverOptions.getCompileTemplates()) {
            object2 = new TemplateCompiler(templateFactory, this.globalFunctions, autoEscapeOptions);
            linkedList.add(object2);
            object = object2;
        } else {
            object2 = new InterpretedTemplateLoader(templateFactory, this.globalFunctions, autoEscapeOptions);
            linkedList.add(object2);
            object = object2;
        }
        if (jSilverOptions.getPrecompiledTemplateMap() != null) {
            object2 = new PrecompiledTemplateLoader((TemplateLoader)object, jSilverOptions.getPrecompiledTemplateMap(), this.globalFunctions, autoEscapeOptions);
            linkedList.add(object2);
            object = object2;
        }
        for (DelegatingTemplateLoader delegatingTemplateLoader : linkedList) {
            delegatingTemplateLoader.setTemplateLoaderDelegate((TemplateLoader)object);
        }
        this.templateLoader = object;
    }

    private TemplateFactory setupOptimizerFactory(TemplateFactory templateFactory) {
        OptimizerProvider optimizerProvider = new OptimizerProvider(){

            public Switch getOptimizer() {
                return new DataCommandConsolidator();
            }
        };
        OptimizerProvider optimizerProvider2 = new OptimizerProvider(){

            public Switch getOptimizer() {
                return new SyntaxTreeOptimizer();
            }
        };
        OptimizerProvider optimizerProvider3 = null;
        if (this.options.getStripStructuralWhiteSpace()) {
            optimizerProvider3 = new OptimizerProvider(){

                public Switch getOptimizer() {
                    return new StructuralWhitespaceStripper();
                }
            };
        }
        return new OptimizingTemplateFactory(templateFactory, optimizerProvider, optimizerProvider2, optimizerProvider3);
    }

    @Deprecated
    public JSilver(ResourceLoader resourceLoader, boolean bl) {
        this(resourceLoader, new JSilverOptions().setCacheTemplates(bl));
    }

    public JSilver(ResourceLoader resourceLoader) {
        this(resourceLoader, new JSilverOptions());
    }

    public void render(String string, Data data, Appendable appendable, ResourceLoader resourceLoader) throws IOException, JSilverException {
        EscapeMode escapeMode = this.getEscapeMode(data);
        this.render(this.templateLoader.load(string, resourceLoader, escapeMode), data, appendable, resourceLoader);
    }

    public void render(String string, Data data, Appendable appendable) throws IOException, JSilverException {
        this.render(string, data, appendable, this.defaultResourceLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(String string, Data data) throws IOException, JSilverException {
        Appendable appendable = this.createAppendableBuffer();
        try {
            this.render(string, data, appendable);
            String string2 = appendable.toString();
            return string2;
        }
        finally {
            this.releaseAppendableBuffer(appendable);
        }
    }

    public void render(Template template, Data data, Appendable appendable, ResourceLoader resourceLoader) throws IOException, JSilverException {
        if (this.options.getStripHtmlWhiteSpace() && !(appendable instanceof HtmlWhiteSpaceStripper)) {
            appendable = new HtmlWhiteSpaceStripper(appendable);
        }
        template.render(data, appendable, resourceLoader);
    }

    public void render(Template template, Data data, Appendable appendable) throws IOException, JSilverException {
        this.render(template, data, appendable, this.defaultResourceLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(Template template, Data data) throws IOException, JSilverException {
        Appendable appendable = this.createAppendableBuffer();
        try {
            this.render(template, data, appendable);
            String string = appendable.toString();
            return string;
        }
        finally {
            this.releaseAppendableBuffer(appendable);
        }
    }

    public void renderFromContent(String string, Data data, Appendable appendable) throws IOException, JSilverException {
        EscapeMode escapeMode = this.getEscapeMode(data);
        this.render(this.templateLoader.createTemp("[renderFromContent]", string, escapeMode), data, appendable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderFromContent(String string, Data data) throws IOException, JSilverException {
        Appendable appendable = this.createAppendableBuffer();
        try {
            this.renderFromContent(string, data, appendable);
            String string2 = appendable.toString();
            return string2;
        }
        finally {
            this.releaseAppendableBuffer(appendable);
        }
    }

    public EscapeMode getEscapeMode(Data data) {
        EscapeMode escapeMode = EscapeMode.computeEscapeMode(data.getValue(VAR_ESCAPE_MODE_KEY), data.getBooleanValue(AUTO_ESCAPE_KEY));
        if (escapeMode.equals((Object)EscapeMode.ESCAPE_NONE)) {
            escapeMode = this.options.getEscapeMode();
        }
        return escapeMode;
    }

    public Appendable createAppendableBuffer() {
        return this.outputBufferProvider.get();
    }

    public void releaseAppendableBuffer(Appendable appendable) {
        this.outputBufferProvider.release(appendable);
    }

    public void registerGlobalFunction(String string, Function function) {
        this.globalFunctions.registerFunction(string, function);
    }

    public void registerGlobalFunction(String string, TextFilter textFilter) {
        this.globalFunctions.registerFunction(string, textFilter);
    }

    public void registerGlobalEscaper(String string, TextFilter textFilter) {
        this.globalFunctions.registerFunction(string + "_escape", textFilter, true);
        this.globalFunctions.registerEscapeMode(string, textFilter);
    }

    public Data createData() {
        return this.dataFactory.createData();
    }

    public void loadData(String string, Data data) throws JSilverBadSyntaxException, IOException {
        this.dataFactory.loadData(string, this.defaultResourceLoader, data);
    }

    public Data loadData(String string) throws IOException {
        return this.dataFactory.loadData(string, this.defaultResourceLoader);
    }

    public ResourceLoader getResourceLoader() {
        return this.defaultResourceLoader;
    }

    public void clearCache() {
    }

    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    public JSilverOptions getOptions() {
        return this.options.clone();
    }
}

