/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.adaptor;

import com.google.clearsilver.jsilver.JSilver;
import com.google.clearsilver.jsilver.adaptor.JHdf;
import com.google.clearsilver.jsilver.adaptor.LoadPathToFileCache;
import com.google.clearsilver.jsilver.adaptor.ResourceLoaderAdaptor;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.LocalAndGlobalData;
import com.google.clearsilver.jsilver.exceptions.JSilverIOException;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.template.HtmlWhiteSpaceStripper;
import com.google.clearsilver.jsilver.template.Template;
import java.io.IOException;
import org.clearsilver.CS;
import org.clearsilver.CSFileLoader;
import org.clearsilver.HDF;

class JCs
implements CS {
    private final JHdf localHdf;
    private JHdf globalHdf;
    private final JSilver jSilver;
    private final LoadPathToFileCache loadPathCache;
    private Template template = null;
    private CSFileLoader csFileLoader;
    private ResourceLoaderAdaptor resourceLoaderAdaptor;

    JCs(JHdf jHdf, JSilver jSilver, LoadPathToFileCache loadPathToFileCache) {
        this.localHdf = jHdf;
        this.jSilver = jSilver;
        this.loadPathCache = loadPathToFileCache;
        this.resourceLoaderAdaptor = this.localHdf.getResourceLoaderAdaptor();
        this.csFileLoader = this.resourceLoaderAdaptor.getCSFileLoader();
    }

    private JSilver getJSilver() {
        return this.jSilver;
    }

    public void setGlobalHDF(HDF hDF) {
        this.globalHdf = JHdf.cast(hDF);
    }

    public HDF getGlobalHDF() {
        return this.globalHdf;
    }

    public void close() {
        this.template = null;
    }

    public void parseFile(String string) throws IOException {
        try {
            if (this.getEscapeMode().isAutoEscapingMode() && this.localHdf.getData().getValue("Config.PropagateEscapeStatus") != null) {
                throw new IllegalArgumentException("Config.PropagateEscapeStatus does not work with JSilver.Use JSilverOptions.setPropagateEscapeStatus instead");
            }
            this.template = this.getJSilver().getTemplateLoader().load(string, this.resourceLoaderAdaptor, this.getEscapeMode());
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            if (runtimeException2 instanceof JSilverIOException) {
                throw (IOException)runtimeException2.getCause();
            }
            throw runtimeException;
        }
    }

    public void parseStr(String string) {
        if (this.getEscapeMode().isAutoEscapingMode() && this.localHdf.getData().getValue("Config.PropagateEscapeStatus") != null) {
            throw new IllegalArgumentException("Config.PropagateEscapeStatus does not work with JSilver.Use JSilverOptions.setPropagateEscapeStatus instead");
        }
        this.template = this.getJSilver().getTemplateLoader().createTemp("parseStr", string, this.getEscapeMode());
    }

    private EscapeMode getEscapeMode() {
        Data data = this.localHdf.getData();
        return this.getJSilver().getEscapeMode(data);
    }

    public String render() {
        if (this.template == null) {
            throw new IllegalStateException("Call parseFile() or parseStr() before render()");
        }
        Data data = this.globalHdf != null ? new LocalAndGlobalData(this.localHdf.getData(), this.globalHdf.getData(), this.jSilver.getOptions().getAllowGlobalDataModification()) : this.localHdf.getData();
        Appendable appendable = this.jSilver.createAppendableBuffer();
        try {
            Appendable appendable2 = appendable;
            int n = this.localHdf.getIntValue("ClearSilver.WhiteSpaceStrip", 0);
            if (n > 0) {
                appendable2 = new HtmlWhiteSpaceStripper(appendable2, n);
            }
            this.jSilver.render(this.template, data, appendable2, (ResourceLoader)this.resourceLoaderAdaptor);
            String string = appendable2.toString();
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            this.jSilver.releaseAppendableBuffer(appendable);
        }
    }

    public CSFileLoader getFileLoader() {
        return this.csFileLoader;
    }

    public void setFileLoader(CSFileLoader cSFileLoader) {
        if (cSFileLoader == null && this.csFileLoader == null) {
            return;
        }
        if (cSFileLoader != null && cSFileLoader.equals(this.csFileLoader)) {
            return;
        }
        this.csFileLoader = cSFileLoader;
        this.resourceLoaderAdaptor = new ResourceLoaderAdaptor(this.localHdf, this.loadPathCache, this.csFileLoader);
    }
}

