/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.adaptor;

import com.google.clearsilver.jsilver.JSilver;
import com.google.clearsilver.jsilver.JSilverOptions;
import com.google.clearsilver.jsilver.adaptor.JCs;
import com.google.clearsilver.jsilver.adaptor.JHdf;
import com.google.clearsilver.jsilver.adaptor.LoadPathToFileCache;
import com.google.clearsilver.jsilver.data.DataFactory;
import com.google.clearsilver.jsilver.data.DefaultData;
import com.google.clearsilver.jsilver.data.HDFDataFactory;
import org.clearsilver.ClearsilverFactory;
import org.clearsilver.DelegatedHdf;
import org.clearsilver.HDF;

public class JSilverFactory
implements ClearsilverFactory {
    private static final JSilverOptions DEFAULT_OPTIONS = new JSilverOptions();
    private final boolean unwrapDelegatedHdfs;
    private final JSilver jSilver;
    private final JSilverOptions options;
    private final DataFactory dataFactory;
    private final LoadPathToFileCache loadPathCache;

    public JSilverFactory() {
        this(DEFAULT_OPTIONS);
    }

    public JSilverFactory(JSilverOptions jSilverOptions) {
        this(jSilverOptions, true);
    }

    public JSilverFactory(JSilverOptions jSilverOptions, boolean bl) {
        this(new JSilver(null, jSilverOptions), bl);
    }

    public JSilverFactory(JSilver jSilver, boolean bl) {
        this.unwrapDelegatedHdfs = bl;
        this.jSilver = jSilver;
        this.options = jSilver.getOptions();
        this.loadPathCache = this.options.getLoadPathCacheSize() == 0 ? null : new LoadPathToFileCache(this.options.getLoadPathCacheSize());
        this.dataFactory = new HDFDataFactory(this.options.getIgnoreAttributes(), this.options.getStringInternStrategy());
    }

    public JCs newCs(HDF hDF) {
        if (this.unwrapDelegatedHdfs) {
            hDF = DelegatedHdf.getFullyUnwrappedHdf(hDF);
        }
        return new JCs(JHdf.cast(hDF), this.jSilver, this.loadPathCache);
    }

    public JCs newCs(HDF hDF, HDF hDF2) {
        if (this.unwrapDelegatedHdfs) {
            hDF = DelegatedHdf.getFullyUnwrappedHdf(hDF);
            hDF2 = DelegatedHdf.getFullyUnwrappedHdf(hDF2);
        }
        JCs jCs = new JCs(JHdf.cast(hDF), this.jSilver, this.loadPathCache);
        jCs.setGlobalHDF(hDF2);
        return jCs;
    }

    public JHdf newHdf() {
        return new JHdf(new DefaultData(), this.dataFactory, this.loadPathCache, this.options);
    }
}

