/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.adaptor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadPathToFileCache {
    private final LRUCache<String, String> cache;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    public LoadPathToFileCache(int n) {
        this.cache = new LRUCache(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookup(List<String> list, String string) {
        String string2 = LoadPathToFileCache.makeCacheKey(list, string);
        this.cacheLock.readLock().lock();
        try {
            String string3 = (String)this.cache.get(string2);
            return string3;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<String> list, String string, String string2) {
        String string3 = LoadPathToFileCache.makeCacheKey(list, string);
        this.cacheLock.writeLock().lock();
        try {
            this.cache.put(string3, string2);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    public static String makeCacheKey(List<String> list, String string) {
        if (list == null) {
            throw new NullPointerException("Loadpaths cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("Filename cannot be null");
        }
        String string2 = Long.toHexString(LoadPathToFileCache.hashLoadPath(list));
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append('|').append(string);
        return stringBuilder.toString();
    }

    static long hashLoadPath(List<String> list) {
        long l = 17L;
        for (String string : list) {
            l = 37L * l + (long)string.hashCode();
        }
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        LRUCache(int n) {
            super(n, 0.75f, true);
            this.capacity = n;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > this.capacity;
        }
    }
}

