/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DelegatedData;
import com.google.clearsilver.jsilver.data.TypeConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedData
extends DelegatedData {
    public static final Logger logger = Logger.getLogger(ChainedData.class.getName());
    public static final boolean DEBUG_MULTIPLE_ASSIGNMENTS = false;
    Data[] dataList;

    public ChainedData(Data data) {
        super(data);
        this.dataList = new Data[]{data};
    }

    public ChainedData(Data ... dataArray) {
        super(ChainedData.getFirstData(dataArray));
        this.dataList = dataArray;
    }

    public ChainedData(List<Data> list) {
        super(ChainedData.getFirstData(list));
        this.dataList = list.toArray(new Data[list.size()]);
    }

    @Override
    protected DelegatedData newInstance(Data data) {
        return data == null ? null : new ChainedData(data);
    }

    private static Data getFirstData(Data[] dataArray) {
        if (dataArray.length == 0) {
            throw new IllegalArgumentException("Must pass in at least one Data object to ChainedData.");
        }
        Data data = dataArray[0];
        if (data == null) {
            throw new IllegalArgumentException("ChainedData does not accept null Data objects.");
        }
        return data;
    }

    private static Data getFirstData(List<Data> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("Must pass in at least one Data object to ChainedData.");
        }
        Data data = list.get(0);
        if (data == null) {
            throw new IllegalArgumentException("ChainedData does not accept null Data objects.");
        }
        return data;
    }

    @Override
    public Data getChild(String string) {
        ArrayList arrayList = null;
        Data data = null;
        for (Data data2 : this.dataList) {
            Data data3 = data2.getChild(string);
            if (data3 == null) continue;
            return data3;
        }
        if (arrayList == null) {
            return data;
        }
        logger.info("Found " + arrayList.size() + " matches for path " + string);
        return data;
    }

    @Override
    public Data createChild(String string) {
        Data data = this.getChild(string);
        if (data != null) {
            return data;
        }
        return this.dataList[0].createChild(string);
    }

    @Override
    public String getValue(String string, String string2) {
        Data data = this.getChild(string);
        if (data != null && data.getValue() != null) {
            return data.getValue();
        }
        return string2;
    }

    @Override
    public int getIntValue(String string, int n) {
        Data data = this.getChild(string);
        if (data != null) {
            String string2 = data.getValue();
            try {
                return string2 == null ? n : TypeConverter.parseNumber(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    @Override
    public String getValue(String string) {
        Data data = this.getChild(string);
        if (data != null) {
            return data.getValue();
        }
        return null;
    }

    @Override
    public int getIntValue(String string) {
        Data data = this.getChild(string);
        if (data != null) {
            return data.getIntValue();
        }
        return 0;
    }

    @Override
    public boolean getBooleanValue(String string) {
        Data data = this.getChild(string);
        if (data != null) {
            return data.getBooleanValue();
        }
        return false;
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        for (Data data : this.dataList) {
            data.toString(stringBuilder, n);
        }
    }

    @Override
    public void write(Appendable appendable, int n) throws IOException {
        for (Data data : this.dataList) {
            data.write(appendable, n);
        }
    }

    @Override
    public void optimize() {
        for (Data data : this.dataList) {
            data.optimize();
        }
    }
}

