/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.AbstractData;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataContext;
import java.io.IOException;
import java.util.Map;

public class DefaultDataContext
implements DataContext {
    private final Data rootData;
    private LocalVariable head = null;
    private boolean newScope = false;

    public DefaultDataContext(Data data) {
        if (data == null) {
            throw new IllegalArgumentException("rootData is null");
        }
        this.rootData = data;
    }

    public Data getRootData() {
        return this.rootData;
    }

    public void pushVariableScope() {
        if (this.newScope) {
            throw new IllegalStateException("PushVariableScope called twice with no variables declared in between.");
        }
        this.newScope = true;
    }

    public void popVariableScope() {
        if (this.newScope) {
            this.newScope = false;
        } else {
            this.head = this.head.nextScope;
        }
    }

    public void createLocalVariableByValue(String string, String string2) {
        this.createLocalVariableByValue(string, string2, EscapeMode.ESCAPE_NONE);
    }

    public void createLocalVariableByValue(String string, String string2, EscapeMode escapeMode) {
        LocalVariable localVariable = this.createLocalVariable(string);
        localVariable.value = string2;
        localVariable.isPath = false;
        localVariable.setEscapeMode(escapeMode);
    }

    public void createLocalVariableByValue(String string, String string2, boolean bl, boolean bl2) {
        LocalVariable localVariable = this.createLocalVariable(string);
        localVariable.value = string2;
        localVariable.isPath = false;
        localVariable.isFirst = bl;
        localVariable.isLast = bl2;
    }

    public void createLocalVariableByPath(String string, String string2) {
        LocalVariable localVariable = this.createLocalVariable(string);
        localVariable.value = string2;
        localVariable.isPath = true;
    }

    private LocalVariable createLocalVariable(String string) {
        if (this.head == null && !this.newScope) {
            throw new IllegalStateException("Must call pushVariableScope before creating local variable.");
        }
        if (!this.newScope && this.head != null && string.equals(this.head.name)) {
            this.head.isFirst = true;
            this.head.isLast = true;
            this.head.node = null;
            return this.head;
        }
        LocalVariable localVariable = new LocalVariable();
        localVariable.name = string;
        localVariable.next = this.head;
        if (this.newScope) {
            localVariable.nextScope = this.head;
            this.newScope = false;
        } else {
            localVariable.nextScope = this.head != null ? this.head.nextScope : null;
        }
        this.head = localVariable;
        return localVariable;
    }

    public Data findVariable(String string, boolean bl) {
        return this.findVariable(string, bl, this.head);
    }

    public EscapeMode findVariableEscapeMode(String string) {
        Data data = this.findVariable(string, false);
        if (data == null) {
            return EscapeMode.ESCAPE_NONE;
        }
        return data.getEscapeMode();
    }

    private Data findVariable(String string, boolean bl, LocalVariable localVariable) {
        String string2 = string;
        int n = string.indexOf(46);
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        LocalVariable localVariable2 = localVariable;
        while (localVariable2 != null) {
            if (localVariable2.name.equals(string2)) {
                if (localVariable2.isPath) {
                    if (localVariable2.node == null) {
                        localVariable2.node = this.findVariable(localVariable2.value, bl, localVariable2.nextScope);
                        if (localVariable2.node == null) {
                            return null;
                        }
                    }
                    if (n == -1) {
                        return localVariable2.node;
                    }
                    if (bl) {
                        return localVariable2.node.createChild(string.substring(n + 1));
                    }
                    return localVariable2.node.getChild(string.substring(n + 1));
                }
                if (n == -1) {
                    return localVariable2;
                }
                if (bl) {
                    throw new IllegalStateException("Cannot create children of a local literal variable");
                }
                return null;
            }
            localVariable2 = localVariable2.next;
        }
        if (bl) {
            return this.rootData.createChild(string);
        }
        return this.rootData.getChild(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalVariable
    extends AbstractData {
        LocalVariable next;
        LocalVariable nextScope;
        String name;
        String value;
        boolean isPath;
        Data node = null;
        boolean isFirst = true;
        boolean isLast = true;

        private LocalVariable() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String string) {
            this.value = string;
        }

        @Override
        public String getFullPath() {
            return this.name;
        }

        @Override
        public void setAttribute(String string, String string2) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public String getAttribute(String string) {
            return null;
        }

        @Override
        public boolean hasAttribute(String string) {
            return false;
        }

        @Override
        public int getAttributeCount() {
            return 0;
        }

        @Override
        public Iterable<Map.Entry<String, String>> getAttributes() {
            return null;
        }

        @Override
        public Data getRoot() {
            return null;
        }

        @Override
        public Data getParent() {
            return null;
        }

        @Override
        public boolean isFirstSibling() {
            return this.isFirst;
        }

        @Override
        public boolean isLastSibling() {
            return this.isLast;
        }

        @Override
        public Data getNextSibling() {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public Iterable<? extends Data> getChildren() {
            return null;
        }

        @Override
        public Data getChild(String string) {
            return null;
        }

        @Override
        public Data createChild(String string) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void removeTree(String string) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void setSymlink(String string, String string2) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void setSymlink(String string, Data data) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void setSymlink(Data data) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public Data getSymlink() {
            return this;
        }

        @Override
        public void copy(String string, Data data) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void copy(Data data) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public String getValue(String string, String string2) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void write(Appendable appendable, int n) throws IOException {
            for (int i = 0; i < n; ++i) {
                appendable.append("  ");
            }
            appendable.append(this.getName()).append(" = ").append(this.getValue());
        }
    }
}

