/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.Parser;
import com.google.clearsilver.jsilver.data.ParserFactory;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHdfParser
implements Parser {
    private int initialContextSize = 10;

    @Override
    public void parse(Reader reader, Data data, Parser.ErrorHandler errorHandler, ResourceLoader resourceLoader, String string, boolean bl) throws IOException {
        String string2;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>(this.initialContextSize);
        while ((string2 = lineNumberReader.readLine()) != null) {
            this.parseLine(string2, data, arrayList, lineNumberReader, string, errorHandler);
        }
    }

    private void parseLine(String string, Data data, List<String> list, LineNumberReader lineNumberReader, String string2, Parser.ErrorHandler errorHandler) throws IOException {
        Split split = this.split(string = this.stripComment(string), "=");
        if (split != null) {
            data.setValue(this.createFullPath(list, split.left), split.right);
        } else {
            split = this.split(string, "<<");
            if (split != null) {
                data.setValue(this.createFullPath(list, split.left), this.readToToken(lineNumberReader, split.right));
            } else {
                split = this.split(string, "{");
                if (split != null) {
                    list.add(split.left);
                } else if (this.split(string, "}") != null) {
                    list.remove(list.size() - 1);
                } else {
                    split = this.split(string, ":");
                    if (split != null) {
                        data.setSymlink(this.createFullPath(list, split.left), split.right);
                    } else if (string.trim().length() != 0 && errorHandler != null) {
                        errorHandler.error(lineNumberReader.getLineNumber(), string, string2, "Bad HDF syntax");
                    }
                }
            }
        }
    }

    private String stripComment(String string) {
        int n = string.indexOf(35);
        int n2 = string.indexOf(61);
        if (n > -1 && (n2 == -1 || n < n2)) {
            return string.substring(0, n);
        }
        return string;
    }

    private String readToToken(LineNumberReader lineNumberReader, String string) throws IOException {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string2 = lineNumberReader.readLine()) != null && !string2.trim().equals(string)) {
            stringBuilder.append(string2).append('\n');
        }
        return stringBuilder.toString();
    }

    private String createFullPath(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            stringBuilder.append(string2).append('.');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private Split split(String string, String string2) {
        int n = string.indexOf(string2);
        if (n > -1) {
            Split split = new Split();
            split.left = string.substring(0, n).trim();
            split.right = string.substring(n + string2.length()).trim();
            return split;
        }
        return null;
    }

    public static ParserFactory newFactory() {
        return new ParserFactory(){

            public Parser newInstance() {
                return new DefaultHdfParser();
            }
        };
    }

    private static class Split {
        String left;
        String right;

        private Split() {
        }
    }
}

