/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.AbstractData;
import com.google.clearsilver.jsilver.data.ChainedData;
import com.google.clearsilver.jsilver.data.Data;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedMapData
extends AbstractData {
    private static final int CHILD_MAP_THRESHOLD = 4;
    private String name;
    private NestedMapData parent;
    private final NestedMapData root;
    private Map<String, NestedMapData> children = null;
    private int childCount = 0;
    private NestedMapData firstChild = null;
    private NestedMapData lastChild = null;
    private Iterable<NestedMapData> iterableChildren = null;
    private Map<String, String> attributeList = null;
    private String value = null;
    private NestedMapData symLink = this;
    private NestedMapData prevSibling = null;
    private NestedMapData nextSibling = null;

    public NestedMapData() {
        this.name = null;
        this.parent = null;
        this.root = this;
    }

    protected NestedMapData(String string, NestedMapData nestedMapData, NestedMapData nestedMapData2) {
        this.name = string;
        this.parent = nestedMapData;
        this.root = nestedMapData2;
    }

    protected NestedMapData createChildNode(String string) {
        NestedMapData nestedMapData = this.followSymLinkToTheBitterEnd();
        NestedMapData nestedMapData2 = new NestedMapData(string, nestedMapData, nestedMapData.root);
        if (nestedMapData.children == null && nestedMapData.childCount >= 4) {
            nestedMapData.children = new HashMap<String, NestedMapData>();
            NestedMapData nestedMapData3 = nestedMapData.firstChild;
            while (nestedMapData3 != null) {
                nestedMapData.children.put(nestedMapData3.getName(), nestedMapData3);
                nestedMapData3 = nestedMapData3.nextSibling;
            }
        }
        if (nestedMapData.children != null) {
            nestedMapData.children.put(string, nestedMapData2);
        }
        nestedMapData2.prevSibling = nestedMapData.lastChild;
        if (nestedMapData.lastChild != null) {
            nestedMapData.lastChild.nextSibling = nestedMapData2;
        } else {
            nestedMapData.firstChild = nestedMapData2;
        }
        nestedMapData.lastChild = nestedMapData2;
        ++nestedMapData.childCount;
        return nestedMapData2;
    }

    private void severNode() {
        if (this.parent == null) {
            return;
        }
        if (this.parent.children != null) {
            this.parent.children.remove(this.name);
        }
        if (this.prevSibling != null) {
            this.prevSibling.nextSibling = this.nextSibling;
        } else {
            this.parent.firstChild = this.nextSibling;
        }
        if (this.nextSibling != null) {
            this.nextSibling.prevSibling = this.prevSibling;
        } else {
            this.parent.lastChild = this.prevSibling;
        }
        --this.parent.childCount;
        this.parent = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void getPathName(StringBuilder stringBuilder) {
        String string;
        if (this.parent != null && this.parent != this.root) {
            this.parent.getPathName(stringBuilder);
            stringBuilder.append(".");
        }
        if ((string = this.getName()) != null) {
            stringBuilder.append(string);
        }
    }

    @Override
    public String getFullPath() {
        StringBuilder stringBuilder = new StringBuilder();
        this.getPathName(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public String getValue() {
        return this.followSymLinkToTheBitterEnd().value;
    }

    @Override
    public void setValue(String string) {
        this.symLink = this;
        this.value = string;
    }

    @Override
    public void setAttribute(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Attribute name cannot be null.");
        }
        if (this.attributeList == null) {
            this.attributeList = new HashMap<String, String>();
        }
        if (string2 == null) {
            this.attributeList.remove(string);
        } else {
            this.attributeList.put(string, string2);
        }
    }

    @Override
    public String getAttribute(String string) {
        return this.attributeList == null ? null : this.attributeList.get(string);
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.attributeList != null && this.attributeList.containsKey(string);
    }

    @Override
    public int getAttributeCount() {
        return this.attributeList == null ? 0 : this.attributeList.size();
    }

    @Override
    public Iterable<Map.Entry<String, String>> getAttributes() {
        if (this.attributeList == null) {
            return Collections.emptySet();
        }
        return this.attributeList.entrySet();
    }

    @Override
    public Data getRoot() {
        return this.root;
    }

    @Override
    public Data getParent() {
        return this.parent;
    }

    @Override
    public boolean isFirstSibling() {
        return this.prevSibling == null;
    }

    @Override
    public boolean isLastSibling() {
        return this.nextSibling == null;
    }

    @Override
    public Data getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public int getChildCount() {
        return this.followSymLinkToTheBitterEnd().childCount;
    }

    @Override
    public Iterable<? extends Data> getChildren() {
        if (this.iterableChildren == null) {
            this.iterableChildren = new IterableChildren();
        }
        return this.iterableChildren;
    }

    @Override
    public NestedMapData getChild(String string) {
        NestedMapData nestedMapData = this;
        int n = 0;
        int n2 = 0;
        while (n2 != -1 && nestedMapData != null) {
            n2 = string.indexOf(46, n);
            String string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
            nestedMapData = nestedMapData.followSymLinkToTheBitterEnd().getChildNode(string2);
            n = n2 + 1;
        }
        return nestedMapData;
    }

    @Override
    public NestedMapData createChild(String string) {
        NestedMapData nestedMapData = this;
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(46, n);
            String string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
            NestedMapData nestedMapData2 = nestedMapData.followSymLinkToTheBitterEnd();
            if ((nestedMapData = nestedMapData2.getChildNode(string2)) == null) {
                nestedMapData = nestedMapData2.createChildNode(string2);
            }
            n = n2 + 1;
        }
        return nestedMapData;
    }

    private NestedMapData getChildNode(String string) {
        NestedMapData nestedMapData = this.followSymLinkToTheBitterEnd();
        if (nestedMapData.getChildCount() == 0) {
            return null;
        }
        if (nestedMapData.children != null) {
            return nestedMapData.children.get(string);
        }
        NestedMapData nestedMapData2 = nestedMapData.firstChild;
        while (nestedMapData2 != null) {
            if (nestedMapData2.getName().equals(string)) {
                return nestedMapData2;
            }
            nestedMapData2 = nestedMapData2.nextSibling;
        }
        return null;
    }

    @Override
    public void removeTree(String string) {
        NestedMapData nestedMapData = this.getChild(string);
        if (nestedMapData != null) {
            nestedMapData.severNode();
        }
    }

    private NestedMapData followSymLinkToTheBitterEnd() {
        NestedMapData nestedMapData = this;
        while (nestedMapData.symLink != nestedMapData) {
            nestedMapData = nestedMapData.symLink;
        }
        return nestedMapData;
    }

    @Override
    public void setSymlink(String string, String string2) {
        this.setSymlink(string, this.createChild(string2));
    }

    @Override
    public void setSymlink(String string, Data data) {
        this.createChild(string).setSymlink(data);
    }

    @Override
    public void setSymlink(Data data) {
        if (!(data instanceof NestedMapData)) {
            String string = "Cannot set symlink of incompatible Data type: " + data.getClass().getName();
            if (data instanceof ChainedData) {
                string = string + "\nOther type is ChainedData indicating there are multiple valid Data nodes for the path: " + data.getFullPath();
            }
            throw new IllegalArgumentException(string);
        }
        this.symLink = (NestedMapData)data;
    }

    @Override
    public Data getSymlink() {
        return this.symLink;
    }

    @Override
    public void copy(String string, Data data) {
        if (string == null) {
            throw new NullPointerException("Invalid copy destination path");
        }
        if (data == null) {
            return;
        }
        NestedMapData nestedMapData = this.createChild(string);
        nestedMapData.copy(data);
    }

    @Override
    public void copy(Data data) {
        if (data == null) {
            return;
        }
        this.symLink = this;
        if (this.attributeList != null) {
            this.attributeList.clear();
        }
        for (Map.Entry<String, String> object : data.getAttributes()) {
            this.setAttribute(object.getKey(), object.getValue());
        }
        if (data.getSymlink() != data) {
            this.setSymlink(data.getSymlink());
            return;
        }
        this.setValue(data.getValue());
        for (Data data2 : data.getChildren()) {
            NestedMapData nestedMapData = this.createChild(data2.getName());
            nestedMapData.copy(data2);
        }
    }

    @Override
    public void write(Appendable appendable, int n) throws IOException {
        if (this.symLink != this) {
            this.indent(appendable, n);
            this.writeNameAttrs(appendable);
            appendable.append(" : ").append(this.symLink.getFullPath()).append('\n');
            return;
        }
        if (this.getValue() != null) {
            this.indent(appendable, n);
            this.writeNameAttrs(appendable);
            if (this.getValue().contains("\n")) {
                this.writeMultiline(appendable);
            } else {
                appendable.append(" = ").append(this.getValue()).append('\n');
            }
        }
        if (this.getChildCount() > 0) {
            int n2 = n;
            if (this != this.root) {
                this.indent(appendable, n);
                this.writeNameAttrs(appendable);
                appendable.append(" {\n");
                ++n2;
            }
            for (Data data : this.getChildren()) {
                data.write(appendable, n2);
            }
            if (this != this.root) {
                this.indent(appendable, n);
                appendable.append("}\n");
            }
        }
    }

    @Override
    public void optimize() {
        Object object;
        this.name = this.name == null ? null : this.name.intern();
        String string = this.value = this.value == null ? null : this.value.intern();
        if (this.attributeList != null) {
            object = new HashMap(this.attributeList.size());
            for (Map.Entry<String, String> entry : this.attributeList.entrySet()) {
                String string2 = entry.getKey();
                String string3 = entry.getValue();
                string2 = string2 == null ? null : string2.intern();
                string3 = string3 == null ? null : string3.intern();
                object.put(string2, string3);
            }
            this.attributeList = object;
        }
        object = this.firstChild;
        while (object != null) {
            ((NestedMapData)object).optimize();
            object = ((NestedMapData)object).nextSibling;
        }
    }

    private void writeMultiline(Appendable appendable) throws IOException {
        String string = "EOM";
        while (this.getValue().contains(string)) {
            string = string + System.nanoTime() % 10L;
        }
        appendable.append(" << ").append(string).append('\n').append(this.getValue());
        if (!this.getValue().endsWith("\n")) {
            appendable.append('\n');
        }
        appendable.append(string).append('\n');
    }

    private void indent(Appendable appendable, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            appendable.append("  ");
        }
    }

    private void writeNameAttrs(Appendable appendable) throws IOException {
        appendable.append(this.getName());
        if (this.attributeList != null && !this.attributeList.isEmpty()) {
            appendable.append(" [");
            boolean bl = true;
            for (Map.Entry<String, String> entry : this.attributeList.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    appendable.append(", ");
                }
                appendable.append(entry.getKey());
                if (entry.getValue().equals("1")) continue;
                appendable.append(" = \"");
                NestedMapData.writeAttributeValue(appendable, entry.getValue());
                appendable.append('\"');
            }
            appendable.append(']');
        }
    }

    static void writeAttributeValue(Appendable appendable, String string) throws IOException {
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    appendable.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    appendable.append("\\n");
                    continue block7;
                }
                case '\t': {
                    appendable.append("\\t");
                    continue block7;
                }
                case '\\': {
                    appendable.append("\\\\");
                    continue block7;
                }
                case '\r': {
                    appendable.append("\\r");
                    continue block7;
                }
                default: {
                    appendable.append(c);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildrenIterator
    implements Iterator<NestedMapData> {
        NestedMapData current;
        NestedMapData next;

        ChildrenIterator(NestedMapData nestedMapData) {
            this.next = nestedMapData;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public NestedMapData next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = this.next.nextSibling;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.current.severNode();
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IterableChildren
    implements Iterable<NestedMapData> {
        private IterableChildren() {
        }

        @Override
        public Iterator<NestedMapData> iterator() {
            return new ChildrenIterator(NestedMapData.this.followSymLinkToTheBitterEnd().firstChild);
        }
    }
}

