/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.Parser;
import com.google.clearsilver.jsilver.data.ParserFactory;
import com.google.clearsilver.jsilver.data.StringInternStrategy;
import com.google.clearsilver.jsilver.data.UniqueStack;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewHdfParser
implements Parser {
    private final StringInternStrategy internStrategy;
    static final String UNNAMED_INPUT = "[UNNAMED_INPUT]";
    private static final String INCLUDE_WS = "#include ";
    private static final int NO_MATCH = -1;
    private static final String DEFAULT_ATTR_VALUE = "1";

    public NewHdfParser(StringInternStrategy stringInternStrategy) {
        this.internStrategy = stringInternStrategy;
    }

    public static ParserFactory newFactory(StringInternStrategy stringInternStrategy) {
        return new NewHdfParserFactory(stringInternStrategy);
    }

    @Override
    public void parse(Reader reader, Data data, Parser.ErrorHandler errorHandler, ResourceLoader resourceLoader, String string, boolean bl) throws IOException {
        this.parse(ParseState.createNewParseState(data, reader, errorHandler, resourceLoader, this, string, bl));
    }

    private void parse(ParseState parseState) throws IOException {
        while ((parseState.line = parseState.lineReader.readLine()) != null) {
            String string = NewHdfParser.stripWhitespace(parseState.line);
            try {
                this.parseCommand(string, parseState);
            }
            catch (OutOfCharsException outOfCharsException) {
                NewHdfParser.reportError(parseState, "End of line was prematurely reached. Parse error.");
            }
        }
    }

    private void parseCommand(String string, ParseState parseState) throws IOException, OutOfCharsException {
        if (string.length() == 0) {
            return;
        }
        if (NewHdfParser.charAt(string, 0) == '#') {
            if (NewHdfParser.matches(string, 0, INCLUDE_WS)) {
                int n = NewHdfParser.skipLeadingWhitespace(string, INCLUDE_WS.length());
                this.parseInclude(string, n, parseState);
            }
            return;
        }
        if (NewHdfParser.charAt(string, 0) == '}') {
            if (NewHdfParser.skipLeadingWhitespace(string, 1) != string.length()) {
                NewHdfParser.reportError(parseState, "Extra chars after '}'");
                return;
            }
            this.handleAscend(parseState);
        } else {
            this.parseHdfElement(string, parseState);
        }
    }

    private void parseInclude(String string, int n, ParseState parseState) throws IOException, OutOfCharsException {
        int n2 = string.length();
        if (NewHdfParser.charAt(string, n) == '\"') {
            if (NewHdfParser.charAt(string, n2 - 1) == '\"') {
                ++n;
                --n2;
            } else {
                NewHdfParser.reportError(parseState, "Missing '\"' at end of include");
                return;
            }
        }
        this.handleInclude(string.substring(n, n2), parseState);
    }

    private void parseHdfElement(String string, ParseState parseState) throws IOException, OutOfCharsException {
        HdfNameAttrs hdfNameAttrs = parseState.hdfNameAttrs;
        if (!this.parseHdfNameAttrs(hdfNameAttrs, string, 0, parseState)) {
            return;
        }
        int n = NewHdfParser.skipLeadingWhitespace(string, hdfNameAttrs.endOfSequence);
        switch (NewHdfParser.charAt(string, n)) {
            case '{': {
                if (n + 1 != string.length()) {
                    NewHdfParser.reportError(parseState, "No characters expected after '{'");
                    return;
                }
                this.handleDescend(parseState, hdfNameAttrs);
                return;
            }
            case '=': {
                n = NewHdfParser.skipLeadingWhitespace(string, n + 1);
                String string2 = this.internStrategy.intern(string.substring(n, string.length()));
                this.handleAssign(parseState, hdfNameAttrs, string2);
                return;
            }
            case ':': {
                if (NewHdfParser.charAt(string, n + 1) == '=') {
                    String string3 = this.parseHdfName(string, n = NewHdfParser.skipLeadingWhitespace(string, n + 2));
                    if (string3 == null) {
                        NewHdfParser.reportError(parseState, "Invalid HDF name");
                        return;
                    }
                    if (n + string3.length() != string.length()) {
                        NewHdfParser.reportError(parseState, "No characters expected after '{'");
                        return;
                    }
                    this.handleCopy(parseState, hdfNameAttrs, string3);
                } else {
                    String string4 = this.parseHdfName(string, n = NewHdfParser.skipLeadingWhitespace(string, n + 1));
                    if (string4 == null) {
                        NewHdfParser.reportError(parseState, "Invalid HDF name");
                        return;
                    }
                    if (n + string4.length() != string.length()) {
                        NewHdfParser.reportError(parseState, "No characters expected after '{'");
                        return;
                    }
                    this.handleLink(parseState, hdfNameAttrs, string4);
                }
                return;
            }
            case '<': {
                String string5;
                String string6;
                if (NewHdfParser.charAt(string, n + 1) != '<') {
                    NewHdfParser.reportError(parseState, "Expected '<<'");
                }
                if ((string6 = this.internStrategy.intern(this.parseMultilineValue(parseState, string5 = string.substring(n = NewHdfParser.skipLeadingWhitespace(string, n + 2), string.length())))) == null) {
                    return;
                }
                this.handleAssign(parseState, hdfNameAttrs, string6);
                return;
            }
        }
        NewHdfParser.reportError(parseState, "No valid operator");
    }

    private boolean parseHdfNameAttrs(HdfNameAttrs hdfNameAttrs, String string, int n, ParseState parseState) throws OutOfCharsException {
        String string2 = this.parseHdfName(string, n);
        if (string2 == null) {
            NewHdfParser.reportError(parseState, "Invalid HDF name");
            return false;
        }
        hdfNameAttrs.reset(string2);
        n = NewHdfParser.skipLeadingWhitespace(string, n + string2.length());
        int n2 = this.parseAttributes(string, n, parseState, hdfNameAttrs);
        if (n2 == -1) {
            return false;
        }
        hdfNameAttrs.endOfSequence = n2;
        return true;
    }

    private String parseHdfName(String string, int n) throws OutOfCharsException {
        int n2;
        for (n2 = n; n2 < string.length() && NewHdfParser.isHdfNameChar(NewHdfParser.charAt(string, n2)); ++n2) {
        }
        if (n2 == n) {
            return null;
        }
        return this.internStrategy.intern(string.substring(n, n2));
    }

    private int parseAttributes(String string, int n, ParseState parseState, HdfNameAttrs hdfNameAttrs) throws OutOfCharsException {
        if (NewHdfParser.charAt(string, n) != '[') {
            return n;
        }
        n = NewHdfParser.skipLeadingWhitespace(string, n + 1);
        if (parseState.ignoreAttributes) {
            while (NewHdfParser.charAt(string, n) != ']') {
                ++n;
            }
            return n + 1;
        }
        boolean bl = true;
        do {
            if (bl) {
                bl = false;
            } else if (NewHdfParser.charAt(string, n) == ',') {
                n = NewHdfParser.skipLeadingWhitespace(string, n + 1);
            } else {
                NewHdfParser.reportError(parseState, "Error parsing attribute list");
            }
            n = this.parseAttribute(string, n, parseState, hdfNameAttrs);
            if (n != -1) continue;
            return -1;
        } while (NewHdfParser.charAt(string, n = NewHdfParser.skipLeadingWhitespace(string, n)) != ']');
        return n + 1;
    }

    private int parseAttribute(String string, int n, ParseState parseState, HdfNameAttrs hdfNameAttrs) throws OutOfCharsException {
        int n2 = this.parseAttributeKey(string, n);
        if (n == n2) {
            NewHdfParser.reportError(parseState, "No valid attribute key");
            return -1;
        }
        String string2 = this.internStrategy.intern(string.substring(n, n2));
        n = NewHdfParser.skipLeadingWhitespace(string, n2);
        if (NewHdfParser.charAt(string, n) != '=') {
            hdfNameAttrs.addAttribute(string2, DEFAULT_ATTR_VALUE);
            return n;
        }
        if (NewHdfParser.charAt(string, n = NewHdfParser.skipLeadingWhitespace(string, n + 1)) == '\"') {
            StringBuilder stringBuilder = new StringBuilder();
            if ((n2 = this.parseQuotedAttributeValue(string, ++n, stringBuilder)) == -1) {
                NewHdfParser.reportError(parseState, "Unable to parse quoted attribute value");
                return -1;
            }
            String string3 = this.internStrategy.intern(stringBuilder.toString());
            hdfNameAttrs.addAttribute(string2, string3);
            ++n2;
        } else {
            String string4 = this.parseAttributeValue(string, n, parseState);
            if (string4 == null || string4.length() == 0) {
                NewHdfParser.reportError(parseState, "No attribute for key " + string2);
                return -1;
            }
            string4 = this.internStrategy.intern(string4);
            hdfNameAttrs.addAttribute(string2, string4);
            n2 = n + string4.length();
        }
        return n2;
    }

    private int parseAttributeKey(String string, int n) throws OutOfCharsException {
        while (NewHdfParser.isAlphaNumericChar(NewHdfParser.charAt(string, n))) {
            ++n;
        }
        return n;
    }

    private int parseQuotedAttributeValue(String string, int n, StringBuilder stringBuilder) throws OutOfCharsException {
        int n2;
        while ((n2 = NewHdfParser.charAt(string, n)) != 34) {
            if (n2 == 92) {
                char c;
                if (NewHdfParser.isNumericChar(c = NewHdfParser.charAt(string, ++n))) {
                    int n3 = c - 48;
                    if (NewHdfParser.isNumericChar(NewHdfParser.charAt(string, n + 1))) {
                        n3 = n3 * 8 + (NewHdfParser.charAt(string, ++n) - 48);
                        if (NewHdfParser.isNumericChar(NewHdfParser.charAt(string, n + 1))) {
                            n3 = n3 * 8 + (NewHdfParser.charAt(string, ++n) - 48);
                        }
                    }
                    n2 = (char)n3;
                } else {
                    n2 = c == 'n' ? 10 : (c == 't' ? 9 : (c == 'r' ? 13 : (int)c));
                }
            }
            stringBuilder.append((char)n2);
            ++n;
        }
        return n;
    }

    private String parseAttributeValue(String string, int n, ParseState parseState) throws OutOfCharsException {
        int n2 = n;
        char c = NewHdfParser.charAt(string, n2);
        while (c != ',' && c != ']' && c != '\"' && !Character.isWhitespace(c)) {
            c = NewHdfParser.charAt(string, ++n2);
        }
        return string.substring(n, n2);
    }

    private String parseMultilineValue(ParseState parseState, String string) throws IOException {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(256);
        while ((string2 = parseState.lineReader.readLine()) != null) {
            if (string2.startsWith(string) && NewHdfParser.skipLeadingWhitespace(string2, string.length()) == string2.length()) {
                return stringBuilder.toString();
            }
            stringBuilder.append(string2).append('\n');
        }
        NewHdfParser.reportError(parseState, "EOM " + string + " never found");
        return null;
    }

    private void handleDescend(ParseState parseState, HdfNameAttrs hdfNameAttrs) {
        Data data = this.handleNodeCreation(parseState.currentNode, hdfNameAttrs);
        parseState.context.push(parseState.currentNode);
        parseState.currentNode = data;
    }

    private Data handleNodeCreation(Data data, HdfNameAttrs hdfNameAttrs) {
        return hdfNameAttrs.toData(data);
    }

    private void handleAssign(ParseState parseState, HdfNameAttrs hdfNameAttrs, String string) {
        Data data = this.handleNodeCreation(parseState.currentNode, hdfNameAttrs);
        data.setValue(string);
    }

    private void handleCopy(ParseState parseState, HdfNameAttrs hdfNameAttrs, String string) {
        Data data = this.handleNodeCreation(parseState.currentNode, hdfNameAttrs);
        Data data2 = parseState.output.getChild(string);
        if (data2 != null) {
            data.setValue(data2.getValue());
        } else {
            data.setValue("");
        }
    }

    private void handleLink(ParseState parseState, HdfNameAttrs hdfNameAttrs, String string) {
        Data data = this.handleNodeCreation(parseState.currentNode, hdfNameAttrs);
        data.setSymlink(parseState.output.createChild(string));
    }

    private void handleAscend(ParseState parseState) {
        if (parseState.context.isEmpty()) {
            NewHdfParser.reportError(parseState, "Too many '}'");
            return;
        }
        parseState.currentNode = parseState.context.pop();
    }

    private void handleInclude(String string, ParseState parseState) throws IOException {
        String string2 = this.internStrategy.intern(string);
        Reader reader = parseState.resourceLoader.open(string2);
        if (reader == null) {
            NewHdfParser.reportError(parseState, "Unable to find file " + string2);
            return;
        }
        if (!parseState.includeStack.push(string2)) {
            NewHdfParser.reportError(parseState, this.createIncludeStackTraceMessage(parseState.includeStack, string2));
            return;
        }
        parseState.hdfParser.parse(ParseState.createParseStateForIncludedFile(parseState, string2, reader));
        if (!string2.equals(parseState.includeStack.pop())) {
            throw new IllegalStateException("Unable to find on include stack: " + string2);
        }
    }

    private String createIncludeStackTraceMessage(UniqueStack<String> uniqueStack, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("File included twice: ");
        stringBuilder.append(string);
        stringBuilder.append(" Include stack: ");
        for (String string2 : uniqueStack) {
            stringBuilder.append(string2);
            stringBuilder.append(" -> ");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static boolean isNumericChar(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isAlphaNumericChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    private static boolean isHdfNameChar(char c) {
        return NewHdfParser.isAlphaNumericChar(c) || c == '_' || c == '.';
    }

    private static String stripWhitespace(String string) {
        int n;
        int n2 = NewHdfParser.skipLeadingWhitespace(string, 0);
        for (n = string.length() - 1; n > n2 && Character.isWhitespace(string.charAt(n)); --n) {
        }
        if (n2 == 0 && n == string.length() - 1) {
            return string;
        }
        return string.substring(n2, n + 1);
    }

    private static int skipLeadingWhitespace(String string, int n) {
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private static boolean matches(String string, int n, String string2) {
        if (string.length() - n < string2.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == string.charAt(n + i)) continue;
            return false;
        }
        return true;
    }

    private static char charAt(String string, int n) throws OutOfCharsException {
        if (0 <= n && n < string.length()) {
            return string.charAt(n);
        }
        throw new OutOfCharsException();
    }

    private static void reportError(ParseState parseState, String string) {
        if (parseState.errorHandler == null) {
            throw new RuntimeException("Parse Error on line " + parseState.lineReader.getLineNumber() + ": " + string + " : " + parseState.line);
        }
        parseState.errorHandler.error(parseState.lineReader.getLineNumber(), parseState.line, parseState.parsedFileName, string);
    }

    private static class NewHdfParserFactory
    implements ParserFactory {
        private final StringInternStrategy stringInternStrategy;

        public NewHdfParserFactory(StringInternStrategy stringInternStrategy) {
            this.stringInternStrategy = stringInternStrategy;
        }

        public Parser newInstance() {
            return new NewHdfParser(this.stringInternStrategy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParseState {
        final Stack<Data> context = new Stack();
        final Data output;
        final LineNumberReader lineReader;
        final Parser.ErrorHandler errorHandler;
        final ResourceLoader resourceLoader;
        final NewHdfParser hdfParser;
        final boolean ignoreAttributes;
        final HdfNameAttrs hdfNameAttrs;
        final UniqueStack<String> includeStack;
        final String parsedFileName;
        String line;
        Data currentNode;

        private ParseState(Data data, LineNumberReader lineNumberReader, Parser.ErrorHandler errorHandler, ResourceLoader resourceLoader, NewHdfParser newHdfParser, String string, boolean bl, HdfNameAttrs hdfNameAttrs, UniqueStack<String> uniqueStack) {
            this.lineReader = lineNumberReader;
            this.errorHandler = errorHandler;
            this.output = data;
            this.currentNode = data;
            this.resourceLoader = resourceLoader;
            this.hdfParser = newHdfParser;
            this.parsedFileName = string;
            this.ignoreAttributes = bl;
            this.hdfNameAttrs = hdfNameAttrs;
            this.includeStack = uniqueStack;
        }

        public static ParseState createNewParseState(Data data, Reader reader, Parser.ErrorHandler errorHandler, ResourceLoader resourceLoader, NewHdfParser newHdfParser, String string, boolean bl) {
            if (string == null) {
                string = NewHdfParser.UNNAMED_INPUT;
            }
            UniqueStack<String> uniqueStack = new UniqueStack<String>();
            uniqueStack.push(string);
            return new ParseState(data, new LineNumberReader(reader), errorHandler, resourceLoader, newHdfParser, string, bl, new HdfNameAttrs(), uniqueStack);
        }

        public static ParseState createParseStateForIncludedFile(ParseState parseState, String string, Reader reader) {
            return new ParseState(parseState.output, new LineNumberReader(reader), parseState.errorHandler, parseState.resourceLoader, parseState.hdfParser, parseState.parsedFileName, parseState.ignoreAttributes, new HdfNameAttrs(), parseState.includeStack);
        }
    }

    private static class HdfNameAttrs {
        String name;
        ArrayList<String> attrs = null;
        int endOfSequence;

        private HdfNameAttrs() {
        }

        void reset(String string) {
            this.name = string;
            if (this.attrs != null) {
                this.attrs.clear();
            }
            this.endOfSequence = 0;
        }

        void addAttribute(String string, String string2) {
            if (this.attrs == null) {
                this.attrs = new ArrayList(10);
            }
            this.attrs.ensureCapacity(this.attrs.size() + 2);
            this.attrs.add(string);
            this.attrs.add(string2);
        }

        Data toData(Data data) {
            Data data2 = data.createChild(this.name);
            if (this.attrs != null) {
                Iterator<String> iterator = this.attrs.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    String string2 = iterator.next();
                    data2.setAttribute(string, string2);
                }
            }
            return data2;
        }
    }

    private static class OutOfCharsException
    extends Exception {
        private OutOfCharsException() {
        }
    }
}

