/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverInterpreterException;
import com.google.clearsilver.jsilver.functions.Function;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.functions.TextFilter;
import com.google.clearsilver.jsilver.values.Value;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FunctionRegistry
implements FunctionExecutor {
    protected Map<String, Function> functions = new HashMap<String, Function>();
    protected Map<String, TextFilter> escapers = new HashMap<String, TextFilter>();

    public FunctionRegistry() {
        this.setupDefaultFunctions();
    }

    public Value executeFunction(String string, Value ... valueArray) {
        Function function = this.functions.get(string);
        if (function == null) {
            throw new JSilverInterpreterException("Function not found " + string);
        }
        Value value = function.execute(valueArray);
        if (value == null) {
            throw new JSilverInterpreterException("Function " + string + " did not return value");
        }
        return value;
    }

    public void escape(String string, String string2, Appendable appendable) throws IOException {
        if (string == null || string.isEmpty() || string.equals("none")) {
            appendable.append(string2);
        } else {
            TextFilter textFilter = this.escapers.get(string);
            if (textFilter == null) {
                throw new JSilverInterpreterException("Unknown escaper: " + string);
            }
            textFilter.filter(string2, appendable);
        }
    }

    public boolean isEscapingFunction(String string) {
        Function function = this.functions.get(string);
        if (function == null) {
            throw new JSilverInterpreterException("Function not found " + string);
        }
        return function.isEscapingFunction();
    }

    protected void setupDefaultFunctions() {
    }

    public void registerFunction(String string, Function function) {
        this.functions.put(string, function);
    }

    public void registerFunction(String string, TextFilter textFilter) {
        this.registerFunction(string, textFilter, false);
    }

    public void registerFunction(String string, final TextFilter textFilter, final boolean bl) {
        this.registerFunction(string, new Function(){

            public Value execute(Value ... valueArray) {
                boolean bl2;
                EscapeMode escapeMode;
                if (valueArray.length != 1) {
                    throw new IllegalArgumentException("Expected 1 argument");
                }
                String string = valueArray[0].asString();
                StringBuilder stringBuilder = new StringBuilder(string.length());
                try {
                    textFilter.filter(string, stringBuilder);
                }
                catch (IOException iOException) {
                    throw new JSilverInterpreterException(iOException.getMessage());
                }
                if (bl) {
                    escapeMode = EscapeMode.ESCAPE_IS_CONSTANT;
                    bl2 = true;
                } else {
                    escapeMode = EscapeMode.ESCAPE_NONE;
                    bl2 = false;
                    for (Value value : valueArray) {
                        if (!value.isPartiallyEscaped()) continue;
                        bl2 = true;
                        break;
                    }
                }
                return Value.literalValue(stringBuilder.toString(), escapeMode, bl2);
            }

            public boolean isEscapingFunction() {
                return bl;
            }
        });
    }

    public void registerEscapeMode(String string, TextFilter textFilter) {
        this.escapers.put(string, textFilter);
    }
}

