/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.escape;

import com.google.clearsilver.jsilver.functions.TextFilter;
import java.io.IOException;

public abstract class SimpleEscapingFunction
implements TextFilter {
    private static final int CHAR_INDEX_LIMIT = 256;
    private String[] ESCAPE_STRINGS;

    protected SimpleEscapingFunction(char[] cArray) {
        this.setEscapeChars(cArray);
    }

    protected SimpleEscapingFunction() {
        this.ESCAPE_STRINGS = new String[0];
    }

    protected void setEscapeChars(char[] cArray) throws AssertionError {
        char c;
        int c2 = -1;
        for (char c3 : cArray) {
            if (c3 <= c) continue;
            c = c3;
        }
        if (c >= '\u0100') {
            throw new AssertionError((Object)"Cannot escape characters with values above 256");
        }
        this.ESCAPE_STRINGS = new String[c + true];
        for (char c3 : cArray) {
            this.ESCAPE_STRINGS[c3] = this.getEscapeString(c3);
        }
    }

    protected abstract String getEscapeString(char var1);

    public void filter(String string, Appendable appendable) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = n = 0;
        while (n < n2) {
            String string2;
            char c = string.charAt(n);
            if (c < this.ESCAPE_STRINGS.length && (string2 = this.ESCAPE_STRINGS[c]) != null) {
                if (n > n3) {
                    appendable.append(string, n3, n);
                }
                appendable.append(string2);
                n3 = ++n;
                continue;
            }
            ++n;
        }
        if (n > n3) {
            appendable.append(string, n3, n);
        }
    }
}

