/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.escape;

import com.google.clearsilver.jsilver.functions.TextFilter;
import java.io.IOException;

public class StyleEscapeFunction
implements TextFilter {
    private static final boolean[] UNQUOTED_VALID_CHARS;
    private static final boolean[] VALID_CHARS;
    private static final int MAX_CHARS = 128;
    private final boolean[] validChars;

    public StyleEscapeFunction(boolean bl) {
        this.validChars = bl ? UNQUOTED_VALID_CHARS : VALID_CHARS;
    }

    public void filter(String string, Appendable appendable) throws IOException {
        for (char c : string.toCharArray()) {
            if (c < '\u0080' && this.validChars[c]) {
                appendable.append(c);
                continue;
            }
            if (c < '\u0080') continue;
            appendable.append(c);
        }
    }

    public void dumpInfo() {
        for (int i = 0; i < 128; ++i) {
            System.out.println(i + "(" + (char)i + ")" + " :" + VALID_CHARS[i]);
        }
    }

    static {
        String string = "_.,!#%- ";
        String string2 = "_.,!#%-";
        VALID_CHARS = new boolean[128];
        UNQUOTED_VALID_CHARS = new boolean[128];
        for (int i = 0; i < 128; ++i) {
            StyleEscapeFunction.VALID_CHARS[i] = false;
            StyleEscapeFunction.UNQUOTED_VALID_CHARS[i] = false;
            if (Character.isLetterOrDigit(i)) {
                StyleEscapeFunction.VALID_CHARS[i] = true;
                StyleEscapeFunction.UNQUOTED_VALID_CHARS[i] = true;
                continue;
            }
            if (string.indexOf(i) != -1) {
                StyleEscapeFunction.VALID_CHARS[i] = true;
            }
            if (string2.indexOf(i) == -1) continue;
            StyleEscapeFunction.UNQUOTED_VALID_CHARS[i] = true;
        }
    }
}

