/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.html;

import com.google.clearsilver.jsilver.functions.TextFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HtmlStripFunction
implements TextFilter {
    private static final int MAX_AMP_LENGTH = 9;
    private static final Map<String, String> entityValues;

    public void filter(String string, Appendable appendable) throws IOException {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        State state = State.DEFAULT;
        block9: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (state) {
                case DEFAULT: {
                    switch (c) {
                        case '&': {
                            state = State.IN_AMP;
                            continue block9;
                        }
                        case '<': {
                            state = State.IN_TAG;
                            continue block9;
                        }
                    }
                    appendable.append(c);
                    continue block9;
                }
                case IN_TAG: {
                    if (c != '>') continue block9;
                    state = State.DEFAULT;
                    continue block9;
                }
                case IN_AMP: {
                    if (c == ';') {
                        state = State.DEFAULT;
                        this.appendDecodedEntityReference(appendable, stringBuilder);
                        stringBuilder = new StringBuilder();
                        continue block9;
                    }
                    if (stringBuilder.length() < 9) {
                        if (i != cArray.length - 1) {
                            stringBuilder.append(c);
                            continue block9;
                        }
                        appendable.append('&').append(stringBuilder).append(c);
                        continue block9;
                    }
                    appendable.append('&').append(stringBuilder).append(c);
                    stringBuilder = new StringBuilder();
                    state = State.DEFAULT;
                }
            }
        }
    }

    private void appendDecodedEntityReference(Appendable appendable, CharSequence charSequence) throws IOException {
        if (charSequence.length() < 2) {
            return;
        }
        if ((charSequence = ((Object)charSequence).toString().toLowerCase()).charAt(0) == '#') {
            this.appendNumberedEntity(appendable, charSequence.subSequence(1, charSequence.length()));
            return;
        }
        String string = entityValues.get(charSequence);
        if (string != null) {
            appendable.append(string);
        }
    }

    private void appendNumberedEntity(Appendable appendable, CharSequence charSequence) throws IOException {
        if (charSequence.length() != 0) {
            try {
                char c = charSequence.charAt(0) == 'x' ? (char)Integer.parseInt(((Object)charSequence.subSequence(1, charSequence.length())).toString(), 16) : (char)Integer.parseInt(((Object)charSequence).toString(), 10);
                if (c != '\u0000') {
                    appendable.append(c);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("amp", "&");
        hashMap.put("quot", "\"");
        hashMap.put("gt", ">");
        hashMap.put("lt", "<");
        hashMap.put("agrave", "\u00e0");
        hashMap.put("aacute", "\u00e1");
        hashMap.put("acirc", "\u00e2");
        hashMap.put("atilde", "\u00e3");
        hashMap.put("auml", "\u00e4");
        hashMap.put("aring", "\u00e5");
        hashMap.put("aelig", "\u00e6");
        hashMap.put("ccedil", "\u00e7");
        hashMap.put("egrave", "\u00e8");
        hashMap.put("eacute", "\u00e9");
        hashMap.put("ecirc", "\u00ea");
        hashMap.put("euml", "\u00eb");
        hashMap.put("eth", "\u00f0");
        hashMap.put("igrave", "\u00ec");
        hashMap.put("iacute", "\u00ed");
        hashMap.put("icirc", "\u00ee");
        hashMap.put("iuml", "\u00ef");
        hashMap.put("ntilde", "\u00f1");
        hashMap.put("nbsp", " ");
        hashMap.put("ograve", "\u00f2");
        hashMap.put("oacute", "\u00f3");
        hashMap.put("ocirc", "\u00f4");
        hashMap.put("otilde", "\u00f5");
        hashMap.put("ouml", "\u00f6");
        hashMap.put("oslash", "\u00f8");
        hashMap.put("szlig", "\u00df");
        hashMap.put("thorn", "\u00fe");
        hashMap.put("ugrave", "\u00f9");
        hashMap.put("uacute", "\u00fa");
        hashMap.put("ucirc", "\u00fb");
        hashMap.put("uuml", "\u00fc");
        hashMap.put("yacute", "\u00fd");
        hashMap.put("copy", "(C)");
        entityValues = Collections.unmodifiableMap(hashMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        DEFAULT,
        IN_AMP,
        IN_TAG;

    }
}

