/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.interpreter.VariableLocator;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAddExpression;
import com.google.clearsilver.jsilver.syntax.node.AAndExpression;
import com.google.clearsilver.jsilver.syntax.node.ADecimalExpression;
import com.google.clearsilver.jsilver.syntax.node.ADescendVariable;
import com.google.clearsilver.jsilver.syntax.node.ADivideExpression;
import com.google.clearsilver.jsilver.syntax.node.AEqExpression;
import com.google.clearsilver.jsilver.syntax.node.AExistsExpression;
import com.google.clearsilver.jsilver.syntax.node.AFunctionExpression;
import com.google.clearsilver.jsilver.syntax.node.AGtExpression;
import com.google.clearsilver.jsilver.syntax.node.AGteExpression;
import com.google.clearsilver.jsilver.syntax.node.AHexExpression;
import com.google.clearsilver.jsilver.syntax.node.ALtExpression;
import com.google.clearsilver.jsilver.syntax.node.ALteExpression;
import com.google.clearsilver.jsilver.syntax.node.AModuloExpression;
import com.google.clearsilver.jsilver.syntax.node.AMultiplyExpression;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.ANeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANegativeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANotExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericAddExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericEqExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericNeExpression;
import com.google.clearsilver.jsilver.syntax.node.AOrExpression;
import com.google.clearsilver.jsilver.syntax.node.AStringExpression;
import com.google.clearsilver.jsilver.syntax.node.ASubtractExpression;
import com.google.clearsilver.jsilver.syntax.node.AVariableExpression;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import com.google.clearsilver.jsilver.values.Value;
import java.util.LinkedList;

public class ExpressionEvaluator
extends DepthFirstAdapter {
    private Value currentValue;
    private final DataContext context;
    private final FunctionExecutor functionExecutor;

    public ExpressionEvaluator(DataContext dataContext, FunctionExecutor functionExecutor) {
        this.context = dataContext;
        this.functionExecutor = functionExecutor;
    }

    public Value evaluate(PExpression pExpression) {
        assert (this.currentValue == null);
        pExpression.apply(this);
        Value value = this.currentValue;
        this.currentValue = null;
        assert (value != null) : "No result set from " + pExpression.getClass();
        return value;
    }

    public void caseAVariableExpression(AVariableExpression aVariableExpression) {
        VariableLocator variableLocator = new VariableLocator(this);
        String string = variableLocator.getVariableName(aVariableExpression.getVariable());
        this.setResult(Value.variableValue(string, this.context));
    }

    public void caseAStringExpression(AStringExpression aStringExpression) {
        String string = aStringExpression.getValue().getText();
        string = string.substring(1, string.length() - 1);
        Value value = Value.literalValue(string, EscapeMode.ESCAPE_IS_CONSTANT, false);
        this.setResult(value);
    }

    public void caseADecimalExpression(ADecimalExpression aDecimalExpression) {
        String string = aDecimalExpression.getValue().getText();
        this.setResult(Value.literalValue(Integer.parseInt(string), EscapeMode.ESCAPE_IS_CONSTANT, false));
    }

    public void caseAHexExpression(AHexExpression aHexExpression) {
        String string = aHexExpression.getValue().getText();
        string = string.substring(2);
        this.setResult(Value.literalValue(Integer.parseInt(string, 16), EscapeMode.ESCAPE_IS_CONSTANT, false));
    }

    public void caseANumericExpression(ANumericExpression aNumericExpression) {
        this.executeFunction("#", aNumericExpression.getExpression());
    }

    public void caseANotExpression(ANotExpression aNotExpression) {
        this.executeFunction("!", aNotExpression.getExpression());
    }

    public void caseAExistsExpression(AExistsExpression aExistsExpression) {
        this.executeFunction("?", aExistsExpression.getExpression());
    }

    public void caseAEqExpression(AEqExpression aEqExpression) {
        this.executeFunction("==", aEqExpression.getLeft(), aEqExpression.getRight());
    }

    public void caseANumericEqExpression(ANumericEqExpression aNumericEqExpression) {
        this.executeFunction("#==", aNumericEqExpression.getLeft(), aNumericEqExpression.getRight());
    }

    public void caseANeExpression(ANeExpression aNeExpression) {
        this.executeFunction("!=", aNeExpression.getLeft(), aNeExpression.getRight());
    }

    public void caseANumericNeExpression(ANumericNeExpression aNumericNeExpression) {
        this.executeFunction("#!=", aNumericNeExpression.getLeft(), aNumericNeExpression.getRight());
    }

    public void caseALtExpression(ALtExpression aLtExpression) {
        this.executeFunction("<", aLtExpression.getLeft(), aLtExpression.getRight());
    }

    public void caseAGtExpression(AGtExpression aGtExpression) {
        this.executeFunction(">", aGtExpression.getLeft(), aGtExpression.getRight());
    }

    public void caseALteExpression(ALteExpression aLteExpression) {
        this.executeFunction("<=", aLteExpression.getLeft(), aLteExpression.getRight());
    }

    public void caseAGteExpression(AGteExpression aGteExpression) {
        this.executeFunction(">=", aGteExpression.getLeft(), aGteExpression.getRight());
    }

    public void caseAAndExpression(AAndExpression aAndExpression) {
        this.executeFunction("&&", aAndExpression.getLeft(), aAndExpression.getRight());
    }

    public void caseAOrExpression(AOrExpression aOrExpression) {
        this.executeFunction("||", aOrExpression.getLeft(), aOrExpression.getRight());
    }

    public void caseAAddExpression(AAddExpression aAddExpression) {
        this.executeFunction("+", aAddExpression.getLeft(), aAddExpression.getRight());
    }

    public void caseANumericAddExpression(ANumericAddExpression aNumericAddExpression) {
        this.executeFunction("#+", aNumericAddExpression.getLeft(), aNumericAddExpression.getRight());
    }

    public void caseASubtractExpression(ASubtractExpression aSubtractExpression) {
        this.executeFunction("-", aSubtractExpression.getLeft(), aSubtractExpression.getRight());
    }

    public void caseAMultiplyExpression(AMultiplyExpression aMultiplyExpression) {
        this.executeFunction("*", aMultiplyExpression.getLeft(), aMultiplyExpression.getRight());
    }

    public void caseADivideExpression(ADivideExpression aDivideExpression) {
        this.executeFunction("/", aDivideExpression.getLeft(), aDivideExpression.getRight());
    }

    public void caseAModuloExpression(AModuloExpression aModuloExpression) {
        this.executeFunction("%", aModuloExpression.getLeft(), aModuloExpression.getRight());
    }

    public void caseANegativeExpression(ANegativeExpression aNegativeExpression) {
        this.executeFunction("-", aNegativeExpression.getExpression());
    }

    public void caseAFunctionExpression(AFunctionExpression aFunctionExpression) {
        LinkedList<PExpression> linkedList = aFunctionExpression.getArgs();
        PExpression[] pExpressionArray = linkedList.toArray(new PExpression[linkedList.size()]);
        this.executeFunction(this.getFullFunctionName(aFunctionExpression), pExpressionArray);
    }

    private void executeFunction(String string, PExpression ... pExpressionArray) {
        Value[] valueArray = new Value[pExpressionArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = this.evaluate(pExpressionArray[i]);
        }
        this.setResult(this.functionExecutor.executeFunction(string, valueArray));
    }

    private void setResult(Value value) {
        assert (value != null);
        this.currentValue = value;
    }

    private String getFullFunctionName(AFunctionExpression aFunctionExpression) {
        final StringBuilder stringBuilder = new StringBuilder();
        aFunctionExpression.getName().apply(new DepthFirstAdapter(){

            public void caseANameVariable(ANameVariable aNameVariable) {
                stringBuilder.append(aNameVariable.getWord().getText());
            }

            public void caseADescendVariable(ADescendVariable aDescendVariable) {
                aDescendVariable.getParent().apply(this);
                stringBuilder.append('.');
                aDescendVariable.getChild().apply(this);
            }
        });
        return stringBuilder.toString();
    }
}

