/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.exceptions.JSilverInterpreterException;
import com.google.clearsilver.jsilver.interpreter.TemplateInterpreter;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.template.Macro;
import com.google.clearsilver.jsilver.template.RenderingContext;
import com.google.clearsilver.jsilver.template.Template;
import java.io.IOException;

public class InterpretedMacro
implements Macro {
    private final PCommand command;
    private final Template owningTemplate;
    private final String macroName;
    private final String[] argumentNames;
    private final TemplateInterpreter templateInterpreter;
    private final RenderingContext owningContext;

    public InterpretedMacro(PCommand pCommand, Template template, String string, String[] stringArray, TemplateInterpreter templateInterpreter, RenderingContext renderingContext) {
        this.command = pCommand;
        this.owningTemplate = template;
        this.macroName = string;
        this.argumentNames = stringArray;
        this.templateInterpreter = templateInterpreter;
        this.owningContext = renderingContext;
    }

    public void render(RenderingContext renderingContext) throws IOException {
        boolean bl;
        assert (renderingContext == this.owningContext) : "Cannot render macro defined in another context";
        renderingContext.pushExecutionContext(this);
        boolean bl2 = bl = !renderingContext.isRuntimeAutoEscaping();
        if (bl) {
            renderingContext.startRuntimeAutoEscaping();
        }
        this.command.apply(this.templateInterpreter);
        if (bl) {
            renderingContext.stopRuntimeAutoEscaping();
        }
        renderingContext.popExecutionContext();
    }

    public void render(Data data, Appendable appendable, ResourceLoader resourceLoader) throws IOException {
        this.render(this.createRenderingContext(data, appendable, resourceLoader));
    }

    public RenderingContext createRenderingContext(Data data, Appendable appendable, ResourceLoader resourceLoader) {
        return this.owningTemplate.createRenderingContext(data, appendable, resourceLoader);
    }

    public String getTemplateName() {
        return this.owningTemplate.getTemplateName();
    }

    public EscapeMode getEscapeMode() {
        return this.owningTemplate.getEscapeMode();
    }

    public String getDisplayName() {
        return this.owningTemplate.getDisplayName() + ":" + this.macroName;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public String getArgumentName(int n) {
        if (n >= this.argumentNames.length) {
            throw new JSilverInterpreterException("Too many arguments supplied to macro " + this.macroName);
        }
        return this.argumentNames[n];
    }

    public int getArgumentCount() {
        return this.argumentNames.length;
    }
}

