/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.output;

import com.google.clearsilver.jsilver.output.OutputBufferProvider;

public class ThreadLocalOutputBufferProvider
implements OutputBufferProvider {
    private final ThreadLocal<StringBuilder> pool;
    private final ThreadLocal<Boolean> available;

    public ThreadLocalOutputBufferProvider(final int n) {
        this.pool = new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder(n);
            }
        };
        this.available = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return true;
            }
        };
    }

    public Appendable get() {
        if (!this.available.get().booleanValue()) {
            throw new IllegalStateException("Thread buffer is not free.");
        }
        StringBuilder stringBuilder = this.pool.get();
        this.available.set(false);
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    public void release(Appendable appendable) {
        if (appendable != this.pool.get()) {
            throw new IllegalArgumentException("Can't release buffer that does not correspond to this thread.");
        }
        this.available.set(true);
    }
}

