/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.precompiler;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverAutoEscapingException;
import com.google.clearsilver.jsilver.precompiler.PrecompiledTemplateMapKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecompiledTemplateMapFileReader {
    private final String mapFileName;
    private final String dirPattern;
    private final String rootDir;
    private Map<Object, String> templateMap = null;

    public PrecompiledTemplateMapFileReader(String string, String string2, String string3) {
        this.mapFileName = string;
        this.dirPattern = string2;
        this.rootDir = string3;
    }

    public Map<Object, String> getTemplateMap() throws IOException {
        if (this.templateMap == null) {
            this.templateMap = this.makeTemplateMap(this.mapFileName, this.rootDir);
        }
        return this.templateMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, String> makeTemplateMap(String string, String string2) throws IOException {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new LineNumberReader(this.getMapFileReader(string));
            String string3 = ((LineNumberReader)bufferedReader).readLine();
            while (string3 != null) {
                this.processTemplateMapFileLine(string3, ((LineNumberReader)bufferedReader).getLineNumber(), hashMap, string, string2);
                string3 = ((LineNumberReader)bufferedReader).readLine();
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return ImmutableMap.copyOf(hashMap);
    }

    private void processTemplateMapFileLine(String string, int n, Map<Object, String> map, String string2, String string3) {
        Object object;
        EscapeMode escapeMode;
        if ((string = string.trim()).isEmpty() || string.startsWith("#")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("No template file name found in " + string2 + " on line " + n + ": " + string);
        }
        String string4 = stringTokenizer.nextToken();
        if (this.dirPattern != null && string4.startsWith(this.dirPattern)) {
            string4 = string4.substring(this.dirPattern.length());
        }
        if (string3 != null) {
            string4 = string3 + string4;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("No class name found in " + string2 + " on line " + n + ": " + string);
        }
        String string5 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            escapeMode = EscapeMode.ESCAPE_NONE;
        } else {
            object = stringTokenizer.nextToken();
            try {
                escapeMode = EscapeMode.computeEscapeMode((String)object);
            }
            catch (JSilverAutoEscapingException jSilverAutoEscapingException) {
                throw new IllegalArgumentException("Invalid escape mode found in " + string2 + " on line " + n + ": " + (String)object);
            }
        }
        object = new PrecompiledTemplateMapKey(string4, escapeMode);
        map.put(object, string5);
    }

    @VisibleForTesting
    protected Reader getMapFileReader(String string) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException("Unable to locate resource: " + string);
        }
        return new InputStreamReader(inputStream, "UTF-8");
    }
}

