/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.exceptions.JSilverBadSyntaxException;
import com.google.clearsilver.jsilver.syntax.analysis.AnalysisAdapter;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.AInlineCommand;
import com.google.clearsilver.jsilver.syntax.node.ANoopCommand;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.syntax.node.TData;

public class InlineRewriter
extends DepthFirstAdapter {
    private static AnalysisAdapter WHITESPACE_STRIPPER = new DepthFirstAdapter(){

        public void caseADataCommand(ADataCommand aDataCommand) {
            TData tData = aDataCommand.getData();
            if (InlineRewriter.isAllWhitespace(tData.getText())) {
                aDataCommand.replaceBy(new ANoopCommand());
                return;
            }
            throw new JSilverBadSyntaxException("literal text in an inline block may only contain whitespace", tData.getText(), null, tData.getLine(), tData.getPos(), null);
        }

        public void caseAInlineCommand(AInlineCommand aInlineCommand) {
            PCommand pCommand = aInlineCommand.getCommand();
            aInlineCommand.replaceBy(pCommand);
            pCommand.apply(this);
        }
    };

    private static boolean isAllWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void caseAInlineCommand(AInlineCommand aInlineCommand) {
        aInlineCommand.getCommand().apply(WHITESPACE_STRIPPER);
        aInlineCommand.replaceBy(aInlineCommand.getCommand());
    }
}

