/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.template;

import java.io.IOException;

public class HtmlWhiteSpaceStripper
implements Appendable {
    private final Appendable out;
    private final int level;
    private boolean nonWsSeen = false;
    private char pendingWs = '\u0000';
    private boolean startHtmlTag = false;
    private boolean inOpenTag = false;
    private boolean inCloseTag = false;
    private boolean inTagName = false;
    private int textAreaScope = 0;
    private int preScope = 0;
    private int verbatimScope = 0;
    private int scriptScope = 0;
    private StringBuilder tagName = new StringBuilder(16);

    public HtmlWhiteSpaceStripper(Appendable appendable) {
        this(appendable, 1);
    }

    public HtmlWhiteSpaceStripper(Appendable appendable, int n) {
        this.out = appendable;
        this.level = n;
    }

    public String toString() {
        return this.out.toString();
    }

    public Appendable append(CharSequence charSequence) throws IOException {
        return this.append(charSequence, 0, charSequence.length());
    }

    public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
        for (int i = n; i < n2; ++i) {
            this.append(charSequence.charAt(i));
        }
        return this;
    }

    public Appendable append(char c) throws IOException {
        if (this.inOpenTag || this.inCloseTag) {
            if (this.startHtmlTag) {
                if (c == '/') {
                    this.inOpenTag = false;
                    this.inCloseTag = true;
                } else {
                    this.startHtmlTag = false;
                    if (this.isTagNameStartChar(c)) {
                        this.inTagName = true;
                        this.tagName.append(c);
                    }
                }
            } else if (this.inTagName) {
                if (this.isTagNameChar(c)) {
                    this.tagName.append(c);
                } else {
                    this.processTagName();
                    this.inTagName = false;
                }
            }
            if (c == '>') {
                this.inCloseTag = false;
                this.inOpenTag = false;
                this.nonWsSeen = true;
            }
            this.stripLeadingWsAndEmptyLines(c);
        } else {
            if (c == '<') {
                this.inOpenTag = true;
                this.startHtmlTag = true;
            }
            if (this.preScope > 0 || this.verbatimScope > 0 || this.textAreaScope > 0) {
                this.out.append(c);
            } else if (this.scriptScope > 0) {
                this.stripLeadingWsAndEmptyLines(c);
            } else {
                this.stripAll(c);
            }
        }
        return this;
    }

    private void stripLeadingWsAndEmptyLines(char c) throws IOException {
        switch (c) {
            case '\n': {
                if (this.nonWsSeen) {
                    this.out.append(c);
                }
                this.nonWsSeen = false;
                break;
            }
            case '\t': 
            case '\r': 
            case ' ': {
                if (!this.nonWsSeen) break;
                this.out.append(c);
                break;
            }
            default: {
                if (!this.nonWsSeen) {
                    this.nonWsSeen = true;
                }
                this.out.append(c);
            }
        }
    }

    private void stripAll(char c) throws IOException {
        switch (c) {
            case '\n': {
                if (this.nonWsSeen) {
                    this.out.append(c);
                }
                this.pendingWs = '\u0000';
                this.nonWsSeen = false;
                break;
            }
            case '\t': 
            case '\r': 
            case ' ': {
                if (!this.nonWsSeen) break;
                this.pendingWs = c;
                break;
            }
            default: {
                if (this.pendingWs != '\u0000') {
                    this.out.append(this.pendingWs);
                    this.pendingWs = '\u0000';
                }
                this.nonWsSeen = true;
                this.out.append(c);
            }
        }
    }

    private int updateScope(int n, int n2) {
        return (n += n2) < 0 ? 0 : n;
    }

    private void processTagName() {
        int n;
        this.inTagName = false;
        String string = this.tagName.toString();
        this.tagName.delete(0, this.tagName.length());
        int n2 = n = this.inOpenTag ? 1 : -1;
        if ("textarea".equalsIgnoreCase(string)) {
            this.textAreaScope = this.updateScope(this.textAreaScope, n);
        } else if ("pre".equalsIgnoreCase(string)) {
            this.preScope = this.updateScope(this.preScope, n);
        } else if ("verbatim".equalsIgnoreCase(string)) {
            this.verbatimScope = this.updateScope(this.verbatimScope, n);
        } else if ("script".equalsIgnoreCase(string)) {
            this.scriptScope = this.updateScope(this.scriptScope, n);
        }
    }

    private boolean isTagNameStartChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private boolean isTagNameChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '-' || c == ':' || c == '.';
    }

    private boolean isWs(char c) {
        return c == ' ' || c == '\t' || c == '\r';
    }
}

