/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.values;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.values.NumberValue;
import com.google.clearsilver.jsilver.values.StringValue;
import com.google.clearsilver.jsilver.values.VariableValue;
import java.util.HashMap;
import java.util.Map;

public abstract class Value {
    private static final Map<EscapeMode, Value> EMPTY_PART_ESCAPED = new HashMap<EscapeMode, Value>(2);
    private static final Map<EscapeMode, Value> EMPTY_UNESCAPED;
    private static final Map<EscapeMode, Value> ZERO_PART_ESCAPED;
    private static final Map<EscapeMode, Value> ZERO_UNESCAPED;
    private static final Map<EscapeMode, Value> ONE_PART_ESCAPED;
    private static final Map<EscapeMode, Value> ONE_UNESCAPED;
    private final boolean partiallyEscaped;
    private final EscapeMode escapeMode;

    public Value(EscapeMode escapeMode, boolean bl) {
        this.escapeMode = escapeMode;
        this.partiallyEscaped = bl;
    }

    public abstract boolean asBoolean();

    public abstract String asString();

    public abstract int asNumber();

    public abstract boolean exists();

    public abstract boolean isEmpty();

    public static Value literalValue(int n, EscapeMode escapeMode, boolean bl) {
        return Value.getIntValue(escapeMode, bl, n);
    }

    public static Value literalValue(String string, EscapeMode escapeMode, boolean bl) {
        Value value;
        if (string.isEmpty() && (value = (bl ? EMPTY_PART_ESCAPED : EMPTY_UNESCAPED).get((Object)escapeMode)) != null) {
            return value;
        }
        return new StringValue(string, escapeMode, bl);
    }

    public static Value literalValue(boolean bl, EscapeMode escapeMode, boolean bl2) {
        return Value.getIntValue(escapeMode, bl2, bl ? 1 : 0);
    }

    private static Value getIntValue(EscapeMode escapeMode, boolean bl, int n) {
        Value value = null;
        if (n == 0) {
            value = (bl ? ZERO_PART_ESCAPED : ZERO_UNESCAPED).get((Object)escapeMode);
        } else if (n == 1) {
            value = (bl ? ONE_PART_ESCAPED : ONE_UNESCAPED).get((Object)escapeMode);
        }
        if (value != null) {
            return value;
        }
        return new NumberValue(n, escapeMode, bl);
    }

    public static Value literalConstant(int n, Value ... valueArray) {
        boolean bl = false;
        for (Value value : valueArray) {
            if (!value.isPartiallyEscaped()) continue;
            bl = true;
            break;
        }
        return Value.literalValue(n, EscapeMode.ESCAPE_IS_CONSTANT, bl);
    }

    public static Value literalConstant(String string, Value ... valueArray) {
        boolean bl = false;
        for (Value value : valueArray) {
            if (!value.isPartiallyEscaped()) continue;
            bl = true;
            break;
        }
        return Value.literalValue(string, EscapeMode.ESCAPE_IS_CONSTANT, bl);
    }

    public static Value literalConstant(boolean bl, Value ... valueArray) {
        boolean bl2 = false;
        for (Value value : valueArray) {
            if (!value.isPartiallyEscaped()) continue;
            bl2 = true;
            break;
        }
        return Value.literalValue(bl, EscapeMode.ESCAPE_IS_CONSTANT, bl2);
    }

    public static Value variableValue(String string, DataContext dataContext) {
        return new VariableValue(string, dataContext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        return this.exists() == value.exists() && (this.asString().equals(value.asString()) || this.isEmpty() && value.isEmpty());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.asString();
    }

    public boolean isPartiallyEscaped() {
        return this.partiallyEscaped;
    }

    public EscapeMode getEscapeMode() {
        return this.escapeMode;
    }

    static {
        EMPTY_PART_ESCAPED.put(EscapeMode.ESCAPE_NONE, new StringValue("", EscapeMode.ESCAPE_NONE, true));
        EMPTY_PART_ESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new StringValue("", EscapeMode.ESCAPE_IS_CONSTANT, true));
        EMPTY_UNESCAPED = new HashMap<EscapeMode, Value>(2);
        EMPTY_UNESCAPED.put(EscapeMode.ESCAPE_NONE, new StringValue("", EscapeMode.ESCAPE_NONE, false));
        EMPTY_UNESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new StringValue("", EscapeMode.ESCAPE_IS_CONSTANT, false));
        ZERO_PART_ESCAPED = new HashMap<EscapeMode, Value>(2);
        ZERO_PART_ESCAPED.put(EscapeMode.ESCAPE_NONE, new NumberValue(0, EscapeMode.ESCAPE_NONE, true));
        ZERO_PART_ESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new NumberValue(0, EscapeMode.ESCAPE_IS_CONSTANT, true));
        ZERO_UNESCAPED = new HashMap<EscapeMode, Value>(2);
        ZERO_UNESCAPED.put(EscapeMode.ESCAPE_NONE, new NumberValue(0, EscapeMode.ESCAPE_NONE, false));
        ZERO_UNESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new NumberValue(0, EscapeMode.ESCAPE_IS_CONSTANT, false));
        ONE_PART_ESCAPED = new HashMap<EscapeMode, Value>(2);
        ONE_PART_ESCAPED.put(EscapeMode.ESCAPE_NONE, new NumberValue(1, EscapeMode.ESCAPE_NONE, true));
        ONE_PART_ESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new NumberValue(1, EscapeMode.ESCAPE_IS_CONSTANT, true));
        ONE_UNESCAPED = new HashMap<EscapeMode, Value>(2);
        ONE_UNESCAPED.put(EscapeMode.ESCAPE_NONE, new NumberValue(1, EscapeMode.ESCAPE_NONE, false));
        ONE_UNESCAPED.put(EscapeMode.ESCAPE_IS_CONSTANT, new NumberValue(1, EscapeMode.ESCAPE_IS_CONSTANT, false));
    }
}

