/*
 * Decompiled with CFR 0.152.
 */
package com.google.streamhtmlparser.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.streamhtmlparser.ExternalState;
import com.google.streamhtmlparser.HtmlParser;
import com.google.streamhtmlparser.ParseException;
import com.google.streamhtmlparser.impl.GenericParser;
import com.google.streamhtmlparser.impl.InternalState;
import com.google.streamhtmlparser.impl.JavascriptParserImpl;
import com.google.streamhtmlparser.impl.ParserStateTable;
import com.google.streamhtmlparser.impl.StateTableTransition;
import com.google.streamhtmlparser.util.CharacterRecorder;
import com.google.streamhtmlparser.util.EntityResolver;
import com.google.streamhtmlparser.util.HtmlUtils;
import java.util.Map;

public class HtmlParserImpl
extends GenericParser
implements HtmlParser {
    private static final InternalState TEXT = InternalState.getInstanceHtml("TEXT");
    private static final InternalState TAG_START = InternalState.getInstanceHtml("TAG_START");
    private static final InternalState TAG_NAME = InternalState.getInstanceHtml("TAG_NAME");
    private static final InternalState DECL_START = InternalState.getInstanceHtml("DECL_START");
    private static final InternalState DECL_BODY = InternalState.getInstanceHtml("DECL_BODY");
    private static final InternalState COM_OPEN = InternalState.getInstanceHtml("COM_OPEN");
    private static final InternalState COM_BODY = InternalState.getInstanceHtml("COM_BODY");
    private static final InternalState COM_DASH = InternalState.getInstanceHtml("COM_DASH");
    private static final InternalState COM_DASH_DASH = InternalState.getInstanceHtml("COM_DASH_DASH");
    private static final InternalState PI = InternalState.getInstanceHtml("PI");
    private static final InternalState PI_MAY_END = InternalState.getInstanceHtml("PI_MAY_END");
    private static final InternalState TAG_SPACE = InternalState.getInstanceHtml("TAG_SPACE");
    private static final InternalState TAG_CLOSE = InternalState.getInstanceHtml("TAG_CLOSE");
    private static final InternalState ATTR = InternalState.getInstanceHtml("ATTR");
    private static final InternalState ATTR_SPACE = InternalState.getInstanceHtml("ATTR_SPACE");
    private static final InternalState VALUE = InternalState.getInstanceHtml("VALUE");
    private static final InternalState VALUE_TEXT = InternalState.getInstanceHtml("VALUE_TEXT");
    private static final InternalState VALUE_Q_START = InternalState.getInstanceHtml("VALUE_Q_START");
    private static final InternalState VALUE_Q = InternalState.getInstanceHtml("VALUE_Q");
    private static final InternalState VALUE_DQ_START = InternalState.getInstanceHtml("VALUE_DQ_START");
    private static final InternalState VALUE_DQ = InternalState.getInstanceHtml("VALUE_DQ");
    private static final InternalState CDATA_COM_START = InternalState.getInstanceHtml("CDATA_COM_START");
    private static final InternalState CDATA_COM_START_DASH = InternalState.getInstanceHtml("CDATA_COM_START_DASH");
    private static final InternalState CDATA_COM_BODY = InternalState.getInstanceHtml("CDATA_COM_BODY");
    private static final InternalState CDATA_COM_DASH = InternalState.getInstanceHtml("CDATA_COM_DASH");
    private static final InternalState CDATA_COM_DASH_DASH = InternalState.getInstanceHtml("CDATA_COM_DASH_DASH");
    private static final InternalState CDATA_TEXT = InternalState.getInstanceHtml("CDATA_TEXT");
    private static final InternalState CDATA_LT = InternalState.getInstanceHtml("CDATA_LT");
    private static final InternalState CDATA_MAY_CLOSE = InternalState.getInstanceHtml("CDATA_MAY_CLOSE");
    private static final InternalState JS_FILE = InternalState.getInstanceHtml("JS_FILE");
    private static final InternalState CSS_FILE = InternalState.getInstanceHtml("CSS_FILE");
    private static final Map<InternalState, ExternalState> STATE_MAPPING = Maps.newHashMap();
    private static final ParserStateTable STATE_TABLE;
    private final CharacterRecorder tag;
    private final CharacterRecorder attr;
    private final CharacterRecorder value;
    private final CharacterRecorder cdataCloseTag;
    private final EntityResolver entityResolver;
    private final JavascriptParserImpl jsParser;
    private boolean insideJavascript;
    private int valueIndex;
    private boolean textInsideUrlValue;

    public HtmlParserImpl() {
        super(STATE_TABLE, STATE_MAPPING, TEXT);
        this.tag = new CharacterRecorder();
        this.attr = new CharacterRecorder();
        this.value = new CharacterRecorder();
        this.cdataCloseTag = new CharacterRecorder();
        this.entityResolver = new EntityResolver();
        this.jsParser = new JavascriptParserImpl();
        this.insideJavascript = false;
        this.valueIndex = 0;
        this.textInsideUrlValue = false;
    }

    public HtmlParserImpl(HtmlParserImpl htmlParserImpl) {
        super(htmlParserImpl);
        this.tag = new CharacterRecorder(htmlParserImpl.tag);
        this.attr = new CharacterRecorder(htmlParserImpl.attr);
        this.value = new CharacterRecorder(htmlParserImpl.value);
        this.cdataCloseTag = new CharacterRecorder(htmlParserImpl.cdataCloseTag);
        this.entityResolver = new EntityResolver(htmlParserImpl.entityResolver);
        this.jsParser = new JavascriptParserImpl(htmlParserImpl.jsParser);
        this.insideJavascript = htmlParserImpl.insideJavascript;
        this.valueIndex = htmlParserImpl.valueIndex;
        this.textInsideUrlValue = htmlParserImpl.textInsideUrlValue;
    }

    public boolean inJavascript() {
        return this.insideJavascript && (this.getState() == STATE_VALUE || this.currentState == CDATA_TEXT || this.currentState == CDATA_COM_START || this.currentState == CDATA_COM_START_DASH || this.currentState == CDATA_COM_BODY || this.currentState == CDATA_COM_DASH || this.currentState == CDATA_COM_DASH_DASH || this.currentState == CDATA_LT || this.currentState == CDATA_MAY_CLOSE || this.currentState == JS_FILE);
    }

    public boolean isJavascriptQuoted() {
        if (this.inJavascript()) {
            ExternalState externalState = this.jsParser.getState();
            return externalState == JavascriptParserImpl.STATE_Q || externalState == JavascriptParserImpl.STATE_DQ;
        }
        return false;
    }

    public boolean inAttribute() {
        ExternalState externalState = this.getState();
        return externalState != null && (externalState == STATE_ATTR || externalState == STATE_VALUE);
    }

    public boolean inCss() {
        return this.currentState == CSS_FILE || this.getState() == STATE_VALUE && this.getAttributeType() == HtmlParser.ATTR_TYPE.STYLE || "style".equals(this.getTag());
    }

    public HtmlParser.ATTR_TYPE getAttributeType() {
        HtmlUtils.META_REDIRECT_TYPE mETA_REDIRECT_TYPE;
        String string = this.getAttribute();
        if (!this.inAttribute()) {
            return HtmlParser.ATTR_TYPE.NONE;
        }
        if (HtmlUtils.isAttributeJavascript(string)) {
            return HtmlParser.ATTR_TYPE.JS;
        }
        if (HtmlUtils.isAttributeUri(string)) {
            return HtmlParser.ATTR_TYPE.URI;
        }
        if (HtmlUtils.isAttributeStyle(string)) {
            return HtmlParser.ATTR_TYPE.STYLE;
        }
        if ("meta".equals(this.getTag()) && "content".equals(this.getAttribute()) && ((mETA_REDIRECT_TYPE = HtmlUtils.parseContentAttributeForUrl(this.getValue())) == HtmlUtils.META_REDIRECT_TYPE.URL_START || mETA_REDIRECT_TYPE == HtmlUtils.META_REDIRECT_TYPE.URL)) {
            return HtmlParser.ATTR_TYPE.URI;
        }
        return HtmlParser.ATTR_TYPE.REGULAR;
    }

    public ExternalState getJavascriptState() {
        return this.jsParser.getState();
    }

    public boolean isAttributeQuoted() {
        return this.currentState == VALUE_Q_START || this.currentState == VALUE_Q || this.currentState == VALUE_DQ_START || this.currentState == VALUE_DQ;
    }

    public String getTag() {
        return this.tag.getContent().toLowerCase();
    }

    public String getAttribute() {
        return this.inAttribute() ? this.attr.getContent().toLowerCase() : "";
    }

    public String getValue() {
        return this.getState() == STATE_VALUE ? this.value.getContent() : "";
    }

    public int getValueIndex() {
        if (this.getState() != STATE_VALUE) {
            return 0;
        }
        return this.valueIndex;
    }

    public boolean isUrlStart() {
        if (this.getState() != STATE_VALUE) {
            return false;
        }
        if (this.getAttributeType() != HtmlParser.ATTR_TYPE.URI) {
            return false;
        }
        if (this.textInsideUrlValue) {
            return false;
        }
        if ("meta".equals(this.getTag())) {
            return HtmlUtils.parseContentAttributeForUrl(this.getValue()) == HtmlUtils.META_REDIRECT_TYPE.URL_START;
        }
        return this.getValueIndex() == 0;
    }

    public void resetMode(HtmlParser.Mode mode) {
        this.insideJavascript = false;
        this.tag.reset();
        this.attr.reset();
        this.value.reset();
        this.cdataCloseTag.reset();
        this.valueIndex = 0;
        this.textInsideUrlValue = false;
        this.jsParser.reset();
        switch (mode) {
            case HTML: {
                this.currentState = TEXT;
                break;
            }
            case JS: {
                this.currentState = JS_FILE;
                this.insideJavascript = true;
                break;
            }
            case CSS: {
                this.currentState = CSS_FILE;
                break;
            }
            case HTML_IN_TAG: {
                this.currentState = TAG_SPACE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Did not recognize Mode: " + mode.toString());
            }
        }
    }

    public void reset() {
        super.reset();
        this.resetMode(HtmlParser.Mode.HTML);
    }

    public void insertText() throws ParseException {
        if (this.getState() == STATE_VALUE && this.getAttributeType() == HtmlParser.ATTR_TYPE.URI && this.isUrlStart()) {
            this.textInsideUrlValue = true;
        }
        if (this.currentState == VALUE) {
            this.setNextState(VALUE_TEXT);
        }
    }

    protected InternalState handleEnterState(InternalState internalState, InternalState internalState2, char c) {
        InternalState internalState3 = internalState2;
        if (internalState == TAG_NAME) {
            this.enterTagName();
        } else if (internalState == ATTR) {
            this.enterAttribute();
        } else if (internalState == TAG_CLOSE) {
            internalState3 = this.tagClose(internalState);
        } else if (internalState == CDATA_MAY_CLOSE) {
            this.enterStateCdataMayClose();
        } else if (internalState == VALUE) {
            this.enterValue();
        } else if (internalState == VALUE_TEXT || internalState == VALUE_Q || internalState == VALUE_DQ) {
            this.enterValueContent();
        }
        return internalState3;
    }

    protected InternalState handleExitState(InternalState internalState, InternalState internalState2, char c) {
        InternalState internalState3 = internalState2;
        if (internalState == TAG_NAME) {
            this.exitTagName();
        } else if (internalState == ATTR) {
            this.exitAttribute();
        } else if (internalState == CDATA_MAY_CLOSE) {
            internalState3 = this.exitStateCdataMayClose(internalState3, c);
        } else if (internalState == VALUE_TEXT || internalState == VALUE_Q || internalState == VALUE_DQ) {
            this.exitValueContent();
        }
        return internalState3;
    }

    protected InternalState handleInState(InternalState internalState, char c) throws ParseException {
        if (internalState == CDATA_TEXT || internalState == CDATA_COM_START || internalState == CDATA_COM_START_DASH || internalState == CDATA_COM_BODY || internalState == CDATA_COM_DASH || internalState == CDATA_COM_DASH_DASH || internalState == CDATA_LT || internalState == CDATA_MAY_CLOSE || internalState == JS_FILE) {
            this.inStateCdata(c);
        } else if (internalState == VALUE_TEXT || internalState == VALUE_Q || internalState == VALUE_DQ) {
            this.inStateValue(c);
        }
        return internalState;
    }

    protected void record(char c) {
        this.attr.maybeRecord(c);
        this.tag.maybeRecord(c);
        this.value.maybeRecord(c);
        this.cdataCloseTag.maybeRecord(c);
    }

    private void enterTagName() {
        this.tag.startRecording();
    }

    private void exitTagName() {
        this.tag.stopRecording();
        String string = this.tag.getContent();
        if (!string.isEmpty() && string.charAt(0) == '/') {
            this.tag.reset();
        }
    }

    private void enterAttribute() {
        this.attr.startRecording();
    }

    private void exitAttribute() {
        this.attr.stopRecording();
    }

    private void enterValue() {
        this.valueIndex = 0;
        this.textInsideUrlValue = false;
        if (HtmlUtils.isAttributeJavascript(this.getAttribute())) {
            this.entityResolver.reset();
            this.jsParser.reset();
            this.insideJavascript = true;
        } else {
            this.insideJavascript = false;
        }
    }

    private void enterValueContent() {
        this.value.startRecording();
    }

    private void exitValueContent() {
        this.value.stopRecording();
        this.insideJavascript = false;
    }

    private void inStateValue(char c) throws ParseException {
        ++this.valueIndex;
        if (this.insideJavascript) {
            EntityResolver.Status status = this.entityResolver.processChar(c);
            if (status == EntityResolver.Status.COMPLETED) {
                this.jsParser.parse(this.entityResolver.getEntity());
                this.entityResolver.reset();
            } else if (status == EntityResolver.Status.NOT_STARTED) {
                this.jsParser.parse(c);
            }
        }
    }

    private InternalState tagClose(InternalState internalState) {
        InternalState internalState2 = internalState;
        String string = this.getTag();
        if ("script".equals(string)) {
            internalState2 = CDATA_TEXT;
            this.jsParser.reset();
            this.insideJavascript = true;
        } else if ("style".equals(string) || "title".equals(string) || "textarea".equals(string)) {
            internalState2 = CDATA_TEXT;
            this.insideJavascript = false;
        }
        return internalState2;
    }

    private void inStateCdata(char c) throws ParseException {
        if (this.insideJavascript) {
            this.jsParser.parse(c);
        }
    }

    private void enterStateCdataMayClose() {
        this.cdataCloseTag.startRecording();
    }

    private InternalState exitStateCdataMayClose(InternalState internalState, char c) {
        InternalState internalState2 = internalState;
        this.cdataCloseTag.stopRecording();
        String string = this.cdataCloseTag.getContent();
        Preconditions.checkState((!string.isEmpty() && string.charAt(0) == '/' ? 1 : 0) != 0);
        if (string.substring(1).equalsIgnoreCase(this.getTag()) && (c == '>' || HtmlUtils.isHtmlSpace(c))) {
            this.tag.clear();
            this.insideJavascript = false;
        } else {
            internalState2 = CDATA_TEXT;
        }
        return internalState2;
    }

    private static void registerMapping(InternalState internalState, ExternalState externalState) {
        STATE_MAPPING.put(internalState, externalState);
    }

    private static void initializeStateMapping() {
        HtmlParserImpl.registerMapping(InternalState.INTERNAL_ERROR_STATE, HtmlParser.STATE_ERROR);
        HtmlParserImpl.registerMapping(TEXT, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(TAG_START, HtmlParser.STATE_TAG);
        HtmlParserImpl.registerMapping(TAG_NAME, HtmlParser.STATE_TAG);
        HtmlParserImpl.registerMapping(DECL_START, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(DECL_BODY, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(COM_OPEN, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(COM_BODY, HtmlParser.STATE_COMMENT);
        HtmlParserImpl.registerMapping(COM_DASH, HtmlParser.STATE_COMMENT);
        HtmlParserImpl.registerMapping(COM_DASH_DASH, HtmlParser.STATE_COMMENT);
        HtmlParserImpl.registerMapping(PI, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(PI_MAY_END, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(TAG_SPACE, HtmlParser.STATE_TAG);
        HtmlParserImpl.registerMapping(TAG_CLOSE, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(ATTR, HtmlParser.STATE_ATTR);
        HtmlParserImpl.registerMapping(ATTR_SPACE, HtmlParser.STATE_ATTR);
        HtmlParserImpl.registerMapping(VALUE, HtmlParser.STATE_VALUE);
        HtmlParserImpl.registerMapping(VALUE_TEXT, HtmlParser.STATE_VALUE);
        HtmlParserImpl.registerMapping(VALUE_Q_START, HtmlParser.STATE_VALUE);
        HtmlParserImpl.registerMapping(VALUE_Q, HtmlParser.STATE_VALUE);
        HtmlParserImpl.registerMapping(VALUE_DQ_START, HtmlParser.STATE_VALUE);
        HtmlParserImpl.registerMapping(VALUE_DQ, HtmlParser.STATE_VALUE);
        HtmlParserImpl.registerMapping(CDATA_COM_START, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(CDATA_COM_START_DASH, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(CDATA_COM_BODY, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(CDATA_COM_DASH, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(CDATA_COM_DASH_DASH, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(CDATA_TEXT, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(CDATA_LT, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(CDATA_MAY_CLOSE, HtmlParser.STATE_TEXT);
        HtmlParserImpl.registerMapping(JS_FILE, HtmlParser.STATE_JS_FILE);
        HtmlParserImpl.registerMapping(CSS_FILE, HtmlParser.STATE_CSS_FILE);
    }

    private static void registerTransition(String string, InternalState internalState, InternalState internalState2) {
        StateTableTransition stateTableTransition = new StateTableTransition(string, internalState, internalState2);
        STATE_TABLE.setExpression(stateTableTransition.getExpression(), stateTableTransition.getFrom(), stateTableTransition.getTo());
    }

    private static void initializeParserStateTable() {
        HtmlParserImpl.registerTransition("[:default:]", CSS_FILE, CSS_FILE);
        HtmlParserImpl.registerTransition("[:default:]", JS_FILE, JS_FILE);
        HtmlParserImpl.registerTransition("[:default:]", CDATA_MAY_CLOSE, CDATA_TEXT);
        HtmlParserImpl.registerTransition(" \t\n\r", CDATA_MAY_CLOSE, TAG_SPACE);
        HtmlParserImpl.registerTransition(">", CDATA_MAY_CLOSE, TEXT);
        HtmlParserImpl.registerTransition("A-Za-z0-9/_:-", CDATA_MAY_CLOSE, CDATA_MAY_CLOSE);
        HtmlParserImpl.registerTransition("[:default:]", CDATA_LT, CDATA_TEXT);
        HtmlParserImpl.registerTransition("!", CDATA_LT, CDATA_COM_START);
        HtmlParserImpl.registerTransition("/", CDATA_LT, CDATA_MAY_CLOSE);
        HtmlParserImpl.registerTransition("[:default:]", CDATA_TEXT, CDATA_TEXT);
        HtmlParserImpl.registerTransition("<", CDATA_TEXT, CDATA_LT);
        HtmlParserImpl.registerTransition("[:default:]", CDATA_COM_DASH_DASH, CDATA_COM_BODY);
        HtmlParserImpl.registerTransition(">", CDATA_COM_DASH_DASH, CDATA_TEXT);
        HtmlParserImpl.registerTransition("-", CDATA_COM_DASH_DASH, CDATA_COM_DASH_DASH);
        HtmlParserImpl.registerTransition("[:default:]", CDATA_COM_DASH, CDATA_COM_BODY);
        HtmlParserImpl.registerTransition("-", CDATA_COM_DASH, CDATA_COM_DASH_DASH);
        HtmlParserImpl.registerTransition("[:default:]", CDATA_COM_BODY, CDATA_COM_BODY);
        HtmlParserImpl.registerTransition("-", CDATA_COM_BODY, CDATA_COM_DASH);
        HtmlParserImpl.registerTransition("[:default:]", CDATA_COM_START_DASH, CDATA_TEXT);
        HtmlParserImpl.registerTransition("-", CDATA_COM_START_DASH, CDATA_COM_BODY);
        HtmlParserImpl.registerTransition("[:default:]", CDATA_COM_START, CDATA_TEXT);
        HtmlParserImpl.registerTransition("-", CDATA_COM_START, CDATA_COM_START_DASH);
        HtmlParserImpl.registerTransition("[:default:]", VALUE_DQ, VALUE_DQ);
        HtmlParserImpl.registerTransition("\"", VALUE_DQ, TAG_SPACE);
        HtmlParserImpl.registerTransition("[:default:]", VALUE_DQ_START, VALUE_DQ);
        HtmlParserImpl.registerTransition("\"", VALUE_DQ_START, TAG_SPACE);
        HtmlParserImpl.registerTransition("[:default:]", VALUE_Q, VALUE_Q);
        HtmlParserImpl.registerTransition("'", VALUE_Q, TAG_SPACE);
        HtmlParserImpl.registerTransition("[:default:]", VALUE_Q_START, VALUE_Q);
        HtmlParserImpl.registerTransition("'", VALUE_Q_START, TAG_SPACE);
        HtmlParserImpl.registerTransition("[:default:]", VALUE_TEXT, VALUE_TEXT);
        HtmlParserImpl.registerTransition(" \t\n\r", VALUE_TEXT, TAG_SPACE);
        HtmlParserImpl.registerTransition(">", VALUE_TEXT, TAG_CLOSE);
        HtmlParserImpl.registerTransition("[:default:]", VALUE, VALUE_TEXT);
        HtmlParserImpl.registerTransition(">", VALUE, TAG_CLOSE);
        HtmlParserImpl.registerTransition(" \t\n\r", VALUE, VALUE);
        HtmlParserImpl.registerTransition("\"", VALUE, VALUE_DQ_START);
        HtmlParserImpl.registerTransition("'", VALUE, VALUE_Q_START);
        HtmlParserImpl.registerTransition("=", ATTR_SPACE, VALUE);
        HtmlParserImpl.registerTransition("/", ATTR_SPACE, TAG_SPACE);
        HtmlParserImpl.registerTransition("A-Za-z0-9_:-", ATTR_SPACE, ATTR);
        HtmlParserImpl.registerTransition(" \t\n\r", ATTR_SPACE, ATTR_SPACE);
        HtmlParserImpl.registerTransition(">", ATTR_SPACE, TAG_CLOSE);
        HtmlParserImpl.registerTransition(" \t\n\r", ATTR, ATTR_SPACE);
        HtmlParserImpl.registerTransition("=", ATTR, VALUE);
        HtmlParserImpl.registerTransition("/", ATTR, TAG_SPACE);
        HtmlParserImpl.registerTransition(">", ATTR, TAG_CLOSE);
        HtmlParserImpl.registerTransition("A-Za-z0-9_:.-", ATTR, ATTR);
        HtmlParserImpl.registerTransition("[:default:]", TAG_CLOSE, TEXT);
        HtmlParserImpl.registerTransition("<", TAG_CLOSE, TAG_START);
        HtmlParserImpl.registerTransition("/", TAG_SPACE, TAG_SPACE);
        HtmlParserImpl.registerTransition("A-Za-z0-9_:-", TAG_SPACE, ATTR);
        HtmlParserImpl.registerTransition(" \t\n\r", TAG_SPACE, TAG_SPACE);
        HtmlParserImpl.registerTransition(">", TAG_SPACE, TAG_CLOSE);
        HtmlParserImpl.registerTransition("[:default:]", PI_MAY_END, PI);
        HtmlParserImpl.registerTransition(">", PI_MAY_END, TEXT);
        HtmlParserImpl.registerTransition("[:default:]", PI, PI);
        HtmlParserImpl.registerTransition("?", PI, PI_MAY_END);
        HtmlParserImpl.registerTransition("[:default:]", COM_DASH_DASH, COM_BODY);
        HtmlParserImpl.registerTransition(">", COM_DASH_DASH, TEXT);
        HtmlParserImpl.registerTransition("-", COM_DASH_DASH, COM_DASH_DASH);
        HtmlParserImpl.registerTransition("[:default:]", COM_DASH, COM_BODY);
        HtmlParserImpl.registerTransition("-", COM_DASH, COM_DASH_DASH);
        HtmlParserImpl.registerTransition("[:default:]", COM_BODY, COM_BODY);
        HtmlParserImpl.registerTransition("-", COM_BODY, COM_DASH);
        HtmlParserImpl.registerTransition("[:default:]", COM_OPEN, TEXT);
        HtmlParserImpl.registerTransition("-", COM_OPEN, COM_BODY);
        HtmlParserImpl.registerTransition("[:default:]", DECL_BODY, DECL_BODY);
        HtmlParserImpl.registerTransition(">", DECL_BODY, TEXT);
        HtmlParserImpl.registerTransition("[:default:]", DECL_START, DECL_BODY);
        HtmlParserImpl.registerTransition(">", DECL_START, TEXT);
        HtmlParserImpl.registerTransition("-", DECL_START, COM_OPEN);
        HtmlParserImpl.registerTransition(">", TAG_NAME, TAG_CLOSE);
        HtmlParserImpl.registerTransition(" \t\n\r", TAG_NAME, TAG_SPACE);
        HtmlParserImpl.registerTransition("A-Za-z0-9/_:-", TAG_NAME, TAG_NAME);
        HtmlParserImpl.registerTransition("[:default:]", TAG_START, TEXT);
        HtmlParserImpl.registerTransition("<", TAG_START, TAG_START);
        HtmlParserImpl.registerTransition("!", TAG_START, DECL_START);
        HtmlParserImpl.registerTransition("?", TAG_START, PI);
        HtmlParserImpl.registerTransition("A-Za-z0-9/_:-", TAG_START, TAG_NAME);
        HtmlParserImpl.registerTransition("[:default:]", TEXT, TEXT);
        HtmlParserImpl.registerTransition("<", TEXT, TAG_START);
    }

    static {
        HtmlParserImpl.initializeStateMapping();
        STATE_TABLE = new ParserStateTable();
        HtmlParserImpl.initializeParserStateTable();
    }
}

