/*
 * Decompiled with CFR 0.152.
 */
package com.google.streamhtmlparser.impl;

import com.google.common.base.Preconditions;
import com.google.streamhtmlparser.impl.InternalState;

class ParserStateTable {
    private static final int MAX_STATES = 256;
    private static final int MAX_CHARS = 256;
    private final InternalState[][] stateTable = new InternalState[256][256];
    private final InternalState[] defaultStateTable = new InternalState[256];

    InternalState getNextState(InternalState internalState, int n) {
        if (internalState == null || n < 0) {
            return InternalState.INTERNAL_ERROR_STATE;
        }
        int n2 = internalState.getId();
        if (n2 < 0 || n2 >= 256) {
            return InternalState.INTERNAL_ERROR_STATE;
        }
        InternalState internalState2 = null;
        if (n < 256) {
            internalState2 = this.stateTable[n2][n];
        }
        if (internalState2 == null) {
            internalState2 = this.defaultStateTable[internalState.getId()];
        }
        return internalState2 != null ? internalState2 : InternalState.INTERNAL_ERROR_STATE;
    }

    void setExpression(String string, InternalState internalState, InternalState internalState2) {
        if (string == null || internalState == null || internalState2 == null) {
            return;
        }
        if ("[:default:]".equals(string)) {
            this.setDefaultDestination(internalState, internalState2);
            return;
        }
        int n = 0;
        while (n < string.length()) {
            if (n < string.length() - 2 && string.charAt(n + 1) == '-') {
                this.setRange(internalState, string.charAt(n), string.charAt(n + 2), internalState2);
                n += 2;
                continue;
            }
            this.setDestination(internalState, string.charAt(n), internalState2);
            ++n;
        }
    }

    private void fill(InternalState internalState, InternalState internalState2) {
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            this.setDestination(internalState, c, internalState2);
        }
    }

    private void setDefaultDestination(InternalState internalState, InternalState internalState2) {
        Preconditions.checkNotNull((Object)internalState);
        Preconditions.checkNotNull((Object)internalState2);
        int n = internalState.getId();
        if (n < 0 || n >= 256) {
            return;
        }
        this.defaultStateTable[internalState.getId()] = internalState2;
    }

    private void setDestination(InternalState internalState, char c, InternalState internalState2) {
        Preconditions.checkNotNull((Object)internalState);
        Preconditions.checkNotNull((Object)internalState2);
        Preconditions.checkArgument((c >= '\u0000' && c < '\u0100' ? 1 : 0) != 0, (String)"char must be in ASCII set: %c", (Object[])new Object[]{Character.valueOf(c)});
        int n = internalState.getId();
        if (n < 0 || n >= 256) {
            return;
        }
        this.stateTable[internalState.getId()][c] = internalState2;
    }

    private void setRange(InternalState internalState, char c, char c2, InternalState internalState2) {
        Preconditions.checkArgument((c >= '\u0000' && c < '\u0100' ? 1 : 0) != 0, (String)"char must be in ASCII set: %c", (Object[])new Object[]{Character.valueOf(c)});
        Preconditions.checkArgument((c2 >= '\u0000' && c2 < '\u0100' ? 1 : 0) != 0, (String)"char must be in ASCII set: %c", (Object[])new Object[]{Character.valueOf(c2)});
        for (char c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
            this.setDestination(internalState, c3, internalState2);
        }
    }
}

