/*
 * Decompiled with CFR 0.152.
 */
package com.google.streamhtmlparser.util;

import com.google.common.base.Preconditions;
import com.google.streamhtmlparser.util.HtmlUtils;
import java.util.Arrays;

public class JavascriptTokenBuffer {
    private static final int BUFFER_SIZE = 18;
    private final char[] buffer;
    private int startIndex;
    private int endIndex;

    public JavascriptTokenBuffer() {
        this.buffer = new char[18];
        this.startIndex = 0;
        this.endIndex = 0;
    }

    public JavascriptTokenBuffer(JavascriptTokenBuffer javascriptTokenBuffer) {
        this.buffer = Arrays.copyOf(javascriptTokenBuffer.buffer, javascriptTokenBuffer.buffer.length);
        this.startIndex = javascriptTokenBuffer.startIndex;
        this.endIndex = javascriptTokenBuffer.endIndex;
    }

    public void appendString(String string) {
        if (string == null) {
            throw new NullPointerException("input == null is not allowed");
        }
        for (int i = 0; i < string.length(); ++i) {
            this.appendChar(string.charAt(i));
        }
    }

    public void appendChar(char c) {
        if (HtmlUtils.isJavascriptWhitespace(c) && HtmlUtils.isJavascriptWhitespace(this.getChar(-1))) {
            return;
        }
        this.buffer[this.endIndex] = c;
        this.endIndex = (this.endIndex + 1) % this.buffer.length;
        if (this.endIndex == this.startIndex) {
            this.startIndex = (this.endIndex + 1) % this.buffer.length;
        }
    }

    public char popChar() {
        if (this.startIndex == this.endIndex) {
            return '\u0000';
        }
        --this.endIndex;
        if (this.endIndex < 0) {
            this.endIndex += this.buffer.length;
        }
        return this.buffer[this.endIndex];
    }

    public char getChar(int n) {
        assert (n < 0);
        int n2 = this.getAbsolutePosition(n);
        if (n2 < 0) {
            return '\u0000';
        }
        return this.buffer[n2];
    }

    public boolean setChar(int n, char c) {
        assert (n < 0);
        int n2 = this.getAbsolutePosition(n);
        if (n2 < 0) {
            return false;
        }
        this.buffer[n2] = c;
        return true;
    }

    public String getLastIdentifier() {
        int n = -1;
        if (HtmlUtils.isJavascriptWhitespace(this.getChar(-1))) {
            --n;
        }
        int n2 = n;
        while (HtmlUtils.isJavascriptIdentifier(this.getChar(n2))) {
            --n2;
        }
        if (n2 + 1 >= n) {
            return null;
        }
        return this.slice(n2 + 1, n);
    }

    public String slice(int n, int n2) {
        Preconditions.checkArgument((n <= n2 ? 1 : 0) != 0);
        Preconditions.checkArgument((n < 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 < 0 ? 1 : 0) != 0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2; ++i) {
            char c = this.getChar(i);
            if (c == '\u0000') continue;
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    private int getAbsolutePosition(int n) {
        assert (n < 0);
        if (n <= -this.buffer.length) {
            return -1;
        }
        int n2 = this.endIndex - this.startIndex;
        if (n2 < 0) {
            n2 += this.buffer.length;
        }
        if (n < -n2) {
            return -1;
        }
        int n3 = (n + this.endIndex) % this.buffer.length;
        if (n3 < 0) {
            n3 += this.buffer.length;
        }
        return n3;
    }
}

